/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.datagen.crafting;

import com.black_dog20.bml.init.BmlCrafting;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ShapelessNBTRecipeBuilder
extends ShapelessRecipeBuilder {
    private static final Method VALIDATE = ObfuscationReflectionHelper.findMethod(ShapelessRecipeBuilder.class, (String)"ensureValid", (Class[])new Class[]{ResourceLocation.class});
    private static final Field ADVANCEMENT_BUILDER = ObfuscationReflectionHelper.findField(ShapelessRecipeBuilder.class, (String)"advancement");
    private static final Field GROUP = ObfuscationReflectionHelper.findField(ShapelessRecipeBuilder.class, (String)"group");
    private static final Field INGREDIENTS = ObfuscationReflectionHelper.findField(ShapelessRecipeBuilder.class, (String)"ingredients");
    private final RecipeCategory category;
    private final ItemStack result;
    private final RecipeSerializer<?> serializer;
    private String itemGroup;

    private ShapelessNBTRecipeBuilder(RecipeCategory category, ItemStack result) {
        super(category, (ItemLike)result.m_41720_(), result.m_41613_());
        this.category = category;
        this.result = result;
        this.serializer = (RecipeSerializer)BmlCrafting.SHAPELESS_NBT.get();
    }

    private ShapelessNBTRecipeBuilder(RecipeCategory category, ItemStack result, RecipeSerializer<?> serializer) {
        super(category, (ItemLike)result.m_41720_(), result.m_41613_());
        this.category = category;
        this.result = result;
        this.serializer = serializer;
    }

    public static ShapelessNBTRecipeBuilder shapelessNBTRecipe(RecipeCategory category, ItemStack result) {
        return new ShapelessNBTRecipeBuilder(category, result);
    }

    public static ShapelessNBTRecipeBuilder customShapelessNBTRecipe(RecipeCategory category, ItemStack result, RecipeSerializer<?> serializer) {
        return new ShapelessNBTRecipeBuilder(category, result, serializer);
    }

    public ShapelessNBTRecipeBuilder setItemGroup(String group) {
        this.itemGroup = group;
        return this;
    }

    public ShapelessNBTRecipeBuilder requires(TagKey<Item> tag) {
        return (ShapelessNBTRecipeBuilder)super.m_206419_(tag);
    }

    public ShapelessNBTRecipeBuilder requires(ItemLike item) {
        return (ShapelessNBTRecipeBuilder)super.m_126209_(item);
    }

    public ShapelessNBTRecipeBuilder requires(ItemLike item, int count) {
        return (ShapelessNBTRecipeBuilder)super.m_126211_(item, count);
    }

    public ShapelessNBTRecipeBuilder requires(Ingredient ingredient) {
        return (ShapelessNBTRecipeBuilder)super.m_126184_(ingredient);
    }

    public ShapelessNBTRecipeBuilder requires(Ingredient ingredient, int count) {
        return (ShapelessNBTRecipeBuilder)super.m_126186_(ingredient, count);
    }

    public ShapelessNBTRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterion) {
        return (ShapelessNBTRecipeBuilder)super.m_126132_(name, criterion);
    }

    public ShapelessNBTRecipeBuilder group(String group) {
        return (ShapelessNBTRecipeBuilder)super.m_126145_(group);
    }

    public void m_176498_(Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()));
    }

    public void m_176500_(Consumer<FinishedRecipe> consumer, String save) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_());
        if (new ResourceLocation(save).equals((Object)registryName)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.m_126140_(consumer, new ResourceLocation(save));
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        try {
            String itemGroupName;
            VALIDATE.invoke((Object)this, id);
            Advancement.Builder advancementBuilder = ((Advancement.Builder)ADVANCEMENT_BUILDER.get((Object)this)).m_138396_(new ResourceLocation("minecraft", "recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            String group = (String)GROUP.get((Object)this);
            if (group == null) {
                group = "";
            }
            if ((itemGroupName = this.itemGroup) == null) {
                itemGroupName = this.category.m_247710_();
            }
            List ingredients = (List)INGREDIENTS.get((Object)this);
            ResourceLocation advancementID = new ResourceLocation(id.m_135827_(), "recipes/" + itemGroupName + "/" + id.m_135815_());
            consumer.accept((FinishedRecipe)new Result(id, this.result, group, ingredients, advancementBuilder, advancementID, this.serializer));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to build Shapeless NBT Recipe " + id, e);
        }
    }

    public class Result
    extends ShapelessRecipeBuilder.Result {
        private final CompoundTag resultNBT;
        private final RecipeSerializer<?> serializer;

        private Result(ResourceLocation id, ItemStack result, String group, List<Ingredient> ingredients, Advancement.Builder advancementBuilder, ResourceLocation advancementID, RecipeSerializer<?> serializer) {
            super(id, result.m_41720_(), result.m_41613_(), group, ShapelessNBTRecipeBuilder.m_245179_((RecipeCategory)ShapelessNBTRecipeBuilder.this.category), ingredients, advancementBuilder, advancementID);
            this.resultNBT = result.m_41783_();
            this.serializer = serializer;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            if (this.resultNBT != null) {
                json.getAsJsonObject("result").addProperty("nbt", this.resultNBT.toString());
            }
        }
    }
}

