/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.datagen.crafting;

import com.black_dog20.bml.init.BmlCrafting;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ShapedNBTRecipeBuilder
extends ShapedRecipeBuilder {
    private static final Method VALIDATE = ObfuscationReflectionHelper.findMethod(ShapedRecipeBuilder.class, (String)"ensureValid", (Class[])new Class[]{ResourceLocation.class});
    private static final Field ADVANCEMENT_BUILDER = ObfuscationReflectionHelper.findField(ShapedRecipeBuilder.class, (String)"advancement");
    private static final Field GROUP = ObfuscationReflectionHelper.findField(ShapedRecipeBuilder.class, (String)"group");
    private static final Field PATTERN = ObfuscationReflectionHelper.findField(ShapedRecipeBuilder.class, (String)"rows");
    private static final Field KEY = ObfuscationReflectionHelper.findField(ShapedRecipeBuilder.class, (String)"key");
    private final RecipeCategory category;
    private final ItemStack result;
    private final RecipeSerializer<?> serializer;
    private String itemGroup;

    private ShapedNBTRecipeBuilder(RecipeCategory category, ItemStack result) {
        super(category, (ItemLike)result.m_41720_(), result.m_41613_());
        this.category = category;
        this.result = result;
        this.serializer = (RecipeSerializer)BmlCrafting.SHAPED_NBT.get();
    }

    private ShapedNBTRecipeBuilder(RecipeCategory category, ItemStack result, RecipeSerializer<?> serializer) {
        super(category, (ItemLike)result.m_41720_(), result.m_41613_());
        this.category = category;
        this.result = result;
        this.serializer = serializer;
    }

    public static ShapedNBTRecipeBuilder shapedNBTRecipe(RecipeCategory category, ItemStack result) {
        return new ShapedNBTRecipeBuilder(category, result);
    }

    public static ShapedNBTRecipeBuilder customShapedNBTRecipe(RecipeCategory category, ItemStack result, RecipeSerializer<?> serializer) {
        return new ShapedNBTRecipeBuilder(category, result, serializer);
    }

    public ShapedNBTRecipeBuilder setItemGroup(String group) {
        this.itemGroup = group;
        return this;
    }

    public ShapedNBTRecipeBuilder define(Character symbol, TagKey<Item> tag) {
        return (ShapedNBTRecipeBuilder)super.m_206416_(symbol, tag);
    }

    public ShapedNBTRecipeBuilder define(Character symbol, ItemLike item) {
        return (ShapedNBTRecipeBuilder)super.m_126127_(symbol, item);
    }

    public ShapedNBTRecipeBuilder define(Character symbol, Ingredient ingredient) {
        return (ShapedNBTRecipeBuilder)super.m_126124_(symbol, ingredient);
    }

    public ShapedNBTRecipeBuilder pattern(String pattern) {
        return (ShapedNBTRecipeBuilder)super.m_126130_(pattern);
    }

    public ShapedNBTRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterion) {
        return (ShapedNBTRecipeBuilder)super.m_126132_(name, criterion);
    }

    public ShapedNBTRecipeBuilder group(String group) {
        return (ShapedNBTRecipeBuilder)super.m_126145_(group);
    }

    public ShapedNBTRecipeBuilder showNotification(boolean showNotification) {
        return (ShapedNBTRecipeBuilder)super.m_271710_(showNotification);
    }

    public void m_176498_(Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()));
    }

    public void m_176500_(Consumer<FinishedRecipe> consumer, String save) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_());
        if (new ResourceLocation(save).equals((Object)registryName)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.m_126140_(consumer, new ResourceLocation(save));
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        try {
            VALIDATE.invoke((Object)this, id);
            Advancement.Builder advancementBuilder = ((Advancement.Builder)ADVANCEMENT_BUILDER.get((Object)this)).m_138396_(new ResourceLocation("minecraft", "recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            String group = (String)GROUP.get((Object)this);
            if (group == null) {
                group = "";
            }
            List pattern = (List)PATTERN.get((Object)this);
            Map key = (Map)KEY.get((Object)this);
            String itemGroupName = this.itemGroup;
            if (itemGroupName == null) {
                itemGroupName = this.category.m_247710_();
            }
            ResourceLocation advancementID = new ResourceLocation(id.m_135827_(), "recipes/" + itemGroupName + "/" + id.m_135815_());
            consumer.accept((FinishedRecipe)new Result(id, this.result, group, pattern, key, advancementBuilder, advancementID, this.serializer, this.f_271093_));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to build Shaped NBT Recipe " + id, e);
        }
    }

    public class Result
    extends ShapedRecipeBuilder.Result {
        private final CompoundTag resultNBT;
        private final RecipeSerializer<?> serializer;

        private Result(ResourceLocation id, ItemStack result, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancementBuilder, ResourceLocation advancementID, RecipeSerializer<?> serializer, boolean showNotification) {
            super(id, result.m_41720_(), result.m_41613_(), group, ShapedNBTRecipeBuilder.m_245179_((RecipeCategory)ShapedNBTRecipeBuilder.this.category), pattern, key, advancementBuilder, advancementID, showNotification);
            this.resultNBT = result.m_41783_();
            this.serializer = serializer;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            if (this.resultNBT != null) {
                json.getAsJsonObject("result").addProperty("nbt", this.resultNBT.toString());
            }
        }
    }
}

