/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.crafting;

import com.black_dog20.bml.crafting.RecipeUtil;
import com.black_dog20.bml.crafting.ShapelessNBTRecipeConsumer;
import com.black_dog20.bml.init.BmlCrafting;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;

public class ShapelessNBTRecipe
extends ShapelessRecipe {
    public ShapelessNBTRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack recipeOutput, NonNullList<Ingredient> recipeItems) {
        super(id, group, category, recipeOutput, recipeItems);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BmlCrafting.SHAPELESS_NBT.get();
    }

    public static Supplier<Serializer> factory() {
        return () -> new Serializer(ShapelessNBTRecipe::new);
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessRecipe> {
        private final ShapelessNBTRecipeConsumer consumer;

        public Serializer(ShapelessNBTRecipeConsumer consumer) {
            this.consumer = consumer;
        }

        public ShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtil.parseShapeless(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            return this.consumer.create(recipeId, group, category, result, ingredients);
        }

        public ShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int numIngredients = buffer.m_130242_();
            String category = buffer.m_130136_(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.m_122780_((int)numIngredients, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return this.consumer.create(recipeId, group, (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(category, (Enum)CraftingBookCategory.MISC), result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            buffer.m_130070_(recipe.m_245232_().m_7912_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.f_44243_);
        }
    }
}

