/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.crafting;

import com.black_dog20.bml.crafting.RecipeUtil;
import com.black_dog20.bml.crafting.ShapedNBTRecipeConsumer;
import com.black_dog20.bml.init.BmlCrafting;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;

public class ShapedNBTRecipe
extends ShapedRecipe {
    public ShapedNBTRecipe(ResourceLocation id, String group, CraftingBookCategory category, int recipeWidth, int recipeHeight, NonNullList<Ingredient> ingredients, ItemStack recipeOutput) {
        super(id, group, category, recipeWidth, recipeHeight, ingredients, recipeOutput);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BmlCrafting.SHAPED_NBT.get();
    }

    public static Supplier<Serializer> factory() {
        return () -> new Serializer(ShapedNBTRecipe::new);
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipe> {
        private final ShapedNBTRecipeConsumer consumer;

        public Serializer(ShapedNBTRecipeConsumer consumer) {
            this.consumer = consumer;
        }

        public ShapedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            RecipeUtil.ShapedPrimer primer = RecipeUtil.parseShaped(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            return this.consumer.create(recipeId, group, category, primer.getRecipeWidth(), primer.getRecipeHeight(), primer.getIngredients(), result);
        }

        public ShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            String group = buffer.m_130136_(Short.MAX_VALUE);
            String category = buffer.m_130136_(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            return this.consumer.create(recipeId, group, (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(category, (Enum)CraftingBookCategory.MISC), i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedRecipe recipe) {
            buffer.m_130130_(recipe.getRecipeWidth());
            buffer.m_130130_(recipe.getRecipeHeight());
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130070_(recipe.m_245232_().m_7912_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.f_44149_);
        }
    }
}

