/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.compat;

import com.black_dog20.bml.compat.ModCompatPlugin;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class ModCompatPluginFinder {
    public static void registerModcompatToEventBus(String sourceModId) {
        Type annotationType = Type.getType(ModCompatPlugin.class);
        List allScanData = ModList.get().getAllScanData();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (!Objects.equals(a.annotationType(), annotationType)) continue;
                boolean hasSourceModId = ModCompatPluginFinder.hasCorrectSourceModId(a, sourceModId);
                boolean targetModIdLoaded = ModCompatPluginFinder.isTargetModLoaded(a);
                if (!hasSourceModId || !targetModIdLoaded) continue;
                String className = a.memberName();
                try {
                    Class<?> asmClass = Class.forName(className);
                    Constructor<?> constructor = asmClass.getDeclaredConstructor(new Class[0]);
                    MinecraftForge.EVENT_BUS.register(constructor.newInstance(new Object[0]));
                }
                catch (LinkageError | ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean hasCorrectSourceModId(ModFileScanData.AnnotationData data, String sourceModId) {
        return Optional.ofNullable(data.annotationData().get("sourceMod")).filter(String.class::isInstance).map(String.class::cast).map(sourceModId::equals).orElse(false);
    }

    private static boolean isTargetModLoaded(ModFileScanData.AnnotationData data) {
        return Optional.ofNullable(data.annotationData().get("targetMods")).filter(String[].class::isInstance).map(String[].class::cast).map(Arrays::asList).stream().flatMap(Collection::stream).allMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
    }
}

