/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.client.rows.columns;

import com.black_dog20.bml.client.rows.RowDrawingContext;
import com.black_dog20.bml.client.rows.columns.Column;
import com.black_dog20.bml.utils.text.TextUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;

public class StringColumn
extends Column {
    private final String text;

    protected StringColumn(String id, String text, Column.Alignment alignment) {
        super(id, alignment);
        this.text = text;
    }

    public static StringColumn of(String id, String text) {
        return new StringColumn(id, text, Column.Alignment.LEFT);
    }

    public static StringColumn of(String id, String text, Column.Alignment alignment) {
        return new StringColumn(id, text, alignment);
    }

    @Override
    public int getWidth() {
        if (this.hasValue()) {
            return Minecraft.m_91087_().f_91062_.m_92895_(this.text);
        }
        return 0;
    }

    @Override
    public void render(RowDrawingContext context) {
        if (this.hasValue()) {
            float x = context.x;
            int valueWidth = context.fontRenderer.m_92895_(this.text);
            switch (this.alignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    x += (float)(context.columnMaxWidth - valueWidth);
                    break;
                }
                case CENTER: {
                    x += (float)context.columnMaxWidth / 2.0f - (float)valueWidth / 2.0f;
                }
            }
            context.guiGraphics.m_280056_(context.fontRenderer, this.text, (int)x, (int)context.y, -1, true);
        }
    }

    @Override
    public int getHeight() {
        if (this.hasValue()) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return 9;
        }
        return 0;
    }

    private boolean hasValue() {
        return TextUtil.isNotNullOrEmpty(this.text);
    }
}

