/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.client.rows;

import com.black_dog20.bml.client.DrawingContext;
import com.black_dog20.bml.client.rows.RowDrawingContext;
import com.black_dog20.bml.client.rows.RowHelper;
import com.black_dog20.bml.client.rows.columns.Column;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class Row {
    private final LinkedList<Column> columns;

    private Row(RowBuilder builder) {
        this.columns = builder.columns;
    }

    public int render(DrawingContext context, Map<String, Integer> columnWidth) {
        int currentX = (int)context.x;
        for (Column column : this.columns) {
            int width = columnWidth.getOrDefault(column.getId(), 0);
            column.render(RowDrawingContext.of(context, currentX, context.y, width));
            currentX += width;
        }
        return RowHelper.getHeight(this);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public static final class RowBuilder {
        private LinkedList<Column> columns = new LinkedList();

        public RowBuilder withColumn(Column column) {
            this.columns.add(column);
            return this;
        }

        public RowBuilder withColumn(Column column, Supplier<Boolean> shouldAdd) {
            if (Boolean.TRUE.equals(shouldAdd.get())) {
                return this.withColumn(column);
            }
            return this;
        }

        public Row build() {
            return new Row(this);
        }
    }
}

