/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.client.radial.api;

import com.black_dog20.bml.client.radial.api.RadialDrawingContext;
import com.black_dog20.bml.client.radial.api.items.IRadialCategory;
import com.black_dog20.bml.client.radial.api.items.IRadialItem;
import com.black_dog20.bml.internal.utils.InternalTranslations;
import com.black_dog20.bml.utils.text.TextUtil;
import com.black_dog20.bml.utils.translate.ITranslation;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="blackdogsmoddinglibrary")
public abstract class AbstractRadialMenu
extends Screen {
    private static final float PRECISION = 0.0069444445f;
    private static final double TWO_PI = Math.PI * 2;
    private State state = State.INITIALIZING;
    public double startAnimation;
    public float animationProgress;
    public float radiusIn;
    public float radiusOut;
    public float itemRadius;
    public float animationTop;
    private List<IRadialItem> items;
    private List<IRadialItem> visibleItems;
    private int maxPages;
    private int currentPage;

    public AbstractRadialMenu(Component title, List<IRadialItem> items) {
        super(title);
        this.changeItems(items);
        Minecraft minecraft = Minecraft.m_91087_();
        this.startAnimation = (double)minecraft.f_91073_.m_46467_() + (double)minecraft.m_91296_();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public abstract boolean isKeyDown();

    public abstract boolean shouldDrawCenterText();

    public abstract boolean ShouldClipMouseToCircle();

    public abstract boolean allowClickOutsideBounds();

    public float getRadiusInModifier() {
        return 1.0f;
    }

    public int getMaxItemsPerPage() {
        return 7;
    }

    public int getBackgroundColor() {
        return 0x3F000000;
    }

    public int getBackgroundColorHover() {
        return 0x3FFFFFFF;
    }

    public float getOpenAnimationLength() {
        return 2.5f;
    }

    public void drawFooter(GuiGraphics guiGraphics, float width, float y, float radiusOut) {
        MutableComponent pageString = InternalTranslations.translate((ITranslation)InternalTranslations.Translations.PAGE_FOOTER, this.currentPage, this.maxPages);
        String text = TextUtil.getFormattedText((Component)pageString);
        guiGraphics.drawString(this.f_96547_, text, (width - (float)this.f_96547_.m_92852_((FormattedText)pageString)) / 2.0f, y, -1, true);
    }

    public void drawHeader(PoseStack poseStack, float width, float y, float radiusOut) {
    }

    public void drawExtras(PoseStack poseStack, float radiusOut) {
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public boolean isReady() {
        return this.state == State.NORMAL;
    }

    public IRadialItem getHoveredItem() {
        for (IRadialItem item : this.visibleItems) {
            if (!item.isHovered()) continue;
            return item;
        }
        return null;
    }

    private void setHovered(int which) {
        for (int i = 0; i < this.visibleItems.size(); ++i) {
            this.visibleItems.get(i).setHovered(i == which);
        }
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiOverlayEvent.Pre event) {
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ instanceof AbstractRadialMenu) {
            event.setCanceled(true);
        }
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        this.processClick(true, state);
        return super.m_6348_(mouseX, mouseY, state);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.state == State.INITIALIZING) {
            this.startAnimation = (double)this.f_96541_.f_91073_.m_46467_() + (double)this.f_96541_.m_91296_();
            this.state = State.OPENING;
            this.animationProgress = 0.0f;
        }
        if (this.isClosed()) {
            Minecraft.m_91087_().m_91152_(null);
        }
        if (!this.isReady()) {
            return;
        }
        if (!this.isKeyDown()) {
            this.processClick(false, 0);
        }
    }

    private void processClick(boolean triggeredByMouse, int button) {
        if (this.state == State.NORMAL) {
            if (this.getHoveredItem() != null) {
                if (this.getHoveredItem() instanceof IRadialCategory) {
                    IRadialCategory category = (IRadialCategory)this.getHoveredItem();
                    if (button == 1) {
                        List<IRadialItem> items = category.getContextItems();
                        if (!items.isEmpty()) {
                            if (items.size() == 1 && category.skipMenuIfSingleContextItem()) {
                                items.get(0).click();
                                if (items.get(0).closeOnClick()) {
                                    this.close();
                                }
                            } else {
                                this.changeItems(items);
                            }
                        }
                    } else {
                        List<IRadialItem> items = category.getItems();
                        if (items.isEmpty() && category.closeIfEmpty()) {
                            this.close();
                        } else {
                            this.changeItems(items);
                        }
                    }
                } else {
                    IRadialItem item = this.getHoveredItem();
                    if (button == 1) {
                        List<IRadialItem> items = item.getContextItems();
                        if (!items.isEmpty()) {
                            if (items.size() == 1 && item.skipMenuIfSingleContextItem()) {
                                items.get(0).click();
                                if (items.get(0).closeOnClick()) {
                                    this.close();
                                }
                            } else {
                                this.changeItems(items);
                            }
                        }
                    } else {
                        item.click();
                        if (item.closeOnClick()) {
                            this.close();
                        }
                    }
                }
            } else {
                this.onClickOutside();
            }
        }
    }

    public void onClickOutside() {
        this.close();
    }

    public void close() {
        this.state = State.CLOSING;
        this.startAnimation = (double)this.f_96541_.f_91073_.m_46467_() + (double)this.f_96541_.m_91296_();
        this.animationProgress = 1.0f;
        this.setHovered(-1);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.draw(guiGraphics, partialTicks, mouseX, mouseY);
    }

    public boolean m_7043_() {
        return false;
    }

    private void draw(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.updateAnimationState(partialTicks);
        PoseStack poseStack = guiGraphics.m_280168_();
        if (this.isClosed()) {
            return;
        }
        if (this.isReady()) {
            this.processMouse(mouseX, mouseY);
        }
        boolean animated = this.state == State.OPENING || this.state == State.CLOSING;
        this.radiusIn = animated ? Math.max(0.1f, 30.0f * this.animationProgress) : 30.0f;
        this.radiusIn *= this.getRadiusInModifier();
        this.radiusOut = this.radiusIn * 2.0f;
        this.itemRadius = (this.radiusIn + this.radiusOut) * 0.5f;
        this.animationTop = animated ? (1.0f - this.animationProgress) * (float)this.f_96544_ / 2.0f : 0.0f;
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        float z = 0.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, this.animationTop, 0.0f);
        this.drawBackground(poseStack, x, y, z, this.radiusIn, this.radiusOut);
        poseStack.m_85849_();
        if (this.isReady()) {
            this.drawItems(guiGraphics, x, y, z, this.f_96543_, this.f_96544_);
            Component currentCenterText = null;
            for (IRadialItem item : this.visibleItems) {
                if (!item.isHovered()) continue;
                if (item.getCenterText() == null) break;
                currentCenterText = item.getCenterText();
                break;
            }
            if (currentCenterText != null && this.shouldDrawCenterText()) {
                String text = TextUtil.getFormattedText(currentCenterText);
                float f = (float)(this.f_96543_ - this.f_96547_.m_92895_(text)) / 2.0f;
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.drawString(this.f_96547_, text, f, (float)(this.f_96544_ - 9) / 2.0f, -1, true);
            }
            this.drawTooltips(guiGraphics, mouseX, mouseY);
            this.drawFooter(guiGraphics, this.f_96543_, (float)this.f_96544_ / 2.0f + this.radiusOut * 1.05f, this.radiusOut);
            float f = this.f_96543_;
            float f2 = (float)this.f_96544_ / 2.0f - this.radiusOut * 1.05f;
            Objects.requireNonNull(this.f_96547_);
            this.drawHeader(poseStack, f, f2 - 9.0f, this.radiusOut);
            this.drawExtras(poseStack, this.radiusOut);
        }
    }

    private void updateAnimationState(float partialTicks) {
        float openAnimation = 0.0f;
        switch (this.state) {
            case OPENING: {
                openAnimation = (float)(((double)((float)this.f_96541_.f_91073_.m_46467_() + partialTicks) - this.startAnimation) / (double)this.getOpenAnimationLength());
                if (!((double)openAnimation >= 1.0) && this.visibleItems.size() != 0) break;
                openAnimation = 1.0f;
                this.state = State.NORMAL;
                break;
            }
            case CLOSING: {
                openAnimation = 1.0f - (float)(((double)((float)this.f_96541_.f_91073_.m_46467_() + partialTicks) - this.startAnimation) / (double)this.getOpenAnimationLength());
                if (!(openAnimation <= 0.0f) && this.visibleItems.size() != 0) break;
                openAnimation = 0.0f;
                this.state = State.CLOSED;
            }
        }
        this.animationProgress = openAnimation;
    }

    private void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.visibleItems.size(); ++i) {
            IRadialItem item = this.visibleItems.get(i);
            if (!item.isHovered()) continue;
            item.drawTooltips(this.createDrawingContext(guiGraphics, this.f_96543_, this.f_96544_, mouseX, mouseY, 0.0f));
        }
    }

    private void drawItems(GuiGraphics guiGraphics, int x, int y, float z, int width, int height) {
        this.iterateVisible((TriConsumer<IRadialItem, Float, Float>)((TriConsumer)(item, s, e) -> {
            float middle = (s.floatValue() + e.floatValue()) * 0.5f;
            float posX = (float)x + this.itemRadius * (float)Math.cos(middle);
            float posY = (float)y + this.itemRadius * (float)Math.sin(middle);
            item.draw(this.createDrawingContext(guiGraphics, width, height, posX, posY, z));
        }));
    }

    @NotNull
    private RadialDrawingContext createDrawingContext(GuiGraphics guiGraphics, int width, int height, float x, float y, float z) {
        return new RadialDrawingContext(guiGraphics, width, height, x, y, z, this.f_96547_, arg_0 -> ((AbstractRadialMenu)this).m_257959_(arg_0));
    }

    private void iterateVisible(TriConsumer<IRadialItem, Float, Float> consumer) {
        int numItems = this.visibleItems.size();
        for (int i = 0; i < numItems; ++i) {
            float s = (float)this.getAngleFor((double)i - 0.5, numItems);
            float e = (float)this.getAngleFor((double)i + 0.5, numItems);
            IRadialItem item = this.visibleItems.get(i);
            consumer.accept((Object)item, (Object)Float.valueOf(s), (Object)Float.valueOf(e));
        }
    }

    private void drawBackground(PoseStack poseStack, float x, float y, float z, float radiusIn, float radiusOut) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (!this.visibleItems.isEmpty()) {
            this.iterateVisible((TriConsumer<IRadialItem, Float, Float>)((TriConsumer)(item, s, e) -> {
                int color = item.isHovered() ? this.getBackgroundColorHover() : this.getBackgroundColor();
                this.drawPieArc(buffer, x, y, z, radiusIn, radiusOut, s.floatValue(), e.floatValue(), color);
            }));
        } else {
            float s2 = (float)this.getAngleFor(-0.5, 1);
            float e2 = (float)this.getAngleFor(0.5, 1);
            this.drawPieArc(buffer, x, y, z, radiusIn, radiusOut, s2, e2, this.getBackgroundColor());
        }
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    private void drawPieArc(BufferBuilder buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int color) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, Mth.m_14167_((float)(angle / 0.0069444445f)));
        angle = endAngle - startAngle;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int a = color >> 24 & 0xFF;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.m_5483_((double)pos1OutX, (double)pos1OutY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos1InX, (double)pos1InY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos2InX, (double)pos2InY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos2OutX, (double)pos2OutY, (double)z).m_6122_(r, g, b, a).m_5752_();
        }
    }

    @SubscribeEvent
    public void onMouseScroll(ScreenEvent.MouseScrolled.Pre event) {
        if (Minecraft.m_91087_().f_91080_ instanceof AbstractRadialMenu) {
            if (!this.isScrollInverted()) {
                if (event.getScrollDelta() < 0.0) {
                    this.nexPage();
                } else if (event.getScrollDelta() > 0.0) {
                    this.prevPage();
                }
            } else if (event.getScrollDelta() > 0.0) {
                this.nexPage();
            } else if (event.getScrollDelta() < 0.0) {
                this.prevPage();
            }
        }
    }

    public boolean isScrollInverted() {
        return false;
    }

    private void processMouse(int mouseX, int mouseY) {
        double a;
        if (!this.isReady()) {
            return;
        }
        int numItems = this.visibleItems.size();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        double d = Math.sqrt(Math.pow(mouseX - x, 2.0) + Math.pow(mouseY - y, 2.0));
        if (numItems > 0) {
            double s0 = this.getAngleFor(-0.5, numItems);
            double s1 = this.getAngleFor((double)numItems - 0.5, numItems);
            for (a = Math.atan2(mouseY - y, mouseX - x); a < s0; a += Math.PI * 2) {
            }
            while (a >= s1) {
                a -= Math.PI * 2;
            }
        }
        int hovered = -1;
        for (int i = 0; i < numItems; ++i) {
            float s = (float)this.getAngleFor((double)i - 0.5, numItems);
            float e = (float)this.getAngleFor((double)i + 0.5, numItems);
            if (!(a >= (double)s) || !(a < (double)e) || !(d >= (double)this.radiusIn) || !(d < (double)this.radiusOut) && !this.ShouldClipMouseToCircle() && !this.allowClickOutsideBounds()) continue;
            hovered = i;
            break;
        }
        this.setHovered(hovered);
        if (this.ShouldClipMouseToCircle()) {
            Window mainWindow = this.f_96541_.m_91268_();
            int windowWidth = mainWindow.m_85443_();
            int windowHeight = mainWindow.m_85444_();
            double[] xPos = new double[1];
            double[] yPos = new double[1];
            GLFW.glfwGetCursorPos((long)mainWindow.m_85439_(), (double[])xPos, (double[])yPos);
            double scaledX = xPos[0] - (double)((float)windowWidth / 2.0f);
            double scaledY = yPos[0] - (double)((float)windowHeight / 2.0f);
            double distance = Math.sqrt(scaledX * scaledX + scaledY * scaledY);
            double radius = (double)(this.radiusOut * ((float)windowWidth / (float)this.f_96543_)) * 0.975;
            if (distance > radius) {
                double fixedX = scaledX * radius / distance;
                double fixedY = scaledY * radius / distance;
                GLFW.glfwSetCursorPos((long)mainWindow.m_85439_(), (double)((int)((double)(windowWidth / 2) + fixedX)), (double)((int)((double)(windowHeight / 2) + fixedY)));
            }
        }
    }

    private double getAngleFor(double i, int numItems) {
        if (numItems == 0) {
            return 0.0;
        }
        double angle = (i / (double)numItems + 0.25) * (Math.PI * 2) + Math.PI;
        return angle;
    }

    private List<IRadialItem> getItemForPage(int page) {
        return this.items.stream().skip((page - 1) * this.getMaxItemsPerPage()).limit(this.getMaxItemsPerPage()).collect(Collectors.toList());
    }

    private void prevPage() {
        if (this.currentPage > 1) {
            --this.currentPage;
            this.visibleItems = this.getItemForPage(this.currentPage);
        }
    }

    private void nexPage() {
        if (this.currentPage < this.maxPages) {
            ++this.currentPage;
            this.visibleItems = this.getItemForPage(this.currentPage);
        }
    }

    private void changeItems(List<IRadialItem> items) {
        this.items = items;
        this.maxPages = (int)Math.ceil((double)items.size() / (double)this.getMaxItemsPerPage());
        this.currentPage = 1;
        this.visibleItems = this.getItemForPage(this.currentPage);
    }

    public static enum State {
        INITIALIZING,
        OPENING,
        NORMAL,
        CLOSING,
        CLOSED;

    }
}

