/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.level.block.entity.mode;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.common.Config;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.world.level.block.entity.BarrelBlockEntity;
import novamachina.exnihilosequentia.world.level.block.entity.mode.AbstractBarrelMode;
import novamachina.novacore.util.StringUtils;

public class CompostBarrelMode
extends AbstractBarrelMode {
    private int currentProgress = 0;

    public CompostBarrelMode(@Nonnull String name) {
        super(name);
    }

    @Override
    public void tick(@Nonnull BarrelBlockEntity barrelTile) {
        if (barrelTile.getSolidAmount() >= BarrelBlockEntity.MAX_SOLID_AMOUNT && barrelTile.getInventory().getStackInSlot(0).m_41619_()) {
            ++this.currentProgress;
            this.spawnParticle(barrelTile);
            if (this.currentProgress >= Config.getSecondsToCompost() * 20) {
                this.currentProgress = 0;
                barrelTile.getInventory().setStackInSlot(0, new ItemStack((ItemLike)Blocks.f_50493_));
                barrelTile.removeSolid(barrelTile.getSolidAmount());
                barrelTile.setMode("block");
            }
        }
    }

    @Override
    @Nonnull
    public InteractionResult onBlockActivated(@Nonnull BarrelBlockEntity barrelTile, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull IFluidHandler fluidHandler, @Nonnull IItemHandler itemHandler) {
        if (ExNihiloRegistries.COMPOST_REGISTRY.containsSolid((ItemLike)player.m_21120_(handIn).m_41720_()) && barrelTile.addSolid(ExNihiloRegistries.COMPOST_REGISTRY.getSolidAmount((ItemLike)player.m_21120_(handIn).m_41720_()), false)) {
            player.m_21120_(handIn).m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canFillWithFluid(@Nonnull BarrelBlockEntity barrel) {
        return false;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(@Nonnull ItemStack stack) {
        return ExNihiloRegistries.COMPOST_REGISTRY.containsSolid((ItemLike)stack.m_41720_());
    }

    @Override
    public void read(@Nonnull CompoundTag nbt) {
        this.currentProgress = nbt.m_128451_("currentProgress");
    }

    @Override
    @Nonnull
    public CompoundTag write() {
        CompoundTag modeInfo = new CompoundTag();
        modeInfo.m_128405_("currentProgress", this.currentProgress);
        return modeInfo;
    }

    @Override
    protected void spawnParticle(@Nonnull BarrelBlockEntity barrelTile) throws NullPointerException {
        if (Config.getShowParticles()) {
            ServerLevel level = (ServerLevel)barrelTile.m_58904_();
            Preconditions.checkNotNull((Object)level, (Object)"Level is null.");
            level.m_8767_((ParticleOptions)ParticleTypes.f_123783_, (double)barrelTile.m_58899_().m_123341_() + (0.2 + 0.6000000000000001 * level.f_46441_.m_188500_()), (double)barrelTile.m_58899_().m_123342_() + 1.2, (double)barrelTile.m_58899_().m_123343_() + (0.2 + 0.6000000000000001 * level.f_46441_.m_188500_()), 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    @Override
    @Nonnull
    public List<Component> getWailaInfo(@Nonnull BarrelBlockEntity barrelTile) {
        ArrayList<Component> info = new ArrayList<Component>();
        if (this.currentProgress <= 0) {
            info.add((Component)Component.m_237110_((String)"waila.barrel.compost", (Object[])new Object[]{barrelTile.getSolidAmount(), BarrelBlockEntity.MAX_SOLID_AMOUNT}));
        } else {
            info.add((Component)Component.m_237110_((String)"waila.progress", (Object[])new Object[]{StringUtils.formatPercent((Float)Float.valueOf((float)this.currentProgress / (float)(Config.getSecondsToCompost() * 20)))}));
        }
        return info;
    }

    @Override
    @Nonnull
    public ItemStack handleInsert(@Nonnull BarrelBlockEntity barrelTile, @Nonnull ItemStack stack, boolean simulate) {
        if (barrelTile.addSolid(ExNihiloRegistries.COMPOST_REGISTRY.getSolidAmount((ItemLike)stack.m_41720_()), simulate)) {
            ItemStack returnStack = stack.m_41777_();
            returnStack.m_41774_(1);
            return returnStack;
        }
        return stack;
    }
}

