/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.level.block;

import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import novamachina.exnihilosequentia.world.level.block.entity.CrucibleBlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class CrucibleBlock
extends Block
implements ITOPInfoProvider {
    public CrucibleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void addProbeInfo(@Nonnull ProbeMode probeMode, @Nonnull IProbeInfo probeInfo, @Nonnull Player playerEntity, @Nonnull Level world, @Nonnull BlockState blockState, @Nonnull IProbeHitData data) {
        if (probeMode == ProbeMode.EXTENDED) {
            this.gatherExtendedData(probeInfo, world, data);
        }
    }

    private void gatherExtendedData(@NotNull IProbeInfo probeInfo, @NotNull Level world, @NotNull IProbeHitData data) {
        CrucibleBlockEntity crucibleTile = (CrucibleBlockEntity)world.m_7702_(data.getPos());
        if (crucibleTile == null) {
            return;
        }
        this.addSolidInformation(probeInfo, crucibleTile);
        this.addFluidInformation(probeInfo, crucibleTile);
        this.addHeatInformation(probeInfo, crucibleTile);
    }

    private void addHeatInformation(@NotNull IProbeInfo probeInfo, @NotNull CrucibleBlockEntity crucibleTile) {
        if (crucibleTile.getHeat() == 0) {
            probeInfo.text((Component)Component.m_237115_((String)"waila.crucible.no_heat"));
        } else {
            probeInfo.text((Component)Component.m_237110_((String)"waila.crucible.heat", (Object[])new Object[]{crucibleTile.getHeat()}));
        }
    }

    private void addFluidInformation(@NotNull IProbeInfo probeInfo, @NotNull CrucibleBlockEntity crucibleTile) {
        Fluid fluid;
        if (crucibleTile.getFluidAmount() > 0 && (fluid = crucibleTile.getFluid()) != null) {
            probeInfo.text((Component)Component.m_237110_((String)"waila.crucible.fluid", (Object[])new Object[]{Component.m_237115_((String)fluid.m_76145_().m_76188_().m_60734_().m_7705_()), crucibleTile.getFluidAmount()}));
        }
    }

    private void addSolidInformation(@NotNull IProbeInfo probeInfo, @NotNull CrucibleBlockEntity crucibleTile) {
        if (crucibleTile.getSolidAmount() > 0) {
            ItemStack itemStack = crucibleTile.getCurrentItem();
            probeInfo.text((Component)Component.m_237110_((String)"waila.crucible.solid", (Object[])new Object[]{Component.m_237115_((String)itemStack.m_41720_().m_5524_()), crucibleTile.getSolidAmount()}));
        }
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (worldIn.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        CrucibleBlockEntity tile = (CrucibleBlockEntity)worldIn.m_7702_(pos);
        if (tile != null) {
            IFluidHandler fluidHandler = (IFluidHandler)tile.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_()).orElseThrow(() -> new RuntimeException("Missing Fluid Handler"));
            return tile.onBlockActivated(player, handIn, fluidHandler);
        }
        return InteractionResult.SUCCESS;
    }
}

