/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.novacore.util.FluidStackUtils;
import novamachina.novacore.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TransitionRecipe
extends Recipe {
    private final Ingredient catalyst;
    private final FluidStack fluidInTank;
    private final FluidStack result;

    public TransitionRecipe(ResourceLocation id, Ingredient catalyst, FluidStack fluidInTank, FluidStack result) {
        super(id);
        this.fluidInTank = fluidInTank;
        this.catalyst = catalyst;
        this.result = result;
    }

    public @NonNull ItemStack m_8042_() {
        return EXNBlocks.OAK_BARREL.itemStack();
    }

    public @NonNull RecipeSerializer<?> m_7707_() {
        return EXNRecipeSerializers.TRANSITION_RECIPE_SERIALIZER.recipeSerializer();
    }

    public @NonNull RecipeType<?> m_6671_() {
        return EXNRecipeTypes.TRANSITION;
    }

    public void write(FriendlyByteBuf buffer) {
        this.catalyst.m_43923_(buffer);
        this.fluidInTank.writeToPacket(buffer);
        this.result.writeToPacket(buffer);
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public FluidStack getFluidInTank() {
        return this.fluidInTank;
    }

    public FluidStack getResult() {
        return this.result;
    }

    public static class Serializer<T extends TransitionRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public @NonNull T fromJson(@NonNull ResourceLocation id, @NonNull JsonObject json) {
            Ingredient catalyst = Ingredient.m_43917_((JsonElement)json.get("catalyst"));
            FluidStack fluidInTank = FluidStackUtils.deserialize((JsonObject)json.getAsJsonObject("fluidInTank"));
            FluidStack result = FluidStackUtils.deserialize((JsonObject)json.getAsJsonObject("result"));
            return (T)((Object)((TransitionRecipe)((Object)this.factory.create(id, catalyst, fluidInTank, result))));
        }

        public @Nullable T fromNetwork(@NonNull ResourceLocation id, @NonNull FriendlyByteBuf buffer) {
            Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack fluidInTank = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            FluidStack result = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            return (T)((Object)((TransitionRecipe)((Object)this.factory.create(id, catalyst, fluidInTank, result))));
        }

        public void toNetwork(@NonNull FriendlyByteBuf buffer, @NonNull T recipe) {
            ((TransitionRecipe)((Object)recipe)).write(buffer);
        }

        @FunctionalInterface
        public static interface IFactory<T> {
            public T create(ResourceLocation var1, Ingredient var2, FluidStack var3, FluidStack var4);
        }
    }
}

