/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.common.base.Objects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import novamachina.exnihilosequentia.world.item.MeshType;

public class MeshWithChance {
    @Nonnull
    private static final String CHANCE_KEY = "chance";
    @Nonnull
    private static final String MESH_KEY = "mesh";
    private final float chance;
    @Nonnull
    private final MeshType mesh;

    public MeshWithChance(@Nonnull MeshType mesh, float chance) {
        this.mesh = mesh;
        this.chance = chance;
    }

    @Nonnull
    public static MeshWithChance deserialize(@Nonnull JsonElement json) {
        if (json.isJsonObject() && json.getAsJsonObject().has(MESH_KEY)) {
            float chance = GsonHelper.m_13820_((JsonObject)json.getAsJsonObject(), (String)CHANCE_KEY, (float)1.0f);
            MeshType mesh = MeshType.valueOf(GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)MESH_KEY).toUpperCase());
            return new MeshWithChance(mesh, chance);
        }
        MeshType mesh = MeshType.valueOf(GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)MESH_KEY).toUpperCase());
        return new MeshWithChance(mesh, 1.0f);
    }

    @Nonnull
    public static MeshWithChance read(@Nonnull FriendlyByteBuf buffer) {
        MeshType mesh = (MeshType)buffer.m_130066_(MeshType.class);
        float chance = buffer.readFloat();
        return new MeshWithChance(mesh, chance);
    }

    @Nonnull
    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty(CHANCE_KEY, (Number)Float.valueOf(this.getChance()));
        json.addProperty(MESH_KEY, this.mesh.name().toLowerCase());
        return json;
    }

    public void write(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.mesh);
        buffer.writeFloat(this.getChance());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeshWithChance that = (MeshWithChance)o;
        return Float.compare(this.getChance(), that.getChance()) == 0 && this.getMesh() == that.getMesh();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.getChance()), this.getMesh()});
    }

    public float getChance() {
        return this.chance;
    }

    @Nonnull
    public MeshType getMesh() {
        return this.mesh;
    }
}

