/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.exnihilosequentia.world.level.block.entity.CrucibleBlockEntity;
import novamachina.novacore.util.FluidStackUtils;
import novamachina.novacore.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MeltingRecipe
extends Recipe {
    private final Ingredient input;
    private final FluidStack resultFluid;
    private final CrucibleBlockEntity.CrucibleType crucibleType;

    public MeltingRecipe(ResourceLocation id, Ingredient input, FluidStack fluid, CrucibleBlockEntity.CrucibleType crucibleType) {
        super(id);
        this.resultFluid = fluid;
        this.input = input;
        this.crucibleType = crucibleType;
    }

    public @NonNull RecipeSerializer<?> m_7707_() {
        return EXNRecipeSerializers.MELTING_RECIPE_SERIALIZER.recipeSerializer();
    }

    public @NonNull RecipeType<?> m_6671_() {
        return EXNRecipeTypes.MELTING;
    }

    public @NonNull ItemStack m_8042_() {
        return EXNBlocks.FIRED_CRUCIBLE.itemStack();
    }

    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        this.resultFluid.writeToPacket(buffer);
        buffer.m_130068_((Enum)this.crucibleType);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public FluidStack getResultFluid() {
        return this.resultFluid;
    }

    public CrucibleBlockEntity.CrucibleType getCrucibleType() {
        return this.crucibleType;
    }

    public static class Serializer<T extends MeltingRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public @NonNull T fromJson(@NonNull ResourceLocation id, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            FluidStack fluid = FluidStackUtils.deserialize((JsonObject)json.get("fluidResult").getAsJsonObject());
            CrucibleBlockEntity.CrucibleType typeEnum = CrucibleBlockEntity.CrucibleType.getTypeByName(json.get("crucibleType").getAsString());
            return (T)((Object)((MeltingRecipe)((Object)this.factory.create(id, input, fluid, typeEnum))));
        }

        public T fromNetwork(@NonNull ResourceLocation id, @NonNull FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            CrucibleBlockEntity.CrucibleType type = (CrucibleBlockEntity.CrucibleType)buffer.m_130066_(CrucibleBlockEntity.CrucibleType.class);
            return (T)((Object)((MeltingRecipe)((Object)this.factory.create(id, input, fluid, type))));
        }

        public void toNetwork(@NonNull FriendlyByteBuf buffer, T recipe) {
            ((MeltingRecipe)((Object)recipe)).write(buffer);
        }

        @FunctionalInterface
        public static interface IFactory<T> {
            public T create(ResourceLocation var1, Ingredient var2, FluidStack var3, CrucibleBlockEntity.CrucibleType var4);
        }
    }
}

