/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import novamachina.exnihilosequentia.world.item.crafting.ItemStackWithChance;
import novamachina.novacore.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class DropListRecipe
extends Recipe {
    private final Ingredient input;
    private final List<ItemStackWithChance> drops;

    public DropListRecipe(ResourceLocation id, Ingredient input, ItemStackWithChance ... drops) {
        super(id);
        this.input = input;
        this.drops = Lists.newArrayList((Object[])drops);
    }

    public abstract @NonNull ItemStack m_8042_();

    public abstract @NonNull RecipeSerializer<?> m_7707_();

    public abstract @NonNull RecipeType<?> m_6671_();

    public @NonNull List<ItemStack> getOutputsWithoutChance() {
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        this.drops.forEach(stack -> returnList.add(stack.getStack()));
        return returnList;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.drops.size());
        this.drops.forEach(drop -> drop.write(buffer));
        this.input.m_43923_(buffer);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public List<ItemStackWithChance> getDrops() {
        return this.drops;
    }

    public static class Serializer<T extends DropListRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            int outputCount = buffer.readInt();
            ArrayList<ItemStackWithChance> output = new ArrayList<ItemStackWithChance>(outputCount);
            for (int i = 0; i < outputCount; ++i) {
                output.add(ItemStackWithChance.read(buffer));
            }
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return (T)((Object)((DropListRecipe)((Object)this.factory.create(recipeId, input, (ItemStackWithChance[])output.toArray(ItemStackWithChance[]::new)))));
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull T recipe) {
            ((DropListRecipe)((Object)recipe)).write(buffer);
        }

        @Nonnull
        public T fromJson(@Nonnull ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            JsonArray results = json.getAsJsonArray("results");
            ArrayList<ItemStackWithChance> output = new ArrayList<ItemStackWithChance>(results.size());
            for (int i = 0; i < results.size(); ++i) {
                output.add(ItemStackWithChance.deserialize(results.get(i)));
            }
            return (T)((Object)((DropListRecipe)((Object)this.factory.create(recipeId, input, (ItemStackWithChance[])output.toArray(ItemStackWithChance[]::new)))));
        }

        @FunctionalInterface
        public static interface IFactory<T> {
            public T create(ResourceLocation var1, Ingredient var2, ItemStackWithChance ... var3);
        }
    }
}

