/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.novacore.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CompostRecipe
extends Recipe {
    private final Ingredient input;
    private final int amount;

    public CompostRecipe(ResourceLocation id, Ingredient input, int amount) {
        super(id);
        this.input = input;
        this.amount = amount;
    }

    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        buffer.writeInt(this.amount);
    }

    public @NonNull RecipeSerializer<?> m_7707_() {
        return EXNRecipeSerializers.COMPOST_RECIPE_SERIALIZER.recipeSerializer();
    }

    public @NonNull RecipeType<?> m_6671_() {
        return EXNRecipeTypes.COMPOST;
    }

    public @NonNull ItemStack m_8042_() {
        return EXNBlocks.OAK_BARREL.itemStack();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getAmount() {
        return this.amount;
    }

    public static class Serializer<T extends CompostRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public @NonNull T fromJson(@NonNull ResourceLocation id, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            int amount = json.get("amount").getAsInt();
            return (T)((Object)((CompostRecipe)((Object)this.factory.create(id, input, amount))));
        }

        public T fromNetwork(@NonNull ResourceLocation id, @NonNull FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int amount = buffer.readInt();
            return (T)((Object)((CompostRecipe)((Object)this.factory.create(id, input, amount))));
        }

        public void toNetwork(@NonNull FriendlyByteBuf buffer, T recipe) {
            ((CompostRecipe)((Object)recipe)).write(buffer);
        }

        @FunctionalInterface
        public static interface IFactory<T> {
            public T create(ResourceLocation var1, Ingredient var2, int var3);
        }
    }
}

