/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import novamachina.exnihilosequentia.common.network.HandshakeMessages;
import novamachina.exnihilosequentia.world.item.OreItem;
import novamachina.novacore.core.registries.ItemRegistry;
import novamachina.novacore.util.StringUtils;
import novamachina.novacore.world.item.ItemDefinition;
import org.jetbrains.annotations.NotNull;

public class Ore {
    private static Map<String, Boolean> enabledMap = new HashMap<String, Boolean>();
    @Nonnull
    private final String name;
    @Nullable
    private Either<ItemDefinition<OreItem>, Item> ingotItem;
    @Nullable
    private Either<ItemDefinition<OreItem>, Item> rawOreItem;
    @Nullable
    private final ItemDefinition<OreItem> pieceItem;
    @Nullable
    private Either<ItemDefinition<OreItem>, Item> nuggetItem;

    public Ore(@Nonnull String name, boolean enabled, Optional<Item> optionalRawItem, Optional<Item> optionalIngotItem, Optional<Item> optionalNuggetItem, ItemRegistry registry) {
        ItemDefinition definition;
        this.name = name;
        enabledMap.put(name, enabled);
        if (optionalIngotItem.isEmpty()) {
            definition = registry.item(this.getEnglishName(this.getIngotId()), this.getIngotId(), () -> new OreItem.IngotOreItem(this), ItemDefinition.ItemType.OTHER);
            this.ingotItem = Either.left((Object)definition);
        } else {
            this.ingotItem = Either.right((Object)optionalIngotItem.get());
        }
        if (optionalRawItem.isEmpty()) {
            definition = registry.item(this.getEnglishName(this.getRawOreId()), this.getRawOreId(), () -> new OreItem.RawOreItem(this), ItemDefinition.ItemType.OTHER);
            this.rawOreItem = Either.left((Object)definition);
        } else {
            this.rawOreItem = Either.right((Object)optionalRawItem.get());
        }
        this.pieceItem = registry.item(this.getEnglishName(this.getPieceId()), this.getPieceId(), () -> new OreItem.PieceOreItem(this), ItemDefinition.ItemType.OTHER);
        if (optionalNuggetItem.isEmpty()) {
            definition = registry.item(this.getEnglishName(this.getNuggetId()), this.getNuggetId(), () -> new OreItem.NuggetOreItem(this), ItemDefinition.ItemType.OTHER);
            this.nuggetItem = Either.left((Object)definition);
        } else {
            this.nuggetItem = Either.right((Object)optionalNuggetItem.get());
        }
    }

    private ResourceLocation id(String path) {
        return new ResourceLocation("exnihilosequentia", path);
    }

    private String getEnglishName(String id) {
        return StringUtils.capitalize((String)id.replace("_", " "));
    }

    private String getNuggetId() {
        return String.format("%s_nugget", this.name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateEnabledOres(@Nonnull HandshakeMessages.S2COreList message) {
        List<String> oreList = message.getOreList();
        enabledMap.replaceAll((k, v) -> false);
        if (oreList != null) {
            for (String ore : oreList) {
                enabledMap.put(ore, true);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static List<String> getEnabledOres() {
        ArrayList<String> enabledOres = new ArrayList<String>();
        for (String key : enabledMap.keySet()) {
            if (!Boolean.TRUE.equals(enabledMap.get(key))) continue;
            enabledOres.add(key);
        }
        return enabledOres;
    }

    @Nullable
    public Either<ItemDefinition<OreItem>, Item> getIngotItem() {
        return this.ingotItem;
    }

    @Nullable
    public Either<ItemDefinition<OreItem>, Item> getNuggetItem() {
        return this.nuggetItem;
    }

    public String getIngotId() {
        return this.name + "_ingot";
    }

    @Nonnull
    public String getOreName() {
        return this.name;
    }

    @Nullable
    public OreItem getPieceItem() {
        return (OreItem)this.pieceItem.m_5456_();
    }

    public String getPieceId() {
        return this.name + "_pieces";
    }

    @Nullable
    public Either<ItemDefinition<OreItem>, Item> getRawOreItem() {
        return this.rawOreItem;
    }

    public String getRawOreId() {
        return "raw_" + this.name;
    }

    public boolean isEnabled() {
        return enabledMap.getOrDefault(this.name, false);
    }

    public void setEnabled(boolean enabled) {
        enabledMap.put(this.name, enabled);
    }
}

