/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.novacore.data.recipes.RecipeBuilder;
import novamachina.novacore.util.FluidStackUtils;
import novamachina.novacore.util.ItemStackHelper;

public class SolidifyingRecipeBuilder
extends RecipeBuilder<SolidifyingRecipeBuilder> {
    private final FluidStack fluidInTank;
    private final FluidStack fluidOnTop;
    private final ItemStack result;

    protected SolidifyingRecipeBuilder(FluidStack fluidInTank, FluidStack fluidOnTop, ItemStack result) {
        super(EXNRecipeSerializers.SOLIDIFYING_RECIPE_SERIALIZER.recipeSerializer());
        this.fluidInTank = fluidInTank;
        this.fluidOnTop = fluidOnTop;
        this.result = result;
    }

    public static SolidifyingRecipeBuilder solidify(FluidStack fluidInTank, FluidStack fluidOnTop, ItemLike result) {
        return new SolidifyingRecipeBuilder(fluidInTank, fluidOnTop, new ItemStack(result));
    }

    protected void validate(ResourceLocation id) {
        Preconditions.checkNotNull((Object)this.fluidInTank, (Object)"Fluid in barrel cannot be null");
        Preconditions.checkArgument((!this.fluidInTank.isEmpty() ? 1 : 0) != 0, (Object)"Fluid in barrel amount cannot be 0");
        Preconditions.checkNotNull((Object)this.fluidOnTop, (Object)"Fluid on top cannot be null");
        Preconditions.checkArgument((!this.fluidOnTop.isEmpty() ? 1 : 0) != 0, (Object)"Fluid on top amount cannot be 0");
        Preconditions.checkNotNull((Object)this.result, (Object)"Result cannot be null.");
    }

    protected SolidifyingRecipeResult getResult(ResourceLocation id) {
        return new SolidifyingRecipeResult(id);
    }

    public class SolidifyingRecipeResult
    extends RecipeBuilder.RecipeResult {
        public SolidifyingRecipeResult(ResourceLocation id) {
            super((RecipeBuilder)SolidifyingRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.add("fluidInTank", FluidStackUtils.serialize((FluidStack)SolidifyingRecipeBuilder.this.fluidInTank));
            json.add("fluidOnTop", FluidStackUtils.serialize((FluidStack)SolidifyingRecipeBuilder.this.fluidOnTop));
            json.add("result", ItemStackHelper.serialize((ItemStack)SolidifyingRecipeBuilder.this.result));
        }
    }
}

