/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.novacore.data.recipes.RecipeBuilder;
import novamachina.novacore.util.FluidStackUtils;
import novamachina.novacore.util.ItemStackHelper;

public class PrecipitateRecipeBuilder
extends RecipeBuilder<PrecipitateRecipeBuilder> {
    private final Ingredient input;
    private final FluidStack fluid;
    private final ItemStack output;

    protected PrecipitateRecipeBuilder(FluidStack fluid, Ingredient input, ItemStack output) {
        super(EXNRecipeSerializers.PRECIPITATE_RECIPE_SERIALIZER.recipeSerializer());
        this.input = input;
        this.fluid = fluid;
        this.output = output;
    }

    public static PrecipitateRecipeBuilder precipitate(FluidStack fluid, ItemLike inputItem, ItemLike output) {
        return PrecipitateRecipeBuilder.precipitate(fluid, Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputItem}), output);
    }

    public static PrecipitateRecipeBuilder precipitate(FluidStack fluid, TagKey<Item> inputTag, ItemLike output) {
        return PrecipitateRecipeBuilder.precipitate(fluid, Ingredient.m_204132_(inputTag), output);
    }

    public static PrecipitateRecipeBuilder precipitate(FluidStack fluid, Ingredient input, ItemLike output) {
        return new PrecipitateRecipeBuilder(fluid, input, new ItemStack(output));
    }

    protected void validate(ResourceLocation id) {
        Preconditions.checkNotNull((Object)this.input, (Object)"Input cannot be null.");
        Preconditions.checkNotNull((Object)this.fluid, (Object)"Fluid cannot be null");
        Preconditions.checkArgument((!this.fluid.isEmpty() ? 1 : 0) != 0, (Object)"Fluid amount cannot be 0");
        Preconditions.checkNotNull((Object)this.output, (Object)"Output cannot be null.");
    }

    protected PrecipitateRecipeResult getResult(ResourceLocation id) {
        return new PrecipitateRecipeResult(id);
    }

    public class PrecipitateRecipeResult
    extends RecipeBuilder.RecipeResult {
        public PrecipitateRecipeResult(ResourceLocation id) {
            super((RecipeBuilder)PrecipitateRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.add("input", PrecipitateRecipeBuilder.this.input.m_43942_());
            json.add("fluid", FluidStackUtils.serialize((FluidStack)PrecipitateRecipeBuilder.this.fluid));
            json.add("result", ItemStackHelper.serialize((ItemStack)PrecipitateRecipeBuilder.this.output));
        }
    }
}

