/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.novacore.data.recipes.RecipeBuilder;

public class CompostRecipeBuilder
extends RecipeBuilder<CompostRecipeBuilder> {
    private final Ingredient input;
    private final int amount;

    protected CompostRecipeBuilder(Ingredient input, int amount) {
        super(EXNRecipeSerializers.COMPOST_RECIPE_SERIALIZER.recipeSerializer());
        this.input = input;
        this.amount = amount;
    }

    public static CompostRecipeBuilder composting(ItemLike inputItem, int amount) {
        return CompostRecipeBuilder.composting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputItem}), amount);
    }

    public static CompostRecipeBuilder composting(TagKey<Item> inputTag, int amount) {
        return CompostRecipeBuilder.composting(Ingredient.m_204132_(inputTag), amount);
    }

    public static CompostRecipeBuilder composting(Ingredient input, int amount) {
        return new CompostRecipeBuilder(input, amount);
    }

    protected void validate(ResourceLocation id) {
        Preconditions.checkNotNull((Object)this.input, (Object)"Input cannot be null.");
        Preconditions.checkArgument((this.amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0.");
    }

    protected CompostRecipeResult getResult(ResourceLocation id) {
        return new CompostRecipeResult(id);
    }

    public class CompostRecipeResult
    extends RecipeBuilder.RecipeResult {
        public CompostRecipeResult(ResourceLocation id) {
            super((RecipeBuilder)CompostRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.add("input", CompostRecipeBuilder.this.input.m_43942_());
            json.addProperty("amount", (Number)CompostRecipeBuilder.this.amount);
        }
    }
}

