/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data;

import net.minecraft.data.PackOutput;
import novamachina.exnihilosequentia.world.item.EXNItems;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.novacore.data.AbstractLangGenerator;
import novamachina.novacore.world.item.ItemDefinition;
import novamachina.novacore.world.level.block.BlockDefinition;

public class EXNLangProvider
extends AbstractLangGenerator {
    public EXNLangProvider(PackOutput output, String locale) {
        super(output, "exnihilosequentia", locale);
    }

    protected void addTranslations() {
        this.add("itemGroup.exnihilosequentia", "Ex Nihilo: Sequentia");
        this.addBlock();
        this.addItem();
        this.addCompat();
        this.addMisc();
    }

    private void addCompat() {
        String WAILA_LANG = "waila.";
        this.add("jei.sieve.dropChance", "Drop Chance");
        this.add("waila.progress", "Progress: %s");
        this.add("waila.barrel.fluidAmount", "Fluid(%s): %s mB");
        this.add("waila.barrel.solidAmount", "Solid(%s): %s / %s");
        this.add("waila.barrel.block", "Block: %s");
        this.add("waila.barrel.compost", "Compost: %s / %s");
        this.add("waila.sieve.block", "Sifting: %s");
        this.add("waila.sieve.mesh", "Mesh: %s");
        this.add("waila.crucible.fluid", "Fluid(%s): %s mB");
        this.add("waila.crucible.solid", "Solid(%s): %s");
        this.add("waila.crucible.heat", "Heat: %s");
        this.add("waila.crucible.no_heat", "No Heat Source");
        this.add("top.barrel.mode", "Mode: %s");
    }

    private void addMisc() {
        this.addFluidName("witch_water", "Witch Water");
        this.addFluidName("sea_water", "Sea Water");
        this.addFluidName("witch_water_flow", "Flowing Witch Water");
        this.addFluidName("sea_water_flow", "Flowing Sea Water");
        this.add("tooltip.doll.bee", "Add to a barrel of witch water to spawn a Bee");
        this.add("tooltip.doll.blaze", "Add to a barrel of lava to spawn a Blaze");
        this.add("tooltip.doll.enderman", "Add to a barrel of witch water to spawn an Enderman");
        this.add("tooltip.doll.guardian", "Add to a barrel of sea water to spawn a Guardian");
        this.add("tooltip.doll.shulker", "Add to a barrel of witch water to spawn a Shulker");
        this.add("exnihilosequentia.subtitle.pebbleThrow", "Pebble flies");
        this.add("throwing.pebble", "Flying Pebble");
        this.add("stat.exnihilosequentia.sieved", "Times Sieved");
        this.addJadeEntry("barrel");
        this.addJadeEntry("crucible");
        this.addJadeEntry("sieve");
        this.addJadeEntry("infesting_leaves");
        this.addJEIEntry("compost", "Composting");
        this.addJEIEntry("crushing", "Crushing");
        this.addJEIEntry("harvest", "Harvesting");
        this.addJEIEntry("heat", "Crucible Heat Sources");
        this.addJEIEntry("melting", "Crucible Melting");
        this.addJEIEntry("fired_melting", "Fired Crucible Melting");
        this.addJEIEntry("precipitate", "Precipitate");
        this.addJEIEntry("dry_sifting", "Sifting");
        this.addJEIEntry("wet_sifting", "Waterlogged Sifting");
        this.addJEIEntry("solidifying", "Solidifying");
        this.addJEIEntry("transition", "Transition");
    }

    private void addJEIEntry(String id, String fullText) {
        this.add(String.format("jei.category.%s", id), fullText);
    }

    private void addJadeEntry(String id) {
        this.add("config.jade.plugin_exnihilosequentia." + id, this.properNaming(id));
    }

    private void addItem() {
        for (ItemDefinition definition : EXNItems.ITEMS.getRegistry()) {
            this.addItemName(definition);
        }
    }

    private void addBlock() {
        for (BlockDefinition<?> definition : EXNBlocks.getDefinitions()) {
            this.addBlockName(definition);
        }
    }
}

