/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.TransitionRecipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionRegistry {
    private static Logger log = LoggerFactory.getLogger(TransitionRegistry.class);
    @Nonnull
    private final List<TransitionRecipe> recipeList = new ArrayList<TransitionRecipe>();
    private final LoadingCache<TransitionCacheKey, Fluid> cache;

    public TransitionRegistry() {
        CacheLoader<TransitionCacheKey, Fluid> loader = new CacheLoader<TransitionCacheKey, Fluid>(){

            public Fluid load(TransitionCacheKey key) {
                return TransitionRegistry.this.recipeList.stream().filter(recipe -> recipe.getFluidInTank().isFluidEqual(new FluidStack(key.fluidInTank(), 1000))).filter(recipe -> recipe.getCatalyst().test(new ItemStack(key.catalyst))).findFirst().map(TransitionRecipe::getResult).map(FluidStack::getFluid).orElse(Fluids.f_76191_);
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    public boolean isValidRecipe(@Nonnull Fluid fluidInTank, @Nonnull ItemLike catalyst) {
        return this.getResult(fluidInTank, catalyst) != Fluids.f_76191_;
    }

    @Nonnull
    public Fluid getResult(@Nonnull Fluid fluidInTank, @Nonnull ItemLike catalyst) {
        try {
            return (Fluid)this.cache.get((Object)new TransitionCacheKey(fluidInTank, catalyst));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public List<TransitionRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipes(@Nonnull List<TransitionRecipe> recipes) {
        log.debug("Fluid Transform Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.cache.invalidateAll();
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.cache.invalidateAll();
    }

    private record TransitionCacheKey(Fluid fluidInTank, ItemLike catalyst) {
    }
}

