/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.world.item.crafting.HarvestRecipe;
import novamachina.exnihilosequentia.world.item.crafting.ItemStackWithChance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvestingRegistry {
    private static Logger log = LoggerFactory.getLogger(HarvestingRegistry.class);
    @Nonnull
    private final List<HarvestRecipe> recipeList = new ArrayList<HarvestRecipe>();
    private final LoadingCache<ItemLike, List<HarvestRecipe>> cache;

    public HarvestingRegistry() {
        CacheLoader<ItemLike, List<HarvestRecipe>> loader = new CacheLoader<ItemLike, List<HarvestRecipe>>(){

            public List<HarvestRecipe> load(ItemLike key) {
                return HarvestingRegistry.this.recipeList.stream().filter(crookRecipe -> crookRecipe.getInput().test(new ItemStack(key))).collect(Collectors.toList());
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    public boolean isCrookable(@Nonnull ItemLike block) {
        return !this.getDrops(block).isEmpty();
    }

    @Nonnull
    public List<HarvestRecipe> getDrops(@Nonnull ItemLike block) {
        try {
            return (List)this.cache.get((Object)block);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void setRecipes(@Nonnull List<HarvestRecipe> recipes) {
        log.debug("Crook Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.cache.invalidateAll();
    }

    @Nonnull
    public List<HarvestRecipe> getRecipeList() {
        return this.recipeList.stream().flatMap(crookRecipe -> {
            if (crookRecipe.getDrops().size() <= 21) {
                return Stream.of(crookRecipe);
            }
            List partitions = Lists.partition(crookRecipe.getDrops(), (int)21);
            return IntStream.range(0, partitions.size()).mapToObj(i -> {
                ResourceLocation crookRecipeId = crookRecipe.m_6423_();
                ResourceLocation newId = new ResourceLocation(crookRecipeId.m_135827_(), crookRecipeId.m_135815_() + i);
                return new HarvestRecipe(newId, crookRecipe.getInput(), (ItemStackWithChance[])((List)partitions.get(i)).toArray(ItemStackWithChance[]::new));
            });
        }).collect(Collectors.toList());
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.cache.invalidateAll();
    }
}

