/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.crafttweaker.handler;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.component.RecipeComponentEqualityCheckers;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.gson.reflect.TypeToken;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.TransitionRecipe;

@IRecipeHandler.For(value=TransitionRecipe.class)
public class TransitionRecipeHandler
implements IRecipeHandler<TransitionRecipe> {
    IRecipeComponent<IFluidStack> FLUID_INPUT = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "input/fluid_input"), (TypeToken)new TypeToken<IFluidStack>(){}, RecipeComponentEqualityCheckers::areFluidStacksEqual);

    public String dumpToCommandString(IRecipeManager<? super TransitionRecipe> manager, TransitionRecipe recipe) {
        return String.format("<recipetype:exnihilosequentia:transition>.addRecipe(%s, %s, %s, %s);", StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), IIngredient.fromIngredient((Ingredient)recipe.getCatalyst()).getCommandString(), IFluidStack.of((Object)recipe.getFluidInTank()).getCommandString(), IFluidStack.of((Object)recipe.getResult()).getCommandString());
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super TransitionRecipe> manager, TransitionRecipe firstRecipe, U secondRecipe) {
        TransitionRecipe second = (TransitionRecipe)secondRecipe;
        return IngredientUtil.canConflict((Ingredient)firstRecipe.getCatalyst(), (Ingredient)second.getCatalyst()) && firstRecipe.getFluidInTank().isFluidEqual(second.getFluidInTank());
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super TransitionRecipe> manager, TransitionRecipe recipe) {
        IIngredient catalyst = IIngredient.fromIngredient((Ingredient)recipe.getCatalyst());
        IFluidStack fluidInTank = IFluidStack.of((Object)recipe.getFluidInTank());
        IFluidStack result = IFluidStack.of((Object)recipe.getResult());
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, (Object)catalyst).with(this.FLUID_INPUT, (Object)fluidInTank).with(BuiltinRecipeComponents.Output.FLUIDS, (Object)result).build();
        return Optional.of(decomposition);
    }

    public Optional<TransitionRecipe> recompose(IRecipeManager<? super TransitionRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        IIngredient catalyst = (IIngredient)recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        IFluidStack fluidInTank = (IFluidStack)recipe.getOrThrowSingle(this.FLUID_INPUT);
        IFluidStack result = (IFluidStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.FLUIDS);
        if (catalyst.isEmpty()) {
            throw new IllegalArgumentException("Invalid catalyst: empty ingredient");
        }
        if (fluidInTank.isEmpty()) {
            throw new IllegalArgumentException("Invalid fluidInTank: empty fluid");
        }
        if (result == null) {
            throw new IllegalArgumentException("Invalid result: empty fluid");
        }
        return Optional.of(new TransitionRecipe(name, catalyst.asVanillaIngredient(), (FluidStack)fluidInTank.getInternal(), (FluidStack)result.getInternal()));
    }
}

