/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.crafttweaker.handler;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.component.RecipeComponentEqualityCheckers;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.gson.reflect.TypeToken;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.SolidifyingRecipe;

@IRecipeHandler.For(value=SolidifyingRecipe.class)
public class SolidifyingRecipeHandler
implements IRecipeHandler<SolidifyingRecipe> {
    IRecipeComponent<IFluidStack> FLUID_INPUT_1 = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "input/fluid_input_1"), (TypeToken)new TypeToken<IFluidStack>(){}, RecipeComponentEqualityCheckers::areFluidStacksEqual);
    IRecipeComponent<IFluidStack> FLUID_INPUT_2 = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "input/fluid_input_2"), (TypeToken)new TypeToken<IFluidStack>(){}, RecipeComponentEqualityCheckers::areFluidStacksEqual);

    public String dumpToCommandString(IRecipeManager<? super SolidifyingRecipe> manager, SolidifyingRecipe recipe) {
        return String.format("<recipetype:exnihilosequentia:solidifying>.addRecipe(%s, %s, %s, %s);", StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), IFluidStack.of((Object)recipe.getFluidInTank()).getCommandString(), IFluidStack.of((Object)recipe.getFluidOnTop()).getCommandString(), IItemStack.of((ItemStack)recipe.getResult()).getCommandString());
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super SolidifyingRecipe> manager, SolidifyingRecipe firstRecipe, U secondRecipe) {
        SolidifyingRecipe second = (SolidifyingRecipe)secondRecipe;
        return firstRecipe.getFluidInTank().isFluidEqual(second.getFluidInTank()) && firstRecipe.getFluidOnTop().isFluidEqual(second.getFluidOnTop());
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super SolidifyingRecipe> manager, SolidifyingRecipe recipe) {
        IFluidStack fluidInTank = IFluidStack.of((Object)recipe.getFluidInTank());
        IFluidStack fluidOnTop = IFluidStack.of((Object)recipe.getFluidOnTop());
        IItemStack result = IItemStack.of((ItemStack)recipe.getResult());
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(this.FLUID_INPUT_1, (Object)fluidInTank).with(this.FLUID_INPUT_2, (Object)fluidOnTop).with(BuiltinRecipeComponents.Output.ITEMS, (Object)result).build();
        return Optional.of(decomposition);
    }

    public Optional<SolidifyingRecipe> recompose(IRecipeManager<? super SolidifyingRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        IFluidStack fluidInTank = (IFluidStack)recipe.getOrThrowSingle(this.FLUID_INPUT_1);
        IFluidStack fluidOnTop = (IFluidStack)recipe.getOrThrowSingle(this.FLUID_INPUT_2);
        IItemStack result = (IItemStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (fluidInTank.isEmpty()) {
            throw new IllegalArgumentException("Invalid fluidInTank: empty fluid");
        }
        if (fluidOnTop == null) {
            throw new IllegalArgumentException("Invalid fluidOnTop: empty fluid");
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Invalid result: empty item stack");
        }
        return Optional.of(new SolidifyingRecipe(name, (FluidStack)fluidInTank.getInternal(), (FluidStack)fluidOnTop.getInternal(), result.getInternal()));
    }
}

