/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.crafttweaker.handler;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.component.RecipeComponentEqualityCheckers;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.gson.reflect.TypeToken;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.PrecipitateRecipe;

@IRecipeHandler.For(value=PrecipitateRecipe.class)
public class PrecipitateRecipeHandler
implements IRecipeHandler<PrecipitateRecipe> {
    IRecipeComponent<IFluidStack> FLUID_INPUT = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "input/fluid_input"), (TypeToken)new TypeToken<IFluidStack>(){}, RecipeComponentEqualityCheckers::areFluidStacksEqual);

    public String dumpToCommandString(IRecipeManager<? super PrecipitateRecipe> manager, PrecipitateRecipe recipe) {
        return String.format("<recipetype:exnihilosequentia:precipitate>.addRecipe(%s, %s, %s, %s);", StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), IFluidStack.of((Object)recipe.getFluid()).getCommandString(), IIngredient.fromIngredient((Ingredient)recipe.getInput()).getCommandString(), IItemStack.of((ItemStack)recipe.getOutput()).getCommandString());
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super PrecipitateRecipe> manager, PrecipitateRecipe firstRecipe, U secondRecipe) {
        PrecipitateRecipe second = (PrecipitateRecipe)secondRecipe;
        return firstRecipe.getFluid().isFluidEqual(second.getFluid()) && IngredientUtil.canConflict((Ingredient)firstRecipe.getInput(), (Ingredient)second.getInput());
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super PrecipitateRecipe> manager, PrecipitateRecipe recipe) {
        IFluidStack fluid = IFluidStack.of((Object)recipe.getFluid());
        IIngredient input = IIngredient.fromIngredient((Ingredient)recipe.getInput());
        IItemStack output = IItemStack.of((ItemStack)recipe.getOutput());
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(this.FLUID_INPUT, (Object)fluid).with(BuiltinRecipeComponents.Input.INGREDIENTS, (Object)input).with(BuiltinRecipeComponents.Output.ITEMS, (Object)output).build();
        return Optional.of(decomposition);
    }

    public Optional<PrecipitateRecipe> recompose(IRecipeManager<? super PrecipitateRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        IFluidStack fluid = (IFluidStack)recipe.getOrThrowSingle(this.FLUID_INPUT);
        IIngredient input = (IIngredient)recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = (IItemStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (fluid.isEmpty()) {
            throw new IllegalArgumentException("Invalid fluidInTank: empty fluid");
        }
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Invalid input: empty ingredient");
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid result: empty item stack");
        }
        return Optional.of(new PrecipitateRecipe(name, (FluidStack)fluid.getInternal(), input.asVanillaIngredient(), output.getInternal()));
    }
}

