/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.model.data.ModelData;
import novamachina.exnihilosequentia.client.util.LiquidBlockVertexConsumer;
import novamachina.exnihilosequentia.world.level.block.entity.CrucibleBlockEntity;
import novamachina.novacore.client.renderer.blockentity.BlockEntityRenderer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrucibleRender
extends BlockEntityRenderer<CrucibleBlockEntity> {
    private static Logger log = LoggerFactory.getLogger(CrucibleRender.class);

    public CrucibleRender(@Nonnull BlockEntityRendererProvider.Context rendererDispatcher) {
    }

    public static void register(@Nonnull BlockEntityType<? extends CrucibleBlockEntity> tileTileEntityType) {
        log.debug("Register crucible renderer, Type" + tileTileEntityType);
        BlockEntityRenderers.m_173590_(tileTileEntityType, CrucibleRender::new);
    }

    public void render(@Nonnull CrucibleBlockEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        this.renderFluid(matrixStack, buffer, tileEntity);
        this.renderSolid(tileEntity, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderFluid(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, CrucibleBlockEntity tileEntity) {
        if (tileEntity.getFluidAmount() > 0) {
            BlockState state = tileEntity.getFluid().m_76145_().m_76188_();
            matrixStack.m_85836_();
            float fillAmount = Math.min(tileEntity.getFluidProportion(), 1.0f);
            matrixStack.m_85837_(0.125, 0.1875, 0.125);
            matrixStack.m_85841_(0.75f, fillAmount, 0.75f);
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            blockRenderer.m_234363_(tileEntity.m_58899_(), (BlockAndTintGetter)tileEntity.m_58904_(), (VertexConsumer)new LiquidBlockVertexConsumer(buffer.m_6299_(ItemBlockRenderTypes.m_109287_((FluidState)tileEntity.getFluid().m_76145_())), matrixStack, tileEntity.m_58899_()), state, tileEntity.getFluid().m_76145_());
            matrixStack.m_85849_();
        }
    }

    private void renderSolid(@NotNull CrucibleBlockEntity tileEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntity.getSolidAmount() > 0) {
            BlockState state = null;
            Item item = tileEntity.getCurrentItem().m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                state = blockItem.m_40614_().m_49966_();
            }
            matrixStack.m_85836_();
            float fillAmount = Math.min(tileEntity.getSolidProportion(), 1.0f) - 0.1875f;
            matrixStack.m_85837_(0.125, 0.1875, 0.125);
            matrixStack.m_85841_(0.75f, fillAmount, 0.75f);
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            if (state != null) {
                blockRenderer.renderSingleBlock(state, matrixStack, buffer, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.m_110457_());
            } else {
                log.warn("BlockState was null");
            }
            matrixStack.m_85849_();
        }
    }
}

