/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen;

import com.direwolf20.buildinggadgets2.client.screen.widgets.ScrollingMaterialList;
import com.google.common.collect.Lists;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class MaterialListGUI
extends Screen {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTONS_PADDING = 4;
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("buildinggadgets2", "textures/gui/material_list.png");
    public static final int BACKGROUND_WIDTH = 256;
    public static final int BACKGROUND_HEIGHT = 200;
    public static final int BORDER_SIZE = 4;
    public static final int WINDOW_WIDTH = 248;
    public static final int WINDOW_HEIGHT = 192;
    private int backgroundX;
    private int backgroundY;
    private ItemStack gadget;
    private String title;
    private int titleLeft;
    private int titleTop;
    private ScrollingMaterialList scrollingList;
    private Button buttonClose;
    private Button buttonSortingModes;
    private Button buttonCopyList;

    public MaterialListGUI(ItemStack itemStack) {
        super((Component)Component.m_237115_((String)"buildinggadgets2.screen.componentslist"));
        this.gadget = itemStack;
    }

    public void m_7856_() {
        this.backgroundX = MaterialListGUI.getXForAlignedCenter(0, this.f_96543_, 256);
        this.backgroundY = MaterialListGUI.getYForAlignedCenter(0, this.f_96544_, 200);
        this.scrollingList = new ScrollingMaterialList(this, this.getWindowLeftX(), this.getWindowTopY() + 16, this.getWindowWidth(), this.getWindowHeight() - 16 - 32, this.gadget);
        this.m_7522_((GuiEventListener)this.scrollingList);
        this.m_142416_((GuiEventListener)this.scrollingList);
        int buttonY = this.getWindowBottomY() - 26;
        this.buttonClose = Button.m_253074_((Component)Component.m_237115_((String)"buildinggadgets2.screen.close"), b -> this.getMinecraft().f_91074_.m_6915_()).m_252794_(0, buttonY).m_253046_(0, 20).m_253136_();
        this.buttonSortingModes = Button.m_253074_((Component)this.scrollingList.getSortingMode().getTranslatable(), button -> {
            this.scrollingList.setSortingMode(this.scrollingList.getSortingMode().next());
            this.buttonSortingModes.m_93666_(this.scrollingList.getSortingMode().getTranslatable());
        }).m_252794_(0, buttonY).m_253046_(0, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.buttonSortingModes);
        this.m_142416_((GuiEventListener)this.buttonClose);
        this.calculateButtonsWidthAndX();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float particleTicks) {
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.backgroundX, this.backgroundY, 0, 0, 256, 200);
        super.m_88315_(guiGraphics, mouseX, mouseY, particleTicks);
        if (this.scrollingList.hoveringText != null) {
            guiGraphics.m_280245_(this.f_96547_, Lists.transform(this.scrollingList.hoveringText, Component::m_7532_), mouseX, mouseY);
            this.scrollingList.hoveringText = null;
        }
    }

    private void calculateButtonsWidthAndX() {
        int amountButtons = (int)this.m_6702_().stream().filter(e -> e instanceof Button).count();
        int amountMargins = amountButtons - 1;
        int totalMarginWidth = amountMargins * 4;
        int usableWidth = this.getWindowWidth();
        int buttonWidth = (usableWidth - totalMarginWidth) / amountButtons;
        int nextX = this.getWindowLeftX();
        for (GuiEventListener widget : this.m_6702_()) {
            if (!(widget instanceof Button)) continue;
            Button btn = (Button)widget;
            btn.m_93674_(buttonWidth);
            btn.m_252865_(nextX);
            nextX += buttonWidth + 4;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public int getWindowLeftX() {
        return this.backgroundX + 4;
    }

    public int getWindowRightX() {
        return this.backgroundX + 256 - 4;
    }

    public int getWindowTopY() {
        return this.backgroundY + 4;
    }

    public int getWindowBottomY() {
        return this.backgroundY + 200 - 4;
    }

    public int getWindowWidth() {
        return 248;
    }

    public int getWindowHeight() {
        return 192;
    }

    public ItemStack getTemplateItem() {
        return this.gadget;
    }

    public static int getXForAlignedRight(int right, int width) {
        return right - width;
    }

    public static int getXForAlignedCenter(int left, int right, int width) {
        return left + (right - left) / 2 - width / 2;
    }

    public static int getYForAlignedCenter(int top, int bottom, int height) {
        return top + (bottom - top) / 2 - height / 2;
    }

    public static void renderTextVerticalCenter(GuiGraphics guiGraphics, String text, int leftX, int rightX, int top, int bottom, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(fontRenderer);
        int y = MaterialListGUI.getYForAlignedCenter(top, bottom, 9);
        MaterialListGUI.renderScrollingString(guiGraphics, fontRenderer, (Component)Component.m_237113_((String)text), leftX, y, rightX, color);
    }

    public static void renderTextHorizontalRight(GuiGraphics guiGraphics, String text, int right, int y, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int x = MaterialListGUI.getXForAlignedRight(right, fontRenderer.m_92895_(text));
        guiGraphics.m_280056_(fontRenderer, text, x, y, color, false);
    }

    protected static void renderScrollingString(GuiGraphics graphics, Font fontRenderer, Component text, int xStart, int yStart, int xEnd, int textColor) {
        int textWidth = fontRenderer.m_92852_((FormattedText)text);
        Objects.requireNonNull(fontRenderer);
        int yEnd = yStart + 9;
        int maxRenderWidth = xEnd - xStart;
        if (textWidth > maxRenderWidth) {
            int textOverflow = textWidth - maxRenderWidth;
            double currentTime = (double)Util.m_137550_() / 1000.0;
            double scrollDuration = Math.max((double)textOverflow * 0.5, 3.0);
            double oscillation = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * currentTime / scrollDuration)) / 2.0 + 0.5;
            double scrollOffset = Mth.m_14139_((double)oscillation, (double)0.0, (double)textOverflow);
            graphics.m_280588_(xStart, yStart, xEnd, yEnd);
            graphics.m_280430_(fontRenderer, text, xStart - (int)scrollOffset, yStart, textColor);
            graphics.m_280618_();
        } else {
            graphics.m_280614_(fontRenderer, text, xStart, yStart, textColor, false);
        }
    }

    public static boolean isPointInBox(double x, double y, int bx, int by, int width, int height) {
        return x >= (double)bx && y >= (double)by && x < (double)(bx + width) && y < (double)(by + height);
    }
}

