/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.renderer;

import com.direwolf20.buildinggadgets2.client.renderer.DireBufferBuilder;
import com.direwolf20.buildinggadgets2.client.renderer.DireVertexConsumer;
import com.direwolf20.buildinggadgets2.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.client.renderer.RenderFluidBlock;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2DataClient;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.DimBlockPos;
import com.direwolf20.buildinggadgets2.util.FakeRenderingWorld;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class VBORenderer {
    private static ArrayList<StatePos> statePosCache;
    private static int sortCounter;
    public static UUID copyPasteUUIDCache;
    private static FakeRenderingWorld fakeRenderingWorld;
    private static final Map<RenderType, BufferBuilder.SortState> sortStates;
    private static final Map<RenderType, DireBufferBuilder> builders;
    private static final Map<RenderType, VertexBuffer> vertexBuffers;

    public static DireBufferBuilder getBuffer(RenderType renderType) {
        DireBufferBuilder buffer = builders.get(renderType);
        if (!buffer.m_85732_()) {
            buffer.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        }
        return buffer;
    }

    public static void clearBuffers() {
        for (Map.Entry<RenderType, VertexBuffer> entry : vertexBuffers.entrySet()) {
            entry.getValue().close();
        }
    }

    public static void buildRender(RenderLevelStageEvent evt, Player player, ItemStack gadget) {
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        BlockPos anchorPos = GadgetNBT.getAnchorPos(gadget);
        BlockPos renderPos = anchorPos.equals((Object)GadgetNBT.nullPos) ? lookingAt.m_82425_() : anchorPos;
        BaseMode mode = GadgetNBT.getMode(gadget);
        DimBlockPos boundTo = GadgetNBT.getBoundPos(gadget);
        if (boundTo != null && boundTo.levelKey.equals((Object)player.m_9236_().m_46472_())) {
            VBORenderer.drawBoundBox(evt.getPoseStack(), boundTo.blockPos);
        }
        if (gadget.m_41720_() instanceof GadgetCopyPaste || gadget.m_41720_() instanceof GadgetCutPaste) {
            renderPos = renderPos.m_7494_();
            renderPos.m_121955_((Vec3i)GadgetNBT.getRelativePaste(gadget));
            if (mode.getId().m_135815_().equals("copy") || mode.getId().m_135815_().equals("cut")) {
                VBORenderer.drawCopyBox(evt.getPoseStack(), gadget, mode.getId().m_135815_());
                return;
            }
        }
        if (VBORenderer.shouldUpdateRender(player, gadget)) {
            VBORenderer.generateRender(player.m_9236_(), renderPos, gadget, 0.5f, statePosCache, vertexBuffers);
        }
    }

    public static boolean shouldUpdateRender(Player player, ItemStack gadget) {
        BaseMode mode = GadgetNBT.getMode(gadget);
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        BlockPos anchorPos = GadgetNBT.getAnchorPos(gadget);
        BlockPos renderPos = anchorPos.equals((Object)GadgetNBT.nullPos) ? lookingAt.m_82425_() : anchorPos;
        UUID gadgetUUID = GadgetNBT.getUUID(gadget);
        if (gadget.m_41720_() instanceof GadgetBuilding || gadget.m_41720_() instanceof GadgetExchanger) {
            if (player.m_9236_().m_8055_(renderPos).m_60795_()) {
                return false;
            }
            BlockState renderBlockState = GadgetNBT.getGadgetBlockState(gadget);
            if (renderBlockState.m_60795_()) {
                return false;
            }
            ArrayList<StatePos> buildList = mode.collect(lookingAt.m_82434_(), player, renderPos, renderBlockState);
            FakeRenderingWorld tempWorld = new FakeRenderingWorld(player.m_9236_(), buildList, renderPos);
            if (fakeRenderingWorld != null && VBORenderer.fakeRenderingWorld.positions.equals(tempWorld.positions)) {
                return false;
            }
            statePosCache = buildList;
            copyPasteUUIDCache = UUID.randomUUID();
            return true;
        }
        if (gadget.m_41720_() instanceof GadgetCopyPaste || gadget.m_41720_() instanceof GadgetCutPaste) {
            renderPos = renderPos.m_7494_();
            renderPos.m_121955_((Vec3i)GadgetNBT.getRelativePaste(gadget));
            if (mode.getId().m_135815_().equals("paste")) {
                if (!BG2DataClient.isClientUpToDate(gadget)) {
                    return false;
                }
                UUID BG2ClientUUID = BG2DataClient.getCopyUUID(gadgetUUID);
                if (BG2ClientUUID != null && copyPasteUUIDCache.equals(BG2ClientUUID)) {
                    return false;
                }
                copyPasteUUIDCache = BG2ClientUUID;
                statePosCache = BG2DataClient.getLookupFromUUID(gadgetUUID);
                return true;
            }
        } else {
            return false;
        }
        return true;
    }

    public static void generateRender(Level level, BlockPos renderPos, ItemStack gadget, float transparency, ArrayList<StatePos> statePosCache, Map<RenderType, VertexBuffer> vertexBuffers) {
        boolean isExchanging;
        boolean bl = isExchanging = gadget.m_41720_() instanceof BaseGadget && GadgetNBT.getMode((ItemStack)gadget).isExchanging;
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        fakeRenderingWorld = new FakeRenderingWorld(level, statePosCache, renderPos);
        PoseStack matrix = new PoseStack();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer modelBlockRenderer = dispatcher.m_110937_();
        RandomSource random = RandomSource.m_216327_();
        for (StatePos pos2 : statePosCache.stream().filter(pos -> VBORenderer.isModelRender(pos.state) || !pos.state.m_60819_().m_76178_()).toList()) {
            BlockState renderState = fakeRenderingWorld.getBlockStateWithoutReal(pos2.pos);
            if (renderState.m_60795_()) continue;
            BakedModel ibakedmodel = dispatcher.m_110910_(renderState);
            matrix.m_85836_();
            matrix.m_252880_((float)pos2.pos.m_123341_(), (float)pos2.pos.m_123342_(), (float)pos2.pos.m_123343_());
            if (isExchanging) {
                matrix.m_252880_(-5.0E-4f, -5.0E-4f, -5.0E-4f);
                matrix.m_85841_(1.001f, 1.001f, 1.001f);
            }
            for (RenderType renderType : ibakedmodel.getRenderTypes(renderState, random, ModelData.EMPTY)) {
                if (renderType.equals(RenderType.m_110463_()) && renderState.m_60808_((BlockGetter)level, pos2.pos.m_121955_((Vec3i)renderPos)).equals(Shapes.m_83144_())) {
                    renderType = RenderType.m_110466_();
                }
                DireVertexConsumer direVertexConsumer = new DireVertexConsumer((VertexConsumer)VBORenderer.getBuffer(renderType), transparency);
                if (renderState.m_60819_().m_76178_()) {
                    try {
                        modelBlockRenderer.tesselateBlock((BlockAndTintGetter)fakeRenderingWorld, ibakedmodel, renderState, pos2.pos.m_121955_((Vec3i)renderPos).m_6630_(255), matrix, (VertexConsumer)direVertexConsumer, false, random, renderState.m_60726_(pos2.pos.m_121955_((Vec3i)renderPos)), OverlayTexture.f_118083_, ibakedmodel.getModelData((BlockAndTintGetter)fakeRenderingWorld, pos2.pos, renderState, ModelData.EMPTY), renderType);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                RenderFluidBlock.renderFluidBlock(renderState, level, pos2.pos.m_121955_((Vec3i)renderPos).m_6630_(255), matrix, (VertexConsumer)direVertexConsumer, false);
            }
            matrix.m_85849_();
        }
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Vec3 subtracted = projectedView.m_82492_((double)renderPos.m_123341_(), (double)renderPos.m_123342_(), (double)renderPos.m_123343_());
        Vector3f sortPos = new Vector3f((float)subtracted.f_82479_, (float)subtracted.f_82480_, (float)subtracted.f_82481_);
        for (Map.Entry<RenderType, DireBufferBuilder> entry : builders.entrySet()) {
            RenderType renderType;
            renderType = entry.getKey();
            DireBufferBuilder direBufferBuilder = VBORenderer.getBuffer(renderType);
            direBufferBuilder.m_277127_(VertexSorting.m_276997_((Vector3f)sortPos));
            sortStates.put(renderType, direBufferBuilder.m_166770_());
            VertexBuffer vertexBuffer = vertexBuffers.get(entry.getKey());
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(direBufferBuilder.m_231175_());
            VertexBuffer.m_85931_();
        }
    }

    public static void drawCopyBox(PoseStack matrix, ItemStack gadget, String mode) {
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrix.m_85836_();
        matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
        BlockPos start = GadgetNBT.getCopyStartPos(gadget);
        BlockPos end = GadgetNBT.getCopyEndPos(gadget);
        Color color = mode.equals("copy") ? Color.GREEN : Color.RED;
        MyRenderMethods.renderCopy(matrix, start, end, color);
        matrix.m_85849_();
    }

    public static void drawBoundBox(PoseStack matrix, BlockPos blockPos) {
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrix.m_85836_();
        matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
        Color color = Color.BLUE;
        MyRenderMethods.renderCopy(matrix, blockPos, blockPos, color);
        matrix.m_85849_();
    }

    public static boolean isModelRender(BlockState state) {
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BakedModel ibakedmodel = dispatcher.m_110910_(state);
        for (Direction direction : Direction.values()) {
            if (!ibakedmodel.getQuads(state, direction, RandomSource.m_216327_(), ModelData.EMPTY, null).isEmpty()) {
                return true;
            }
            if (ibakedmodel.getQuads(state, null, RandomSource.m_216327_(), ModelData.EMPTY, null).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void drawRender(RenderLevelStageEvent evt, Player player, ItemStack gadget) {
        if (vertexBuffers == null || statePosCache == null) {
            return;
        }
        MultiBufferSource.BufferSource buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        BlockPos anchorPos = GadgetNBT.getAnchorPos(gadget);
        BlockPos renderPos = anchorPos.equals((Object)GadgetNBT.nullPos) ? lookingAt.m_82425_() : anchorPos;
        BlockState lookingAtState = player.m_9236_().m_8055_(renderPos);
        if (lookingAtState.m_60795_() && anchorPos.equals((Object)GadgetNBT.nullPos) || lookingAtState.m_60734_().equals(Registration.RenderBlock.get())) {
            return;
        }
        ArrayList<Object> buildList = new ArrayList();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (gadget.m_41720_() instanceof GadgetBuilding || gadget.m_41720_() instanceof GadgetExchanger) {
            BlockState renderBlockState = GadgetNBT.getGadgetBlockState(gadget);
            if (renderBlockState.m_60795_()) {
                return;
            }
            buildList = mode.collect(lookingAt.m_82434_(), player, renderPos, renderBlockState);
            if (buildList.isEmpty()) {
                return;
            }
        } else if (gadget.m_41720_() instanceof GadgetCopyPaste || gadget.m_41720_() instanceof GadgetCutPaste) {
            if (mode.getId().m_135815_().equals("copy") || mode.getId().m_135815_().equals("cut")) {
                return;
            }
            if (!GadgetNBT.hasCopyUUID(gadget) || !copyPasteUUIDCache.equals(GadgetNBT.getCopyUUID(gadget))) {
                return;
            }
            renderPos = renderPos.m_7494_().m_121955_((Vec3i)GadgetNBT.getRelativePaste(gadget));
        }
        if (sortCounter > 20) {
            VBORenderer.sortAll(renderPos);
            sortCounter = 0;
        } else {
            ++sortCounter;
        }
        PoseStack matrix = evt.getPoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
        matrix.m_252880_((float)renderPos.m_123341_(), (float)renderPos.m_123342_(), (float)renderPos.m_123343_());
        ArrayList<RenderType> drawSet = new ArrayList<RenderType>();
        drawSet.add(RenderType.m_110451_());
        drawSet.add(RenderType.m_110463_());
        drawSet.add(RenderType.m_110457_());
        drawSet.add(RenderType.m_110466_());
        drawSet.add(RenderType.m_110503_());
        try {
            for (RenderType renderType : drawSet) {
                RenderType drawRenderType = renderType.equals(RenderType.m_110463_()) ? OurRenderTypes.RenderBlock : RenderType.m_110466_();
                VertexBuffer vertexBuffer = vertexBuffers.get(renderType);
                if (vertexBuffer.m_166892_() == null) continue;
                drawRenderType.m_110185_();
                vertexBuffer.m_85921_();
                vertexBuffer.m_253207_(matrix.m_85850_().m_252922_(), new Matrix4f((Matrix4fc)evt.getProjectionMatrix()), RenderSystem.getShader());
                VertexBuffer.m_85931_();
                drawRenderType.m_110188_();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        matrix.m_85849_();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        MyRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new MyRenderMethods.MultiplyAlphaRenderTypeBuffer((MultiBufferSource)buffersource, 0.5f);
        fakeRenderingWorld = new FakeRenderingWorld(player.m_9236_(), statePosCache, renderPos);
        for (StatePos pos2 : statePosCache.stream().filter(pos -> !VBORenderer.isModelRender(pos.state)).toList()) {
            if (pos2.state.m_60795_()) continue;
            matrix.m_85836_();
            matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
            matrix.m_252880_((float)renderPos.m_123341_(), (float)renderPos.m_123342_(), (float)renderPos.m_123343_());
            matrix.m_252880_((float)pos2.pos.m_123341_(), (float)pos2.pos.m_123342_(), (float)pos2.pos.m_123343_());
            BlockEntityRenderDispatcher blockEntityRenderer = Minecraft.m_91087_().m_167982_();
            BlockEntity blockEntity = fakeRenderingWorld.m_7702_(pos2.pos);
            if (blockEntity != null) {
                blockEntityRenderer.m_112267_(blockEntity, 0.0f, matrix, (MultiBufferSource)multiplyAlphaRenderTypeBuffer);
            } else {
                MyRenderMethods.renderBETransparent(fakeRenderingWorld.m_8055_(pos2.pos), matrix, (MultiBufferSource)buffersource, 0xF00000, 655360, 0.5f);
            }
            matrix.m_85849_();
        }
        boolean hasBound = GadgetNBT.getBoundPos(gadget) != null;
        BlockState renderBlockState = GadgetNBT.getGadgetBlockState(gadget);
        if ((gadget.m_41720_() instanceof GadgetBuilding || gadget.m_41720_() instanceof GadgetExchanger) && !player.m_7500_() && !hasBound && renderBlockState.m_60819_().m_76178_()) {
            ItemStack findStack = GadgetUtils.getItemForBlock(renderBlockState, player.m_9236_(), BlockPos.f_121853_, player);
            int availableItems = BuildingUtils.countItemStacks(player, findStack);
            int energyStored = BuildingUtils.getEnergyStored(gadget);
            int energyCost = BuildingUtils.getEnergyCost(gadget);
            for (StatePos statePos : buildList) {
                if (availableItems <= 0 || energyStored < energyCost) {
                    matrix.m_85836_();
                    matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
                    matrix.m_252880_((float)renderPos.m_123341_(), (float)renderPos.m_123342_(), (float)renderPos.m_123343_());
                    VertexConsumer builder = buffersource.m_6299_(OurRenderTypes.MissingBlockOverlay);
                    MyRenderMethods.renderBoxSolid(evt.getPoseStack().m_85850_().m_252922_(), builder, statePos.pos, 1.0f, 0.0f, 0.0f, 0.35f);
                    matrix.m_85849_();
                }
                --availableItems;
                energyStored -= energyCost;
            }
        }
    }

    public static void sortAll(BlockPos lookingAt) {
        for (Map.Entry<RenderType, BufferBuilder.SortState> entry : sortStates.entrySet()) {
            RenderType renderType = entry.getKey();
            BufferBuilder.RenderedBuffer renderedBuffer = VBORenderer.sort(lookingAt, renderType);
            VertexBuffer vertexBuffer = vertexBuffers.get(renderType);
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(renderedBuffer);
            VertexBuffer.m_85931_();
        }
    }

    public static BufferBuilder.RenderedBuffer sort(BlockPos lookingAt, RenderType renderType) {
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Vec3 subtracted = projectedView.m_82492_((double)lookingAt.m_123341_(), (double)lookingAt.m_123342_(), (double)lookingAt.m_123343_());
        Vector3f sortPos = new Vector3f((float)subtracted.f_82479_, (float)subtracted.f_82480_, (float)subtracted.f_82481_);
        DireBufferBuilder bufferBuilder = VBORenderer.getBuffer(renderType);
        BufferBuilder.SortState sortState = sortStates.get(renderType);
        bufferBuilder.m_166775_(sortState);
        bufferBuilder.m_277127_(VertexSorting.m_276997_((Vector3f)sortPos));
        sortStates.put(renderType, bufferBuilder.m_166770_());
        return bufferBuilder.m_231175_();
    }

    static {
        sortCounter = 0;
        copyPasteUUIDCache = UUID.randomUUID();
        sortStates = new HashMap<RenderType, BufferBuilder.SortState>();
        builders = RenderType.m_110506_().stream().collect(Collectors.toMap(renderType -> renderType, type -> new DireBufferBuilder(type.m_110507_())));
        vertexBuffers = RenderType.m_110506_().stream().collect(Collectors.toMap(renderType -> renderType, type -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
    }
}

