## Biometric Reader

![](https://i.imgur.com/FGU3ZqW.png)

Sends an event when used by a player, the default event name is `bioReader` and contains the UUID of the player which used the reader.

### Example
```lua
event = require("event") -- require event
reader = require("component").os_biometric -- require the biometric reader

function onRead(address, reader_uuid, player_uuid) -- function to call once the reader is used.
   print(player_uuid .. " entered!") -- print the UUID of the player that was scanned.
end

event.listen("bioReader", onRead) -- listen to the bioReader event
```

### Methods
```lua
setEventName(String:name) -- changes the event name to the given argument
```