import globals.Globals

MIXER = recipemap('mixer')
SIFTER = recipemap('sifter')
ROASTER = recipemap('roaster')

MIXER.recipeBuilder()
        .fluidInputs(fluid('water') * 100)
        .inputs(ore('dustTinyAsh'))
        .fluidOutputs(fluid('ash_slurry') * 100)
        .duration(5)
        .EUt(7)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('water') * 100)
        .inputs(ore('dustTinyDarkAsh'))
        .fluidOutputs(fluid('ash_slurry') * 100)
        .duration(5)
        .EUt(7)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('water') * 1000)
        .inputs(ore('dustAsh'))
        .fluidOutputs(fluid('ash_slurry') * 1000)
        .duration(40)
        .EUt(7)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('water') * 1000)
        .inputs(ore('dustDarkAsh'))
        .fluidOutputs(fluid('ash_slurry') * 1000)
        .duration(40)
        .EUt(7)
        .buildAndRegister()

SIFTER.recipeBuilder()
        .fluidInputs(fluid('flue_gas') * 16000)
        .inputs(ore('dustCalcite') * 5)
        .fluidOutputs(fluid('desulfurized_flue_gas') * 16000)
        .outputs(metaitem('dustCalciumSulfite') * 5)
        .duration(160)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustCalciumSulfite') * 5)
        .circuitMeta(1)
        .fluidOutputs(fluid('sulfur_dioxide') * 1000)
        .outputs(metaitem('dustQuicklime') * 2)
        .duration(80)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .fluidInputs(fluid('air') * 1500)
        .inputs(ore('dustCalciumSulfite') * 5)
        .outputs(metaitem('dustCalciumSulfate') * 6)
        .duration(80)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .fluidInputs(fluid('oxygen') * 1000)
        .inputs(ore('dustCalciumSulfite') * 5)
        .outputs(metaitem('dustCalciumSulfate') * 6)
        .duration(80)
        .EUt(30)
        .buildAndRegister()
