import globals.Globals
import static globals.SinteringGlobals.*
import gregtech.api.metatileentity.multiblock.CleanroomType

SINTERING_RECIPES = recipemap("sintering_oven")
CUTTER = recipemap('cutter')
CRYSTALLIZER = recipemap('crystallizer')
SOLIDIFIER = recipemap('fluid_solidifier')
CVD = recipemap('cvd')
FORGE_HAMMER = recipemap('forge_hammer')
CSTR = recipemap('continuous_stirred_tank_reactor')
TBR = recipemap('trickle_bed_reactor')
FBR = recipemap('fixed_bed_reactor')
BCR = recipemap('bubble_column_reactor')
BR = recipemap('batch_reactor')
FLUIDIZEDBR = recipemap('fluidized_bed_reactor')
DISTILLATION_TOWER = recipemap('distillation_tower')
DISTILLERY = recipemap('distillery')
ROASTER = recipemap('roaster')
MIXER = recipemap('mixer')
DRYER = recipemap('dryer')
SIFTER = recipemap('sifter')
CENTRIFUGE = recipemap('centrifuge')
PYROLYSE = recipemap('pyrolyse_oven')
LCR = recipemap('large_chemical_reactor')
EBF = recipemap('electric_blast_furnace')
VULCANIZER = recipemap('vulcanizing_press')
ALLOY_SMELTER = recipemap('alloy_smelter')
ARC_FURNACE = recipemap('arc_furnace')
AUTOCLAVE = recipemap('autoclave')
COMPRESSOR = recipemap('compressor')
ASSEMBLER = recipemap('assembler')
ELECTROLYZER = recipemap('electrolyzer')
ELECTROLYTIC_CELL = recipemap('electrolytic_cell')
REACTION_FURNACE = recipemap('reaction_furnace')
ELECTROMAGNETIC_SEPARATOR = recipemap('electromagnetic_separator')
PSA = recipemap('pressure_swing_adsorption')
FORMING_PRESS = recipemap('forming_press')
LASER_ENGRAVER = recipemap('laser_engraver')
CHEMICAL_BATH = recipemap('chemical_bath')
VACUUM_CHAMBER = recipemap('vacuum_chamber');
CANNER = recipemap('canner');
// Inductor * 2
mods.gregtech.assembler.removeByInput(120, [metaitem('ringSteel'), metaitem('wireFineCopper') * 2], [fluid('plastic') * 36])
// Inductor * 4
mods.gregtech.assembler.removeByInput(120, [metaitem('ringSteel'), metaitem('wireFineAnnealedCopper') * 2], [fluid('plastic') * 36])

// SMD Inductor * 16
mods.gregtech.assembler.removeByInput(480, [metaitem('ringNickelZincFerrite'), metaitem('wireFineCupronickel') * 4], [fluid('plastic') * 144])

// SMD Resistor * 16
mods.gregtech.assembler.removeByInput(480, [metaitem('dustCarbon'), metaitem('wireFineElectrum') * 4], [fluid('plastic') * 288])

// SMD Capacitor * 8
mods.gregtech.assembler.removeByInput(480, [metaitem('foilSiliconeRubber'), metaitem('foilAluminium')], [fluid('plastic') * 72])
// SMD Capacitor * 12
mods.gregtech.assembler.removeByInput(480, [metaitem('foilPolyvinylChloride') * 2, metaitem('foilAluminium')], [fluid('plastic') * 72])
// SMD Capacitor * 16
mods.gregtech.assembler.removeByInput(480, [metaitem('foilSiliconeRubber'), metaitem('foilTantalum')], [fluid('plastic') * 72])
// SMD Capacitor * 24
mods.gregtech.assembler.removeByInput(480, [metaitem('foilPolyvinylChloride') * 2, metaitem('foilTantalum')], [fluid('plastic') * 72])

// SMD Transistor * 16
mods.gregtech.assembler.removeByInput(480, [metaitem('foilGallium'), metaitem('wireFineAnnealedCopper') * 8], [fluid('plastic') * 144])
// SMD Transistor * 32
mods.gregtech.assembler.removeByInput(480, [metaitem('foilGallium'), metaitem('wireFineTantalum') * 8], [fluid('plastic') * 144])
// SMD Resistor * 32
mods.gregtech.assembler.removeByInput(480, [metaitem('dustCarbon'), metaitem('wireFineTantalum') * 4], [fluid('plastic') * 288])


// SMD Diode * 32
mods.gregtech.assembler.removeByInput(480, [metaitem('dustGalliumArsenide'), metaitem('wireFinePlatinum') * 8], [fluid('plastic') * 288])

// Ferrite Mixture Dust * 6
mods.gregtech.mixer.removeByInput(120, [metaitem('dustNickel'), metaitem('dustZinc'), metaitem('dustIron') * 4, metaitem('circuit.integrated').withNbt(["Configuration": 2])], null)
mods.gregtech.blender.removeByInput(120, [metaitem('dustNickel'), metaitem('dustZinc'), metaitem('dustIron') * 4, metaitem('circuit.integrated').withNbt(["Configuration": 2])], null)

// Nickel Zinc Ferrite Ingot * 1
mods.gregtech.electric_blast_furnace.removeByInput(120, [metaitem('dustFerriteMixture')], [fluid('oxygen') * 2000])

// Alumina Plate * 1
mods.gregtech.fluid_solidifier.removeByInput(7, [metaitem('shape.mold.plate')], [fluid('alumina') * 144])
// Alumina Plate * 1
mods.gregtech.compressor.removeByInput(2, [metaitem('dustAlumina')], null)

// Advanced SMD Transistor * 16
mods.gregtech.assembler.removeByInput(3840, [metaitem('foilVanadiumGallium'), metaitem('wireFineHssg') * 8], [fluid('polybenzimidazole') * 144])


//SMD Diodes

//n-doped silicon

//platinum
//palladium
//molybdenum
//tungsten

CRYSTALLIZER.recipeBuilder()
        .inputs(metaitem('seed_crystal.alumina'))
        .circuitMeta(1)
        .fluidInputs(fluid('alumina') * 4608)
        .outputs(metaitem('boule.alumina'))
        .duration(400)
        .EUt(240)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('boule.alumina'))
        .outputs(metaitem('seed_crystal.alumina'))
        .outputs(metaitem('wafer.alumina') * 32)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

for (fuel in sintering_fuels) {

    if (fuel.isPlasma) {

        SINTERING_RECIPES.recipeBuilder()
                .inputs(ore('dustAlumina'))
                .notConsumable(metaitem('shape.mold.plate'))
                .fluidInputs(fluid(fuel.name) * fuel.amountRequired)
                .outputs(metaitem('plateAlumina'))
                .fluidOutputs(fluid(fuel.byproduct) * fuel.byproductAmount)
                .duration(fuel.duration)
                .EUt(240)
                .buildAndRegister()

        SINTERING_RECIPES.recipeBuilder()
                .inputs(ore('dustBerylliumOxide'))
                .notConsumable(metaitem('shape.mold.plate'))
                .fluidInputs(fluid(fuel.name) * fuel.amountRequired)
                .outputs(metaitem('plateBerylliumOxide'))
                .fluidOutputs(fluid(fuel.byproduct) * fuel.byproductAmount)
                .duration(fuel.duration)
                .EUt(240)
                .buildAndRegister()

        SINTERING_RECIPES.recipeBuilder()
                .inputs(ore('dustTantalum'))
                .notConsumable(metaitem('shape.mold.nugget'))
                .fluidInputs(fluid(fuel.name) * fuel.amountRequired)
                .outputs(metaitem('tantalum_chip') * 32)
                .fluidOutputs(fluid(fuel.byproduct) * fuel.byproductAmount)
                .duration(fuel.duration)
                .EUt(240)
                .buildAndRegister()

    } else {

        for (comburent in sintering_comburents) {

            SINTERING_RECIPES.recipeBuilder()
                    .inputs(ore('dustAlumina'))
                    .notConsumable(metaitem('shape.mold.plate'))
                    .fluidInputs(fluid(fuel.name) * fuel.amountRequired)
                    .fluidInputs(fluid(comburent.name) * comburent.amountRequired)
                    .outputs(metaitem('plateAlumina'))
                    .fluidOutputs(fluid(fuel.byproduct) * fuel.byproductAmount)
                    .duration(fuel.duration + comburent.duration)
                    .EUt(240)
                    .buildAndRegister()

            SINTERING_RECIPES.recipeBuilder()
                    .inputs(ore('dustBerylliumOxide'))
                    .notConsumable(metaitem('shape.mold.plate'))
                    .fluidInputs(fluid(fuel.name) * fuel.amountRequired)
                    .fluidInputs(fluid(comburent.name) * comburent.amountRequired)
                    .outputs(metaitem('plateBerylliumOxide'))
                    .fluidOutputs(fluid(fuel.byproduct) * fuel.byproductAmount)
                    .duration(fuel.duration + comburent.duration)
                    .EUt(240)
                    .buildAndRegister()

            SINTERING_RECIPES.recipeBuilder()
                    .inputs(ore('dustTantalum'))
                    .notConsumable(metaitem('shape.mold.nugget'))
                    .fluidInputs(fluid(fuel.name) * fuel.amountRequired)
                    .fluidInputs(fluid(comburent.name) * comburent.amountRequired)
                    .outputs(metaitem('tantalum_chip') * 32)
                    .fluidOutputs(fluid(fuel.byproduct) * fuel.byproductAmount)
                    .duration(fuel.duration + comburent.duration)
                    .EUt(240)
                    .buildAndRegister()
        }
    }
}

MIXER.recipeBuilder()
        .inputs(ore('dustAlumina') * 5)
        .fluidInputs(fluid('glue') * 500)
        .fluidOutputs(fluid('ferroelectric_ceramic_binding') * 1000)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustRutile') * 2)
        .fluidInputs(fluid('glue') * 500)
        .fluidOutputs(fluid('ferroelectric_ceramic_binding') * 2000)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustBariumTitanate'))
        .fluidInputs(fluid('glue') * 500)
        .fluidOutputs(fluid('ferroelectric_ceramic_binding') * 4000)
        .duration(20)
        .EUt(240)
        .buildAndRegister()

COMPRESSOR.recipeBuilder()
        .notConsumable(metaitem('shape.extruder.foil'))
        .fluidInputs(fluid('ferroelectric_ceramic_binding') * 1000)
        .outputs(metaitem('ferroelectric_ceramic_foil') * 5)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

FORMING_PRESS.recipeBuilder()
        .inputs(metaitem('ferroelectric_ceramic_foil') * 2)
        .inputs(ore('foilAluminium') * 2)
        .outputs(metaitem('stacked_ceramic_capacitor'))
        .duration(100)
        .EUt(240)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('stacked_ceramic_capacitor'))
        .outputs(metaitem('raw_ceramic_capacitor') * 16)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustLead'))
        .fluidInputs(fluid('oxygen') * 1000)
        .outputs(metaitem('dustLeadOxide') * 2)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
        .inputs(ore('dustTantalum'))
        .fluidInputs(fluid('nitrogen') * 1000)
        .outputs(metaitem('dustTantalumNitride') * 2)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustLeadOxide') * 2)
        .fluidInputs(fluid('sodium_hydroxide_solution') * 1000)
        .fluidOutputs(fluid('ceramic_thick_film_paste') * 1000)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustNichrome') * 2)
        .fluidInputs(fluid('sodium_hydroxide_solution') * 1000)
        .fluidOutputs(fluid('ceramic_thick_film_paste') * 2000)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustTantalumNitride') * 2)
        .fluidInputs(fluid('sodium_hydroxide_solution') * 1000)
        .fluidOutputs(fluid('ceramic_thick_film_paste') * 2000)
        .duration(150)
        .EUt(240)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustRutheniumIvOxide'))
        .fluidInputs(fluid('sodium_hydroxide_solution') * 1000)
        .fluidOutputs(fluid('ceramic_thick_film_paste') * 3000)
        .duration(120)
        .EUt(240)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustBismuthIridate'))
        .fluidInputs(fluid('sodium_hydroxide_solution') * 1000)
        .fluidOutputs(fluid('ceramic_thick_film_paste') * 4000)
        .duration(20)
        .EUt(240)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustBismuthIiiOxide') * 5)
        .fluidInputs(fluid('sodium_hydroxide_solution') * 6000)
        .fluidInputs(fluid('chlorine') * 4000)
        .outputs(metaitem('dustSodiumBismuthate') * 10)
        .fluidOutputs(fluid('diluted_saltwater') * 8000)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustIridium'))
        .fluidInputs(fluid('chlorine') * 3000)
        .outputs(metaitem('dustIridiumChloride') * 4)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

AUTOCLAVE.recipeBuilder()
        .inputs(ore('dustSodiumBismuthate') * 10)
        .inputs(ore('dustIridiumChloride') * 8)
        .fluidInputs(fluid('sodium_hydroxide_solution') * 2000)
        .outputs(metaitem('dustBismuthIridate') * 11)
        .fluidOutputs(fluid('salt_water') * 1000)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

FORMING_PRESS.recipeBuilder()
        .inputs(metaitem('raw_ceramic_capacitor') * 4)
        .inputs(ore('wireFineTin') * 2)
        .outputs(metaitem('component.smd.capacitor') * 4)
        .duration(80)
        .EUt(240)
        .buildAndRegister()

FORMING_PRESS.recipeBuilder()
        .inputs(metaitem('raw_ceramic_capacitor') * 4)
        .inputs(ore('wireFineZinc') * 2)
        .outputs(metaitem('component.smd.capacitor') * 4)
        .duration(80)
        .EUt(240)
        .buildAndRegister()

FORMING_PRESS.recipeBuilder()
        .inputs(metaitem('raw_ceramic_capacitor') * 4)
        .inputs(ore('wireFineAluminium'))
        .outputs(metaitem('component.smd.capacitor') * 4)
        .duration(20)
        .EUt(240)
        .buildAndRegister()

VACUUM_CHAMBER.recipeBuilder()
        .fluidInputs(fluid('aluminium') * 18)
        .inputs(ore('foilPolypropylene'))
        .outputs(metaitem('metallized_plastic_film'))
        .duration(200)
        .EUt(240)
        .buildAndRegister()

VACUUM_CHAMBER.recipeBuilder()
        .fluidInputs(fluid('zinc') * 36)
        .inputs(ore('foilPolypropylene'))
        .outputs(metaitem('metallized_plastic_film'))
        .duration(400)
        .EUt(240)
        .buildAndRegister()

VACUUM_CHAMBER.recipeBuilder()
        .fluidInputs(fluid('aluminium') * 18)
        .inputs(ore('foilMylar'))
        .outputs(metaitem('metallized_plastic_film') * 2)
        .duration(30)
        .EUt(240)
        .buildAndRegister()

VACUUM_CHAMBER.recipeBuilder()
        .fluidInputs(fluid('zinc') * 36)
        .inputs(ore('foilMylar'))
        .outputs(metaitem('metallized_plastic_film') * 2)
        .duration(60)
        .EUt(240)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('metallized_plastic_film'))
        .outputs(metaitem('metallized_plastic_square') * 16)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

CHEMICAL_BATH.recipeBuilder()
        .inputs(metaitem('metallized_plastic_square') * 4)
        .fluidInputs(fluid('tin') * 80)
        .outputs(metaitem('raw_smd_capacitor') * 4)
        .duration(80)
        .EUt(240)
        .buildAndRegister()

CHEMICAL_BATH.recipeBuilder()
        .inputs(metaitem('metallized_plastic_square') * 4)
        .fluidInputs(fluid('zinc') * 80)
        .outputs(metaitem('raw_smd_capacitor') * 4)
        .duration(80)
        .EUt(240)
        .buildAndRegister()

CHEMICAL_BATH.recipeBuilder()
        .inputs(metaitem('metallized_plastic_square') * 4)
        .fluidInputs(fluid('aluminium') * 40)
        .outputs(metaitem('raw_smd_capacitor') * 4)
        .duration(20)
        .EUt(240)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(metaitem('raw_smd_capacitor') * 16)
        .fluidInputs(fluid('polydimethylsiloxane') * 72)
        .outputs(metaitem('component.smd.capacitor') * 16)
        .duration(40)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.alumina'))
        .fluidInputs(fluid('plastic') * 144)
        .outputs(metaitem('thick_film_substrate_wafer'))
        .duration(600)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.alumina'))
        .fluidInputs(fluid('polyvinyl_chloride') * 144)
        .outputs(metaitem('thick_film_substrate_wafer'))
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.alumina'))
        .fluidInputs(fluid('polytetrafluoroethylene') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 2)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(ore('plateAlumina'))
        .outputs(metaitem('wafer.alumina'))
        .duration(30)
        .EUt(240)
        .buildAndRegister()

SOLIDIFIER.recipeBuilder()
        .fluidInputs(fluid('beryllium_oxide') * 36)
        .notConsumable(metaitem('shape.mold.ball'))
        .chancedOutput(metaitem('seed_crystal.beryllium_oxide'), 1000, 1000)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

CRYSTALLIZER.recipeBuilder()
        .inputs(metaitem('seed_crystal.beryllium_oxide'))
        .circuitMeta(1)
        .fluidInputs(fluid('beryllium_oxide') * 3168)
        .outputs(metaitem('boule.beryllium_oxide'))
        .duration(400)
        .EUt(240)
        .buildAndRegister()


CUTTER.recipeBuilder()
        .inputs(metaitem('boule.beryllium_oxide'))
        .outputs(metaitem('seed_crystal.beryllium_oxide'))
        .outputs(metaitem('wafer.beryllium_oxide') * 32)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(ore('plateBerylliumOxide'))
        .outputs(metaitem('wafer.beryllium_oxide'))
        .duration(30)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.beryllium_oxide'))
        .fluidInputs(fluid('plastic') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 4)
        .duration(600)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.beryllium_oxide'))
        .fluidInputs(fluid('polyvinyl_chloride') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 4)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.beryllium_oxide'))
        .fluidInputs(fluid('polytetrafluoroethylene') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 8)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .circuitMeta(1)
        .inputs(ore('plateStainlessSteel'))
        .fluidInputs(fluid('plastic') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 2)
        .duration(600)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .circuitMeta(1)
        .inputs(ore('plateStainlessSteel'))
        .fluidInputs(fluid('polyvinyl_chloride') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 2)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .circuitMeta(1)
        .inputs(ore('plateStainlessSteel'))
        .fluidInputs(fluid('polytetrafluoroethylene') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 4)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.silicon_dioxide'))
        .fluidInputs(fluid('plastic') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 2)
        .duration(600)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.silicon_dioxide'))
        .fluidInputs(fluid('polyvinyl_chloride') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 2)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('wafer.silicon_dioxide'))
        .fluidInputs(fluid('polytetrafluoroethylene') * 144)
        .outputs(metaitem('thick_film_substrate_wafer') * 4)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('thick_film_substrate_wafer'))
        .outputs(metaitem('patterned_thick_film_substrate_wafer'))
        .duration(600)
        .EUt(240)
        .buildAndRegister()

LASER_ENGRAVER.recipeBuilder()
        .inputs(metaitem('thick_film_substrate_wafer'))
        .outputs(metaitem('patterned_thick_film_substrate_wafer'))
        .duration(50)
        .EUt(240)
        .buildAndRegister()

CHEMICAL_BATH.recipeBuilder()
        .inputs(metaitem('patterned_thick_film_substrate_wafer'))
        .fluidInputs(fluid('ceramic_thick_film_paste') * 1000)
        .outputs(metaitem('thick_film_resistor_wafer'))
        .duration(100)
        .EUt(240)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('thick_film_resistor_wafer'))
        .outputs(metaitem('component.smd.resistor') * 16)
        .duration(300)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(ore('foilAluminium') * 2)
        .inputs(item('minecraft:paper'))
        .outputs(metaitem('raw_capacitor_roll') * 8)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

CANNER.recipeBuilder()
        .inputs(metaitem('raw_capacitor_roll') * 8)
        .inputs(ore('dustManganeseDioxide') * 1)
        .outputs(metaitem('aluminium_electrolytic_capacitor') * 8)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('ethylene_glycol') * 1000)
        .inputs(ore('dustBoricAcid') * 3)
        .fluidOutputs(fluid('borax_electrolyte') * 1000)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

CHEMICAL_BATH.recipeBuilder()
        .inputs(metaitem('raw_capacitor_roll') * 16)
        .fluidInputs(fluid('borax_electrolyte') * 100)
        .outputs(metaitem('aluminium_electrolytic_capacitor') * 16)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('aluminium_electrolytic_capacitor') * 16)
        .inputs(ore('ringRubber') * 4)
        .inputs(ore('foilAluminium') * 2)
        .outputs(metaitem('component.smd.capacitor') * 16)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('aluminium_electrolytic_capacitor') * 16)
        .inputs(ore('ringSiliconeRubber') * 2)
        .inputs(ore('foilAluminium') * 2)
        .outputs(metaitem('component.smd.capacitor') * 16)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(metaitem('aluminium_electrolytic_capacitor') * 16)
        .inputs(ore('ringStyreneButadieneRubber') * 1)
        .inputs(ore('foilAluminium') * 2)
        .outputs(metaitem('component.smd.capacitor') * 16)
        .duration(80)
        .EUt(240)
        .buildAndRegister()

ELECTROLYZER.recipeBuilder()
        .inputs(metaitem('tantalum_chip') * 8)
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .outputs(metaitem('anodized_tantalum_chip') * 8)
        .duration(40)
        .EUt(240)
        .buildAndRegister()

PYROLYSE.recipeBuilder()
        .inputs(metaitem('anodized_tantalum_chip') * 8)
        .inputs(ore('dustManganeseIiNitrate'))
        .outputs(metaitem('manganized_tantalum_chip') * 8)
        .duration(40)
        .EUt(240)
        .buildAndRegister()

CHEMICAL_BATH.recipeBuilder()
        .inputs(metaitem('manganized_tantalum_chip') * 8)
        .fluidInputs(fluid('silver') * 36)
        .outputs(metaitem('component.smd.capacitor') * 8)
        .duration(40)
        .EUt(240)
        .buildAndRegister()

EBF.recipeBuilder()
        .inputs(ore('dustPurifiedIronIiiOxide') * 10)
        .inputs(ore('dustZincOxide') * 2)
        .inputs(ore('dustNickelIiOxide') * 2)
        .outputs(metaitem('ingotNickelZincFerrite') * 14)
        .blastFurnaceTemp(1200)
        .duration(300)
        .EUt(60)
        .buildAndRegister()

EBF.recipeBuilder()
        .inputs(ore('dustPurifiedIronIiiOxide') * 10)
        .inputs(ore('dustZincOxide') * 2)
        .inputs(ore('dustManganeseIiOxide') * 2)
        .outputs(metaitem('ingotManganeseZincFerrite') * 14)
        .blastFurnaceTemp(1200)
        .duration(300)
        .EUt(60)
        .buildAndRegister()

EBF.recipeBuilder()
        .inputs(ore('dustPurifiedIronIiiOxide') * 30)
        .inputs(ore('dustBariumCarbonate') * 5)
        .outputs(metaitem('ingotBariumFerrite') * 32)
        .fluidOutputs(fluid('carbon_dioxide') * 1000)
        .blastFurnaceTemp(1200)
        .duration(100)
        .EUt(60)
        .buildAndRegister()

EBF.recipeBuilder()
        .inputs(ore('dustPurifiedIronIiiOxide') * 30)
        .inputs(ore('dustStrontiumCarbonate') * 5)
        .outputs(metaitem('ingotStrontiumFerrite') * 32)
        .fluidOutputs(fluid('carbon_dioxide') * 1000)
        .blastFurnaceTemp(1200)
        .duration(100)
        .EUt(60)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 36)
        .inputs(ore('ringManganeseZincFerrite'))
        .inputs(ore('wireFineCopper') * 2)
        .outputs(metaitem('component.inductor') * 4)
        .duration(320)
        .EUt(120)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 36)
        .inputs(ore('ringManganeseZincFerrite'))
        .inputs(ore('wireFineAnnealedCopper') * 2)
        .outputs(metaitem('component.inductor') * 8)
        .duration(320)
        .EUt(120)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(ore('ringManganeseZincFerrite'))
        .inputs(ore('wireFineCupronickel') * 4)
        .outputs(metaitem('component.smd.inductor') * 8)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(ore('ringNickelZincFerrite'))
        .inputs(ore('wireFineCupronickel') * 4)
        .outputs(metaitem('component.smd.inductor') * 8)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(ore('ringCobaltFerrite'))
        .inputs(ore('wireFineCupronickel') * 4)
        .outputs(metaitem('component.smd.inductor') * 12)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(ore('ringBariumFerrite'))
        .inputs(ore('wireFineCupronickel') * 4)
        .outputs(metaitem('component.smd.inductor') * 16)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(ore('ringStrontiumFerrite'))
        .inputs(ore('wireFineCupronickel') * 4)
        .outputs(metaitem('component.smd.inductor') * 20)
        .duration(40)
        .EUt(240)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(metaitem('wafer.silicon'))
        .fluidInputs(fluid('oxygen') * 1000)
        .outputs(metaitem('wafer.silicon_dioxide'))
        .cleanroom(CleanroomType.CLEANROOM)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

CVD.recipeBuilder()
        .inputs(metaitem('wafer.silicon'))
        .fluidInputs(fluid('zirconium_tetrachloride') * 180)
        .fluidInputs(fluid('water') * 500)
        .outputs(metaitem('wafer.insulated_silicon'))
        .fluidOutputs(fluid('hydrogen_chloride') * 1000)
        .cleanroom(CleanroomType.CLEANROOM)
        .duration(80)
        .EUt(240)
        .buildAndRegister()

CVD.recipeBuilder()
        .inputs(metaitem('wafer.silicon_germanium'))
        .fluidInputs(fluid('zirconium_tetrachloride') * 180)
        .fluidInputs(fluid('water') * 500)
        .outputs(metaitem('wafer.insulated_silicon_germanium'))
        .fluidOutputs(fluid('hydrogen_chloride') * 1000)
        .cleanroom(CleanroomType.CLEANROOM)
        .duration(80)
        .EUt(240)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('wafer.n_doped.silicon'))
        .fluidInputs(fluid('ultrapure_water') * 100)
        .outputs(metaitem('chip.n_doped_silicon') * 16)
        .cleanroom(CleanroomType.CLEANROOM)
        .duration(200)
        .EUt(120)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('wafer.silicon_dioxide'))
        .fluidInputs(fluid('ultrapure_water') * 100)
        .outputs(metaitem('chip.silicon_dioxide') * 16)
        .cleanroom(CleanroomType.CLEANROOM)
        .duration(500)
        .EUt(120)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('wafer.insulated_silicon'))
        .fluidInputs(fluid('ultrapure_water') * 100)
        .outputs(metaitem('chip.insulated_silicon') * 24)
        .cleanroom(CleanroomType.CLEANROOM)
        .duration(200)
        .EUt(120)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .inputs(metaitem('wafer.insulated_silicon_germanium'))
        .fluidInputs(fluid('ultrapure_water') * 100)
        .outputs(metaitem('chip.insulated_silicon_germanium') * 32)
        .duration(80)
        .EUt(120)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon_germanium') * 8)
        .inputs(ore('wireFineCopper') * 2)
        .outputs(metaitem('component.smd.transistor') * 8)
        .duration(300)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon_germanium') * 8)
        .inputs(ore('wireFineAluminium') * 2)
        .outputs(metaitem('component.smd.transistor') * 10)
        .duration(250)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon_germanium') * 8)
        .inputs(ore('wireFineTantalum') * 2)
        .outputs(metaitem('component.smd.transistor') * 12)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon_germanium') * 8)
        .inputs(ore('wireFinePlatinum') * 2)
        .outputs(metaitem('component.smd.transistor') * 12)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon_germanium') * 8)
        .inputs(ore('wireFineTitanium') * 2)
        .outputs(metaitem('component.smd.transistor') * 16)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon_germanium') * 8)
        .inputs(ore('wireFineTungsten') * 2)
        .outputs(metaitem('component.smd.transistor') * 20)
        .duration(50)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon') * 8)
        .inputs(ore('wireFineCopper') * 2)
        .outputs(metaitem('component.smd.transistor') * 8)
        .duration(300)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon') * 8)
        .inputs(ore('wireFineAluminium') * 2)
        .outputs(metaitem('component.smd.transistor') * 10)
        .duration(250)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon') * 8)
        .inputs(ore('wireFineTantalum') * 2)
        .outputs(metaitem('component.smd.transistor') * 12)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon') * 8)
        .inputs(ore('wireFinePlatinum') * 2)
        .outputs(metaitem('component.smd.transistor') * 12)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon') * 8)
        .inputs(ore('wireFineTitanium') * 2)
        .outputs(metaitem('component.smd.transistor') * 16)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.insulated_silicon') * 8)
        .inputs(ore('wireFineTungsten') * 2)
        .outputs(metaitem('component.smd.transistor') * 20)
        .duration(50)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.silicon_dioxide') * 8)
        .inputs(ore('wireFineCopper') * 2)
        .outputs(metaitem('component.smd.transistor') * 8)
        .duration(300)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.silicon_dioxide') * 8)
        .inputs(ore('wireFineAluminium') * 2)
        .outputs(metaitem('component.smd.transistor') * 10)
        .duration(250)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.silicon_dioxide') * 8)
        .inputs(ore('wireFineTantalum') * 2)
        .outputs(metaitem('component.smd.transistor') * 12)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.silicon_dioxide') * 8)
        .inputs(ore('wireFinePlatinum') * 2)
        .outputs(metaitem('component.smd.transistor') * 12)
        .duration(200)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.silicon_dioxide') * 8)
        .inputs(ore('wireFineTitanium') * 2)
        .outputs(metaitem('component.smd.transistor') * 16)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.silicon_dioxide') * 8)
        .inputs(ore('wireFineTungsten') * 2)
        .outputs(metaitem('component.smd.transistor') * 20)
        .duration(50)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilPlatinum'))
        .inputs(ore('wireGtSingleCopper'))
        .outputs(metaitem('component.smd.diode') * 16)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilMolybdenum'))
        .inputs(ore('wireGtSingleCopper'))
        .outputs(metaitem('component.smd.diode') * 16)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilPalladium'))
        .inputs(ore('wireGtSingleCopper'))
        .outputs(metaitem('component.smd.diode') * 32)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilTungsten'))
        .inputs(ore('wireGtSingleCopper'))
        .outputs(metaitem('component.smd.diode') * 32)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilPlatinum'))
        .inputs(ore('wireGtSingleAnnealedCopper'))
        .outputs(metaitem('component.smd.diode') * 16)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilMolybdenum'))
        .inputs(ore('wireGtSingleAnnealedCopper'))
        .outputs(metaitem('component.smd.diode') * 16)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilPalladium'))
        .inputs(ore('wireGtSingleAnnealedCopper'))
        .outputs(metaitem('component.smd.diode') * 32)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilTungsten'))
        .inputs(ore('wireGtSingleAnnealedCopper'))
        .outputs(metaitem('component.smd.diode') * 32)
        .duration(100)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilGold'))
        .inputs(ore('wireGtSingleAnnealedCopper'))
        .outputs(metaitem('component.smd.diode') * 12)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .fluidInputs(fluid('plastic') * 144)
        .inputs(metaitem('chip.n_doped_silicon') * 8)
        .inputs(ore('foilGold'))
        .inputs(ore('wireGtSingleCopper'))
        .outputs(metaitem('component.smd.diode') * 12)
        .duration(400)
        .EUt(240)
        .buildAndRegister()

CRYSTALLIZER.recipeBuilder()
        .fluidInputs(fluid('high_purity_silicon') * 2304)
        .fluidInputs(fluid('high_purity_germanium') * 2304)
        .inputs(metaitem('seed_crystal.silicon'))
        .outputs(metaitem('boule.silicon_germanium'))
        .duration(9000)
        .EUt(120)
        .buildAndRegister()

CUTTER.recipeBuilder()
        .fluidInputs(fluid('ultrapure_water') * 100)
        .inputs(metaitem('boule.silicon_germanium'))
        .outputs(metaitem('wafer.silicon_germanium') * 16)
        .outputs(metaitem('seed_crystal.silicon'))
        .cleanroom(CleanroomType.CLEANROOM)
        .duration(400)
        .EUt(64)
        .buildAndRegister()