import globals.Globals

BR = recipemap('batch_reactor')
POLYMERIZATION = recipemap('polymerization_tank')
DISTILLATION_TOWER = recipemap('distillation_tower')
DISTILLERY = recipemap('distillery')
MIXER = recipemap('mixer')
DRYER = recipemap('dryer')
ELECTROLYTIC_CELL = recipemap('electrolytic_cell')

// PTFE
BR.recipeBuilder()
.inputs(metaitem('dustChromiumTrioxide') * 8)
.fluidInputs(fluid('n_octanol') * 1500)
.fluidInputs(fluid('sulfuric_acid') * 3000)
.fluidInputs(fluid('acetone') * 500)
.fluidOutputs(fluid('caprylic_acid') * 1500)
.fluidOutputs(fluid('chromium_sulfate_solution') * 500)
.duration(100)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.inputs(metaitem('dustSodiumHydroxide') * 18)
.fluidInputs(fluid('chromium_sulfate_solution') * 500)
.outputs(metaitem('dustChromiumIiiHydroxide') * 14)
.fluidOutputs(fluid('sodium_sulfate_acetone_solution') * 500)
.duration(100)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('sodium_sulfate_acetone_solution') * 1000)
.outputs(metaitem('dustSodiumSulfate') * 42)
.fluidOutputs(fluid('water') * 9000)
.fluidOutputs(fluid('acetone') * 1000)
.duration(200)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('caprylic_acid') * 1000)
.fluidInputs(fluid('thionyl_chloride') * 1000)
.fluidOutputs(fluid('octanoyl_chloride') * 1000)
.fluidOutputs(fluid('hydrogen_chloride') * 1000)
.fluidOutputs(fluid('sulfur_dioxide') * 1000)
.duration(200)
.EUt(30)
.buildAndRegister()

ELECTROLYTIC_CELL.recipeBuilder()
.notConsumable(metaitem('plateNickel'))
.notConsumable(metaitem('plateCobalt'))
.fluidInputs(fluid('octanoyl_chloride') * 1000)
.fluidInputs(fluid('hydrogen_fluoride') * 15000)
.fluidOutputs(fluid('fluorinated_octanoyl_chloride_mixture') * 1000)
.fluidOutputs(fluid('hydrogen') * 15000)
.duration(200)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('fluorinated_octanoyl_chloride_mixture') * 1000)
.fluidOutputs(fluid('perfluorooctanoyl_fluoride') * 150)
.duration(200)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('perfluorooctanoyl_fluoride') * 500)
.fluidInputs(fluid('water') * 1000)
.fluidOutputs(fluid('perfluorooctanoic_acid_mixture') * 500)
.duration(200)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('perfluorooctanoic_acid_mixture') * 500)
.outputs(metaitem('dustPerfluorooctanoicAcid') * 13)
.fluidOutputs(fluid('hydrofluoric_acid') * 500)
.duration(200)
.EUt(30)
.buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('water') * 500)
.inputs(metaitem('dustPerfluorooctanoicAcid') * 13)
.fluidOutputs(fluid('fluorinated_surfactant_mixture') * 500)
.duration(200)
.EUt(30)
.buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('tetrafluoroethylene') * 1000)
.fluidInputs(fluid('fluorinated_surfactant_mixture') * 500)
.fluidOutputs(fluid('tetrafluoroethylene_emulsion') * 1500)
.duration(200)
.EUt(30)
.buildAndRegister()

POLYMERIZATION.recipeBuilder()
.fluidInputs(fluid('tetrafluoroethylene_emulsion') * 1500)
.inputs(ore('dustTinyPotassiumPersulfate'))
.fluidOutputs(fluid('polytetrafluoroethylene_solution') * 500)
.duration(200)
.EUt(240)
.buildAndRegister()

DRYER.recipeBuilder()
.fluidInputs(fluid('polytetrafluoroethylene_solution') * 500)
.outputs(metaitem('dustPolytetrafluoroethylene'))
.fluidOutputs(fluid('fluorinated_surfactant_mixture') * 500)
.duration(200)
.EUt(30)
.buildAndRegister()
