import globals.Globals

BCR = recipemap('bubble_column_reactor')
CSTR = recipemap('continuous_stirred_tank_reactor')
POLYMERIZATION = recipemap('polymerization_tank')
DISTILLATION_TOWER = recipemap('distillation_tower')

BCR.recipeBuilder()
    .fluidInputs(fluid('phosgene') * 50)
    .fluidInputs(fluid('dichloromethane') * 50)
    .fluidOutputs(fluid('phosgene_solution') * 100)
    .EUt(480)
    .duration(3)
    .buildAndRegister()

CSTR.recipeBuilder()
    .fluidInputs(fluid('sodium_hydroxide_solution') * 100)
    .fluidInputs(fluid('bisphenol_a') * 50)
    .fluidOutputs(fluid('sodium_bisphenolate_solution') * 100)
    .EUt(480)
    .duration(3)
    .buildAndRegister()

CSTR.recipeBuilder()
    .fluidInputs(fluid('phosgene_solution') * 100)
    .fluidInputs(fluid('sodium_bisphenolate_solution') * 100)
    .fluidOutputs(fluid('oligomeric_bisphenol_solution') * 50)
    .fluidOutputs(fluid('salt_water') * 100)
    .EUt(480)
    .duration(3)
    .buildAndRegister()

POLYMERIZATION.recipeBuilder()
    .fluidInputs(fluid('oligomeric_bisphenol_solution') * 4000)
    .fluidInputs(fluid('triethylamine') * 1000)
    .outputs(metaitem('dustPolycarbonate') * 8)
    .fluidOutputs(fluid('triethylamine_solution') * 5000)
    .EUt(480)
    .duration(60)
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('triethylamine_solution') * 5000)
    .fluidOutputs(fluid('triethylamine') * 1000)
    .fluidOutputs(fluid('dichloromethane') * 4000)
    .EUt(480)
    .duration(60)
    .buildAndRegister()
