import globals.Globals

FBR = recipemap('fixed_bed_reactor')
BR = recipemap('batch_reactor')
LCR = recipemap('large_chemical_reactor')
CENTRIFUGE = recipemap('centrifuge')
DISTILLERY = recipemap('distillery')
ROASTER = recipemap('roaster')
REACTION_FURNACE = recipemap('reaction_furnace')

// Caprolactam

FBR.recipeBuilder()
.fluidInputs(fluid('nitric_oxide') * 50)
.fluidInputs(fluid('hydrogen') * 150)
.notConsumable(ore('catalystBedPlatinum'))
.fluidOutputs(fluid('hydroxylamine') * 50)
.duration(5)    
.EUt(30)
.buildAndRegister()

FBR.recipeBuilder()
.fluidInputs(fluid('cyclohexane') * 50)
.fluidInputs(fluid('oxygen') * 100)
.notConsumable(ore('catalystBedCobalt'))
.fluidOutputs(fluid('cyclohexanone') * 50)
.fluidOutputs(fluid('water') * 50)
.duration(5)    
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('cyclohexanone') * 1000)
.fluidInputs(fluid('hydroxylamine') * 1000)
.fluidOutputs(fluid('water') * 1000)
.outputs(metaitem('dustCyclohexanoneOxime') * 34)
.duration(180)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.inputs(ore('dustCyclohexanoneOxime') * 34)
.fluidInputs(fluid('sulfuric_acid') * 1000)
.fluidInputs(fluid('ammonia_solution') * 2000)
.fluidOutputs(fluid('caprolactam_solution') * 3000)
.duration(160)
.EUt(30)
.buildAndRegister()

LCR.recipeBuilder()
.fluidInputs(fluid('cyclohexanone') * 1000)
.fluidInputs(fluid('hydroxylamine') * 1000)
.fluidInputs(fluid('sulfuric_acid') * 1000)
.fluidInputs(fluid('ammonia_solution') * 2000)
.outputs(metaitem('dustCyclohexanoneOxime') * 34)
.fluidOutputs(fluid('water') * 1000)
.fluidOutputs(fluid('caprolactam_solution') * 3000)
.duration(160)
.EUt(480)
.buildAndRegister()

CENTRIFUGE.recipeBuilder()
.fluidInputs(fluid('caprolactam_solution') * 3000)
.fluidInputs(fluid('toluene') * 1000)
.fluidOutputs(fluid('extracted_caprolactam_solution') * 1000)
.fluidOutputs(fluid('diluted_ammonium_sulfate_solution') * 1000)
.duration(160)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('diluted_ammonium_sulfate_solution') * 1000)
.outputs(metaitem('dustAmmoniumSulfate') * 15)
.fluidOutputs(fluid('water') * 2000)
.duration(160)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('extracted_caprolactam_solution') * 1000)
.outputs(metaitem('dustCaprolactam'))
.fluidOutputs(fluid('toluene') * 1000)
.duration(160)
.EUt(30)
.buildAndRegister()

ROASTER.recipeBuilder()
.inputs(ore('dustAmmoniumSulfate') * 15)
.fluidOutputs(fluid('ammonia') * 1000)
.outputs(metaitem('dustAmmoniumBisulfate') * 11)
.duration(160)
.EUt(30)
.buildAndRegister()

// Polycaprolactam

REACTION_FURNACE.recipeBuilder()
.notConsumable(fluid('nitrogen') * 4000)
.inputs(ore('dustCaprolactam'))
.outputs(metaitem('dustPolycaprolactam'))
.EUt(200)
.duration(25)
.buildAndRegister()
