import globals.Globals

CSTR = recipemap('continuous_stirred_tank_reactor')
DISTILLATION_TOWER = recipemap('distillation_tower')
SIFTER = recipemap('sifter')
LCR = recipemap('large_chemical_reactor')
FBR = recipemap('fixed_bed_reactor')
REACTION_FURNACE = recipemap('reaction_furnace')
VACUUM_DT = recipemap('vacuum_distillation')
MIXER = recipemap('mixer')
CRYSTALLIZER = recipemap('crystallizer')
FBR = recipemap('fixed_bed_reactor')
BR = recipemap('batch_reactor')
FLUIDIZEDBR = recipemap('fluidized_bed_reactor')
TBR = recipemap('trickle_bed_reactor')
DISTILLERY = recipemap('distillery')
FLUID_EXTRACTOR = recipemap('extractor')
DRYER = recipemap('dryer')

// Phthalic Acid

FLUIDIZEDBR.recipeBuilder()
.fluidInputs(fluid('ortho_xylene') * 1000)
.fluidInputs(fluid('oxygen') * 6000)
.notConsumable(ore('dustVanadiumPentoxide'))
.fluidOutputs(fluid('dense_steam') * 3000)
.outputs(metaitem('dustPhthalicAnhydride') * 13)
.duration(300)
.EUt(240)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('water') * 1000)
.inputs(ore('dustPhthalicAnhydride') * 15)
.outputs(metaitem('dustPhthalicAcid') * 18)
.duration(200)
.EUt(30)
.buildAndRegister()

FBR.recipeBuilder()
.notConsumable(ore('dustVanadiumPentoxide'))
.fluidInputs(fluid('naphthalene') * 1000)
.fluidInputs(fluid('oxygen') * 9000)
.outputs(metaitem('dustPhthalicAcid') * 18)
.fluidOutputs(fluid('carbon_dioxide') * 2000)
.fluidOutputs(fluid('water') * 2000)
.duration(200)
.EUt(30)
.buildAndRegister()

// Amoco process

BR.recipeBuilder()
    .fluidInputs(fluid('methane') * 1000)
    .fluidInputs(fluid('bromine') * 8000)
    .outputs(metaitem('dustCarbonTetrabromide') * 5)
    .fluidOutputs(fluid('hydrogen_bromide') * 4000)
    .EUt(120)
    .duration(3)
    .buildAndRegister()

MIXER.recipeBuilder()
    .inputs(ore('dustCobalt'))
    .inputs(ore('dustManganese'))
    .inputs(ore('dustCarbonTetrabromide') * 5)
    .outputs(metaitem('dustAmocoProcessCatalyst') * 2)
    .EUt(120)
    .duration(120)
    .buildAndRegister()

LCR.recipeBuilder()
    .fluidInputs(fluid('para_xylene') * 1000)
    .fluidInputs(fluid('hot_hp_air') * 8000)
    .fluidInputs(fluid('acetic_acid') * 1000)
    .notConsumable(metaitem('dustAmocoProcessCatalyst'))
    .fluidOutputs(fluid('terephthalic_acid_slurry') * 2000)
    .EUt(1920)
    .duration(200)
    .buildAndRegister()

LCR.recipeBuilder()
    .fluidInputs(fluid('para_xylene') * 1000)
    .fluidInputs(fluid('hot_hp_oxygen') * 2000)
    .notConsumable(fluid('carbon_dioxide') * 6000)
    .fluidInputs(fluid('acetic_acid') * 1000)
    .notConsumable(metaitem('dustAmocoProcessCatalyst'))
    .fluidOutputs(fluid('terephthalic_acid_slurry') * 2000)
    .EUt(1920)
    .duration(200)
    .buildAndRegister()

LCR.recipeBuilder()
    .fluidInputs(fluid('meta_xylene') * 1000)
    .fluidInputs(fluid('hot_hp_air') * 8000)
    .fluidInputs(fluid('acetic_acid') * 1000)
    .notConsumable(metaitem('dustAmocoProcessCatalyst'))
    .fluidOutputs(fluid('isophthalic_acid_slurry') * 2000)
    .EUt(1920)
    .duration(200)
    .buildAndRegister()

LCR.recipeBuilder()
    .fluidInputs(fluid('meta_xylene') * 1000)
    .fluidInputs(fluid('hot_hp_oxygen') * 2000)
    .notConsumable(fluid('carbon_dioxide') * 6000)
    .fluidInputs(fluid('acetic_acid') * 1000)
    .notConsumable(metaitem('dustAmocoProcessCatalyst'))
    .fluidOutputs(fluid('isophthalic_acid_slurry') * 2000)
    .EUt(1920)
    .duration(200)
    .buildAndRegister()

SIFTER.recipeBuilder()
    .notConsumable(metaitem('item_filter'))
    .fluidInputs(fluid('isophthalic_acid_slurry') * 2000)
    .outputs(metaitem('dustAmocoIsophthalicAcid') * 18)
    .fluidOutputs(fluid('diluted_acetic_acid') * 2000)
    .EUt(120)
    .duration(100)
    .buildAndRegister()
        
SIFTER.recipeBuilder()
    .notConsumable(metaitem('item_filter'))
    .fluidInputs(fluid('terephthalic_acid_slurry') * 2000)
    .outputs(metaitem('dustAmocoTerephthalicAcid') * 18)
    .fluidOutputs(fluid('diluted_acetic_acid') * 2000)
    .EUt(120)
    .duration(100)
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('diluted_acetic_acid') * 2000)
    .fluidOutputs(fluid('acetic_acid') * 1000)
    .fluidOutputs(fluid('water') * 1000)
    .EUt(120)
    .duration(100)
    .buildAndRegister()

// Amoco purification process

MIXER.recipeBuilder()
    .inputs(ore('dustAmocoTerephthalicAcid') * 18)
    .fluidInputs(fluid('gtfo_heated_water') * 1000)
    .fluidOutputs(fluid('crude_terephthalic_acid_slurry') * 1000)
    .EUt(30)
    .duration(100)
    .buildAndRegister()

MIXER.recipeBuilder()
    .inputs(ore('dustAmocoIsophthalicAcid') * 18)
    .fluidInputs(fluid('gtfo_heated_water') * 1000)
    .fluidOutputs(fluid('crude_isophthalic_acid_slurry') * 1000)
    .EUt(30)
    .duration(100)
    .buildAndRegister()

TBR.recipeBuilder()
    .notConsumable(ore('dustPalladiumOnCarbon'))
    .fluidInputs(fluid('crude_terephthalic_acid_slurry') * 1000)
    .fluidInputs(fluid('hydrogen') * 15)
    .fluidOutputs(fluid('hydrogenated_terephthalic_acid_slurry') * 1005)
    .EUt(120)
    .duration(100)
    .buildAndRegister()

TBR.recipeBuilder()
    .notConsumable(ore('dustPalladiumOnCarbon'))
    .fluidInputs(fluid('crude_isophthalic_acid_slurry') * 1000)
    .fluidInputs(fluid('hydrogen') * 15)
    .fluidOutputs(fluid('hydrogenated_isophthalic_acid_slurry') * 1005)
    .EUt(120)
    .duration(100)
    .buildAndRegister()

CRYSTALLIZER.recipeBuilder()
    .fluidInputs(fluid('hydrogenated_terephthalic_acid_slurry') * 1005)
    .outputs(metaitem('dustWetTerephthalicAcid') * 18)
    .fluidOutputs(fluid('amoco_purification_mother_liquor') * 505)
    .EUt(120)
    .duration(100)
    .buildAndRegister()
    
CRYSTALLIZER.recipeBuilder()
    .fluidInputs(fluid('hydrogenated_isophthalic_acid_slurry') * 1005)
    .outputs(metaitem('dustWetIsophthalicAcid') * 18)
    .fluidOutputs(fluid('amoco_purification_mother_liquor') * 505)
    .EUt(120)
    .duration(100)
    .buildAndRegister()

DRYER.recipeBuilder()
    .inputs(metaitem('dustWetTerephthalicAcid') * 18)
    .outputs(metaitem('dustTerephthalicAcid') * 18)
    .fluidOutputs(fluid('water') * 500)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

DRYER.recipeBuilder()
    .inputs(metaitem('dustWetIsophthalicAcid') * 18)
    .outputs(metaitem('dustIsophthalicAcid') * 18)
    .fluidOutputs(fluid('water') * 500)
    .duration(200)
    .EUt(30)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('amoco_purification_mother_liquor') * 505)
    .chancedOutput(metaitem('dustParaToluicAcid'), 50, 0)
    .fluidOutputs(fluid('water') * 500)
    .EUt(30)
    .duration(100)
    .buildAndRegister()

FLUID_EXTRACTOR.recipeBuilder()
    .inputs(ore('dustParaToluicAcid'))
    .fluidOutputs(fluid('para_toluic_acid') * 1000)
    .EUt(30)
    .duration(100)
    .buildAndRegister()

// Dynamit-Nobel process
// Initialization
FBR.recipeBuilder() 
    .circuitMeta(1)
    .notConsumable(metaitem('catalystBedCobalt'))
    .fluidInputs(fluid('para_xylene') * 50)
    .fluidInputs(fluid('oxygen') * 150)
    .fluidOutputs(fluid('water') * 50)
    .fluidOutputs(fluid('para_toluic_acid') * 50)
    .EUt(120)
    .duration(20)
    .buildAndRegister()

REACTION_FURNACE.recipeBuilder() 
    .fluidInputs(fluid('para_toluic_acid') * 1000)
    .fluidInputs(fluid('methanol') * 1000)
    .fluidOutputs(fluid('water') * 1000)
    .fluidOutputs(fluid('methyl_para_toluate') * 1000)
    .EUt(120)
    .duration(400)
    .buildAndRegister()

// Looping
FBR.recipeBuilder() 
    .circuitMeta(2)
    .notConsumable(metaitem('catalystBedCobalt'))
    .fluidInputs(fluid('para_xylene') * 50)
    .fluidInputs(fluid('methyl_para_toluate') * 50)
    .fluidInputs(fluid('oxygen') * 300)
    .fluidOutputs(fluid('water') * 100)
    .fluidOutputs(fluid('para_toluate_mixture') * 100)
    .EUt(120)
    .duration(20)
    .buildAndRegister()

REACTION_FURNACE.recipeBuilder() 
    .fluidInputs(fluid('para_toluate_mixture') * 2000)
    .fluidInputs(fluid('methanol') * 2000)
    .fluidOutputs(fluid('water') * 2000)
    .fluidOutputs(fluid('methyl_para_toluate_mixture') * 2000)
    .EUt(120)
    .duration(400)
    .buildAndRegister()

VACUUM_DT.recipeBuilder()
    .fluidInputs(fluid('methyl_para_toluate_mixture') * 2000)
    .outputs(metaitem('dustCrudeDimethylTerephthalate') * 24)
    .fluidOutputs(fluid('methyl_para_toluate') * 1000)
    .EUt(120)
    .duration(400)
    .buildAndRegister()

// Dynamit-Nobel purification process
// Initialization
MIXER.recipeBuilder()
    .inputs(ore('dustCrudeDimethylTerephthalate') * 24)
    .fluidInputs(fluid('methanol') * 1000)
    .fluidOutputs(fluid('crude_dimethyl_terephthalate_solution') * 1000)
    .EUt(120)
    .duration(20)
    .buildAndRegister()

CRYSTALLIZER.recipeBuilder()
    .fluidInputs(fluid('crude_dimethyl_terephthalate_solution') * 1000)
    .outputs(metaitem('dustDimethylTerephthalate') * 12)
    .fluidOutputs(fluid('terephthalate_mother_liquor') * 1000)
    .EUt(120)
    .duration(200)
    .buildAndRegister()

// Looping
MIXER.recipeBuilder()
    .inputs(ore('dustCrudeDimethylTerephthalate') * 12)
    .fluidInputs(fluid('terephthalate_mother_liquor') * 1000)
    .fluidOutputs(fluid('crude_dimethyl_terephthalate_solution') * 1000)
    .EUt(120)
    .duration(20)
    .buildAndRegister()

// Isophthaloyl chloride

BR.recipeBuilder()
    .fluidInputs(fluid('one_two_dichloroethane') * 1000)
    .inputs(ore('dustIsophthalicAcid') * 18)
    .fluidOutputs(fluid('dichloroethane_isophthalic_acid_solution') * 1000)
    .duration(120)
    .EUt(30)
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('dichloroethane_isophthalic_acid_solution') * 1000)
    .fluidInputs(fluid('phosgene') * 2000)
    .fluidOutputs(fluid('isophthaloyl_chloride_solution') * 1000)
    .fluidOutputs(fluid('carbon_dioxide') * 2000)
    .fluidOutputs(fluid('hydrogen_chloride') * 2000)
    .duration(10)
    .EUt(30)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('isophthaloyl_chloride_solution') * 1000)
    .outputs(metaitem('dustIsophthaloylChloride') * 16)
    .fluidOutputs(fluid('one_two_dichloroethane') * 1000)
    .duration(40)
    .EUt(30)
    .buildAndRegister()

// Terephthaloyl chloride

BR.recipeBuilder()
    .inputs(ore('dustTerephthalicAcid') * 3)
    .fluidInputs(fluid('bistrichloromethylbenzene') * 1000)
    .outputs(metaitem('dustTerephthaloylChloride') * 32)
    .fluidOutputs(fluid('hydrogen_chloride') * 2000)
    .duration(300)
    .EUt(30)
    .buildAndRegister()
