ROASTER = recipemap('roaster')
EBF = recipemap('electric_blast_furnace')
BR = recipemap('batch_reactor')
DISTILLERY = recipemap('distillery')
VACUUM_DT = recipemap('vacuum_distillation')

ROASTER.recipeBuilder()
        .inputs(ore('dustGypsum') * 8)
        .outputs(metaitem('dustCalciumSulfate') * 6)
        .fluidOutputs(fluid('dense_steam') * 2000)
        .EUt(30)
        .duration(160)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .circuitMeta(1)
        .inputs(ore('dustCalciumSulfate') * 6)
        .outputs(metaitem('dustQuicklime') * 2)
        .fluidOutputs(fluid('sulfur_trioxide') * 1000)
        .EUt(30)
        .duration(160)
        .buildAndRegister()

VACUUM_DT.recipeBuilder()
        .inputs(ore('dustCalcium'))
        .outputs(metaitem('dustHighPurityCalcium'))
        .EUt(30)
        .duration(20)
        .buildAndRegister()

ELECTROLYZER.recipeBuilder()
        .notConsumable(metaitem('graphite_electrode'))
        .notConsumable(metaitem('stickSteel'))
        .fluidInputs(fluid('calcium_chloride') * 432)
        .fluidOutputs(fluid('chlorine') * 2000)
        .outputs(metaitem('dustCalcium'))
        .EUt(30)
        .duration(300)
        .buildAndRegister()