ASSEMBLER = recipemap('assembler')
PSA = recipemap('pressure_swing_adsorption')
AUTOCLAVE = recipemap('autoclave')
DRYER = recipemap('dryer')

ASSEMBLER.recipeBuilder()
        .inputs(ore('wireFineAluminium') * 8)
        .circuitMeta(8)
        .outputs(metaitem('zeolite_membrane_support') * 1)
        .duration(180)
        .EUt(30)
        .buildAndRegister()

AUTOCLAVE.recipeBuilder()
        .fluidInputs(fluid('distilled_water') * 1000)
        .inputs(ore('dustMolecularSieve') * 4)
        .inputs(metaitem('zeolite_membrane_support') * 1)
        .outputs(metaitem('zeolite_membrane') * 1)
        .duration(180)
        .EUt(30)
        .buildAndRegister()

PSA.recipeBuilder()
        .fluidInputs(fluid('air') * 10000)
        .notConsumable(metaitem('zeolite_membrane') * 1)
        .fluidOutputs(fluid('nitrogen') * 7808)
        .fluidOutputs(fluid('oxygen') * 2095)
        .duration(100)
        .EUt(64)
        .buildAndRegister()