import globals.Globals

BR = recipemap('batch_reactor')
CSTR = recipemap('continuous_stirred_tank_reactor')
DISTILLERY = recipemap('distillery')
DISTILLATION_TOWER = recipemap('distillation_tower')
ROASTER = recipemap('roaster')
MACERATOR = recipemap('macerator')
SIFTER = recipemap('sifter')
CRYSTALLIZER = recipemap('crystallizer')
REACTION_FURNACE = recipemap('reaction_furnace')

//LOW YIELD CHAIN FROM SECONDARY ORES
MACERATOR.recipeBuilder()
    .inputs(item('susy:resource_block', 10))
    .outputs(metaitem('dustAlluvialPgmSand') * 9)
    .duration(160)
    .EUt(30)
    .buildAndRegister()

SIFTER.recipeBuilder()
    .inputs(ore('dustAlluvialPgmSand'))
    .outputs(metaitem('nuggetAlluvialPgm') * 4)
    .outputs(metaitem('dustNetherQuartz') * 3)
    .duration(160)
    .EUt(30)
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustAlluvialPgm') * 2)
    .fluidInputs(fluid('aqua_regia') * 12000)
    .fluidInputs(fluid('nitric_acid') * 1000)
    .fluidOutputs(fluid('alluvial_pgm_solution') * 5000)
    .fluidOutputs(fluid('hydrogen') * 1000)
    .fluidOutputs(fluid('nitrogen_dioxide') * 5000)
    .duration(120)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustAnyPurityZinc'))
    .fluidInputs(fluid('alluvial_pgm_solution') * 10000)
    .outputs(metaitem('dustIronIiChloride') * 3)
    .fluidOutputs(fluid('cemented_alluvial_pgm_solution') * 10000)
    .duration(240)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

CRYSTALLIZER.recipeBuilder() // 2 H2PtCl6 + 4 NH4Cl --> 2 (NH4)2PtCl6 + 4 HCl
    .circuitMeta(1)
    .fluidInputs(fluid('cemented_alluvial_pgm_solution') * 10000)  // 67% (NH4)2Pt, 33% H2PdCl4
    .fluidInputs(fluid('ammonium_chloride_solution') * 4000)
    .chancedOutput(metaitem('dustAmmoniumHexachloroplatinate') * 34, 7500, 0)
    .fluidOutputs(fluid('alluvial_platinum_mother_liquor') * 14000)
    .duration(240)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('alluvial_platinum_mother_liquor') * 14000)
    .chancedOutput(metaitem('dustZincChloride') * 3, 9000, 0)
    .fluidOutputs(fluid('ammonium_chloride_solution') * 1000)
    .fluidOutputs(fluid('water') * 13000)
    .fluidOutputs(fluid('hydrogen_chloride') * 4000)
    .duration(240)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
    .inputs(ore('dustAmmoniumHexachloroplatinate') * 17)
    .fluidInputs(fluid('hydrogen') * 4000)
    .outputs(metaitem('sponge.platinum'))
    .fluidOutputs(fluid('ammonia') * 2000)
    .fluidOutputs(fluid('hydrogen_chloride') * 6000)
    .duration(240)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

MACERATOR.recipeBuilder()
    .inputs(metaitem('sponge.platinum'))
    .outputs(metaitem('dustPlatinum'))
    .duration(240)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

BR.recipeBuilder()
    .notConsumable(ore('springCupronickel'))
    .fluidInputs(fluid('alluvial_platinum_mother_liquor') * 14000)
    .fluidOutputs(fluid('alluvial_divalent_palladium_solution') * 14000)
    .fluidOutputs(fluid('chlorine') * 50)
    .duration(120)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

CRYSTALLIZER.recipeBuilder()
    .fluidInputs(fluid('ammonia_solution') * 1000)
    .fluidInputs(fluid('alluvial_divalent_palladium_solution') * 7000) //(H2PdCl4)(ZnCl2)(HCl)4(H2O)14
    .chancedOutput(metaitem('dustDiamminedichloropalladium') * 11, 3750, 0)
    .fluidOutputs(fluid('alluvial_palladium_mother_liquor') * 8000) //(NH4Cl)2(ZnCl2)(HCl)4(H2O)16
    .duration(60)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
    .inputs(ore('dustDiamminedichloropalladium') * 11)
    .fluidInputs(fluid('hydrogen') * 4000)
    .outputs(metaitem('dustPalladium'))
    .fluidOutputs(fluid('ammonia') * 2000)
    .fluidOutputs(fluid('hydrogen_chloride') * 2000)
    .duration(240)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('alluvial_palladium_mother_liquor') * 16000)
    .chancedOutput(metaitem('dustZincChloride') * 3, 9500, 0)
    .fluidOutputs(fluid('ammonium_chloride_solution') * 2000)
    .fluidOutputs(fluid('water') * 14000)
    .fluidOutputs(fluid('hydrogen_chloride') * 4000)
    .duration(240)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

//MODERN SEPARATION PROCESSES
    
