import globals.Globals
import static globals.CarbonGlobals.*

import static gregtech.api.unification.material.Materials.*;
import gregtech.api.unification.material.MarkerMaterials;
import static gregtech.api.unification.ore.OrePrefix.dye;

VACUUM_FREEZER = recipemap('vacuum_freezer')
CSTR = recipemap('continuous_stirred_tank_reactor')
TBR = recipemap('trickle_bed_reactor')
FBR = recipemap('fixed_bed_reactor')
BCR = recipemap('bubble_column_reactor')
BR = recipemap('batch_reactor')
POLYMERIZATION = recipemap('polymerization_tank')
FLUIDIZEDBR = recipemap('fluidized_bed_reactor')
DISTILLATION_TOWER = recipemap('distillation_tower')
DISTILLERY = recipemap('distillery')
ROASTER = recipemap('roaster')
MIXER = recipemap('mixer')
DRYER = recipemap('dryer')
SIFTER = recipemap('sifter')
CENTRIFUGE = recipemap('centrifuge')
PYROLYSE = recipemap('pyrolyse_oven')
LCR = recipemap('large_chemical_reactor')
EBF = recipemap('electric_blast_furnace')
VULCANIZER = recipemap('vulcanizing_press')
ALLOY_SMELTER = recipemap('alloy_smelter')
ARC_FURNACE = recipemap('arc_furnace')
ADVANCED_ARC_FURNACE = recipemap('advanced_arc_furnace')
AUTOCLAVE = recipemap('autoclave')
COMPRESSOR = recipemap('compressor')
ASSEMBLER = recipemap('assembler')
ELECTROLYZER = recipemap('electrolyzer')
ELECTROLYTIC_CELL = recipemap('electrolytic_cell')
REACTION_FURNACE = recipemap('reaction_furnace')
ELECTROMAGNETIC_SEPARATOR = recipemap('electromagnetic_separator')
PSA = recipemap('pressure_swing_adsorption')
CHEMICAL_BATH = recipemap('chemical_bath')
ION_EXCHANGE = recipemap('ion_exchange_column')
FLUID_EXTRACTOR = recipemap('extractor')
TUBE_FURNACE = recipemap('tube_furnace')
SINTERING_OVEN = recipemap('sintering_oven')
VACUUM_DT = recipemap('vacuum_distillation')
CRACKER = recipemap('cracker')
FLUID_HEATER = recipemap('fluid_heater')
PHASE_SEPARATOR = recipemap('phase_separator')
CONDENSER = recipemap('condenser')

ASSEMBLER.recipeBuilder()
        .inputs(ore('stickIron') * 4)
        .inputs(ore('pipeTinyFluidSteel') * 4)
        .outputs(metaitem('susy:catalyst_bed_support_grid'))
        .EUt(30)
        .duration(160)
        .buildAndRegister()

// Ammonium Chloride

BCR.recipeBuilder()
.fluidInputs(fluid('hydrochloric_acid') * 50)
.fluidInputs(fluid('ammonia') * 50)
.fluidOutputs(fluid('ammonium_chloride_solution') * 50)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('ammonium_chloride_solution') * 1000)
.outputs(metaitem('dustAmmoniumChloride') * 6)
.fluidOutputs(fluid('water') * 1000)
.duration(120)
.EUt(30)
.buildAndRegister()

// Carbon Monoxide roaster
// TODO: set output according to carbon amount?
for (carbon in sources) {
    ROASTER.recipeBuilder()
        .fluidInputs(fluid('oxygen') * 1000)
        .inputs(ore(carbon.name) * carbon.equivalent(1))
        .circuitMeta(1)
        .fluidOutputs(fluid('carbon_monoxide') * 1000)
        .duration(80)
        .EUt(7)
        .buildAndRegister()
}

// Carbon Dioxide roaster
// TODO: set output according to carbon amount?
for (carbon in sources) {
    ROASTER.recipeBuilder()
        .fluidInputs(fluid('oxygen') * 2000)
        .inputs(ore(carbon.name) * carbon.equivalent(1))
        .circuitMeta(2)
        .fluidOutputs(fluid('carbon_dioxide') * 1000)
        .duration(40)
        .EUt(7)
        .buildAndRegister()
}

//CARBON DISULFIDE

for (carbon in sources) {
    ROASTER.recipeBuilder()
        .inputs(ore(carbon.name) * carbon.equivalent(1))
        .inputs(ore('dustAnyPuritySulfur') * 2)
        .fluidOutputs(fluid('carbon_disulfide') * 1000)
        .duration(100)
        .EUt(60)
        .buildAndRegister()
}


// Phosphorous Pentoxide roaster

ROASTER.recipeBuilder()
.fluidInputs(fluid('oxygen') * 10000)
.inputs(ore('dustPhosphorus') * 4)
.outputs(metaitem('dustPhosphorusPentoxide') * 14)
.duration(40)
.EUt(30)
.buildAndRegister()

// Sulfur Dioxide roaster

ROASTER.recipeBuilder()
.fluidInputs(fluid('oxygen') * 2000)
.inputs(ore('dustAnyPuritySulfur'))
.fluidOutputs(fluid('sulfur_dioxide') * 1000)
.duration(60)
.EUt(7)
.buildAndRegister()

//Phosphoric Acid batch

BR.recipeBuilder()
.inputs(ore('dustPhosphorusPentoxide'))
.fluidInputs(fluid('water') * 6000)
.fluidOutputs(fluid('phosphoric_acid') * 4000)
.duration(40)
.EUt(30)
.buildAndRegister()

//Hydrochloric Acid

CSTR.recipeBuilder()
.fluidInputs(fluid('hydrogen') * 50)
.fluidInputs(fluid('chlorine') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.duration(1)
.EUt(7)
.buildAndRegister()

BCR.recipeBuilder()
.circuitMeta(1)
.fluidInputs(fluid('hydrogen_chloride') * 50)
.fluidInputs(fluid('water') * 50)
.fluidOutputs(fluid('hydrochloric_acid') * 50)
.duration(1)
.EUt(7)
.buildAndRegister()

BCR.recipeBuilder()
.circuitMeta(2)
.fluidInputs(fluid('hydrogen_chloride') * 50)
.fluidInputs(fluid('water') * 100)
.fluidOutputs(fluid('diluted_hydrochloric_acid') * 100)
.duration(1)
.EUt(7)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('hydrochloric_acid') * 50)
.fluidInputs(fluid('water') * 50)
.fluidOutputs(fluid('diluted_hydrochloric_acid') * 100)
.duration(1)
.EUt(7)
.buildAndRegister()

//Chlorine

FLUIDIZEDBR.recipeBuilder()
        .notConsumable(metaitem('dustCopperIiChloride'))
        .fluidInputs(fluid('hydrogen_chloride') * 1000)
        .fluidInputs(fluid('oxygen') * 500)
        .fluidOutputs(fluid('chlorine') * 1000)
        .fluidOutputs(fluid('dense_steam') * 500)
        .duration(40)
        .EUt(120)
        .buildAndRegister()

FLUIDIZEDBR.recipeBuilder()
        .notConsumable(metaitem('dustRutheniumIvOxide'))
        .fluidInputs(fluid('hydrogen_chloride') * 1000)
        .fluidInputs(fluid('oxygen') * 500)
        .fluidOutputs(fluid('chlorine') * 1000)
        .fluidOutputs(fluid('dense_steam') * 500)
        .duration(10)
        .EUt(120)
        .buildAndRegister()

// Hexafluorosilicic Acid

BR.recipeBuilder()
        .inputs(ore('dustSiliconDioxide') * 3)
        .fluidInputs(fluid('hydrofluoric_acid') * 6000)
        .fluidOutputs(fluid('diluted_hexafluorosilicic_acid') * 9000)
        .duration(160)
        .EUt(30)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('diluted_hexafluorosilicic_acid') * 9000)
        .fluidOutputs(fluid('hexafluorosilicic_acid') * 1000)
        .fluidOutputs(fluid('water') * 8000)
        .duration(160)
        .EUt(30)
        .buildAndRegister()

// Hydrofluoric acid

BR.recipeBuilder()
        .inputs(ore('dustFluorite') * 3)
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .fluidOutputs(fluid('hydrogen_fluoride') * 2000)
        .outputs(metaitem('dustCalciumSulfate') * 6)
        .duration(30)
        .EUt(7)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('hydrogen') * 50)
        .fluidInputs(fluid('fluorine') * 50)
        .fluidOutputs(fluid('hydrogen_fluoride') * 50)
        .duration(1)
        .EUt(7)
        .buildAndRegister()

BCR.recipeBuilder()
        .fluidInputs(fluid('hydrogen_fluoride') * 50)
        .fluidInputs(fluid('water') * 50)
        .fluidOutputs(fluid('hydrofluoric_acid') * 50)
        .duration(1)
        .EUt(7)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('hydrofluoric_acid') * 500)
        .fluidOutputs(fluid('water') * 500)
        .fluidOutputs(fluid('hydrogen_fluoride') * 500)
        .duration(50)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustCalciumSulfate') * 6)
        .inputs(ore('dustAnyPurityCarbon') * 2)
        .outputs(metaitem('dustCalciumSulfide') * 2)
        .fluidOutputs(fluid('carbon_dioxide') * 2000)
        .duration(30)
        .EUt(7)
        .buildAndRegister()

// Fe2O3

ROASTER.recipeBuilder()
        .fluidInputs(fluid('water') * 4000)
        .inputs(ore('dustIron') * 3)
        .outputs(metaitem('dustIronTwoThreeOxide') * 7)
        .fluidOutputs(fluid('hydrogen') * 8000)
        .duration(160)
        .EUt(60)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .fluidInputs(fluid('water') * 4000)
        .inputs(ore('dustHighPurityIron') * 3)
        .outputs(metaitem('dustPurifiedIronTwoThreeOxide') * 7)
        .fluidOutputs(fluid('hydrogen') * 8000)
        .duration(160)
        .EUt(60)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .fluidInputs(fluid('oxygen') * 1000)
        .inputs(ore('dustIronTwoThreeOxide') * 14)
        .outputs(metaitem('dustIronIiiOxide') * 15)
        .duration(160)
        .EUt(60)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .fluidInputs(fluid('oxygen') * 1000)
        .inputs(ore('dustPurifiedIronTwoThreeOxide') * 14)
        .outputs(metaitem('dustPurifiedIronIiiOxide') * 15)
        .duration(160)
        .EUt(60)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .inputs(ore('dustIronIiSulfide') * 2)
        .outputs(metaitem('dustIronSulfate') * 6)
        .fluidOutputs(fluid('hydrogen_sulfide') * 1000)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .inputs(ore('dustAnyPurityIron') * 1)
        .outputs(metaitem('dustIronSulfate') * 6)
        .fluidOutputs(fluid('hydrogen') * 2000)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustIronSulfate') * 12)
        .outputs(metaitem('dustIronIiiOxide') * 5)
        .fluidOutputs(fluid('sulfur_dioxide') * 1000)
        .fluidOutputs(fluid('sulfur_trioxide') * 1000)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

// Hydrogen Sulfide

BR.recipeBuilder()
.inputs(ore('dustIronIiSulfide') * 2)
.fluidInputs(fluid('hydrochloric_acid') * 2000)
.outputs(metaitem('dustIronIiChloride') * 3)
.fluidOutputs(fluid('hydrogen_sulfide') * 1000)
.duration(30)
.EUt(7)
.buildAndRegister()

ROASTER.recipeBuilder()
.inputs(ore('dustAnyPuritySulfur'))
.inputs(ore('dustAnyPurityIron'))
.outputs(metaitem('dustIronIiSulfide') * 2)
.duration(160)
.EUt(7)
.buildAndRegister()

// Antimony Trioxide roaster
ROASTER.recipeBuilder()
.fluidInputs(fluid('oxygen') * 3000)
.inputs(ore('dustAnyPurityAntimony'))
.outputs(metaitem('dustAntimonyTrioxide'))
.duration(60)
.EUt(7)
.buildAndRegister()

// Sodium bisulfate and related

BR.recipeBuilder()
        .inputs(ore('dustSodiumSulfate') * 7)
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .outputs(metaitem('dustSodiumBisulfate') * 14)
        .duration(120)
        .EUt(30)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustSodiumBisulfate') * 7)
        .fluidInputs(fluid('water') * 1000)
        .fluidOutputs(fluid('sodium_bisulfate_solution') * 1000)
        .duration(120)
        .EUt(30)
        .buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('salt_water') * 50)
.fluidInputs(fluid('sulfuric_acid') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.fluidOutputs(fluid('sodium_bisulfate_solution') * 50)
.duration(1)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('potassium_chloride_solution') * 50)
.fluidInputs(fluid('sulfuric_acid') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.fluidOutputs(fluid('potassium_bisulfate_solution') * 50)
.duration(1)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('sodium_bisulfate_solution') * 1000)
.outputs(metaitem('dustSodiumBisulfate') * 7)
.fluidOutputs(fluid('water') * 1000)
.duration(60)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('potassium_bisulfate_solution') * 1000)
.outputs(metaitem('dustPotassiumBisulfate') * 7)
.fluidOutputs(fluid('water') * 1000)
.duration(60)
.EUt(30)
.buildAndRegister()

ROASTER.recipeBuilder()
.inputs(ore('dustSodiumBisulfate') * 14)
.outputs(metaitem('dustSodiumSulfate') * 7)
.fluidOutputs(fluid('dense_steam') * 1000)
.fluidOutputs(fluid('sulfur_trioxide') * 1000)
.duration(60)
.EUt(30)
.buildAndRegister()

ROASTER.recipeBuilder()
.circuitMeta(1)
.inputs(ore('dustPotassiumBisulfate') * 14)
.outputs(metaitem('dustPotassiumSulfate') * 7)
.fluidOutputs(fluid('dense_steam') * 1000)
.fluidOutputs(fluid('sulfur_trioxide') * 1000)
.duration(60)
.EUt(30)
.buildAndRegister()

ROASTER.recipeBuilder()
.circuitMeta(2)
.inputs(ore('dustPotassiumBisulfate') * 14)
.outputs(metaitem('dustPotassiumPyrosulfate') * 11)
.fluidOutputs(fluid('dense_steam') * 1000)
.duration(60)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('sulfuric_acid') * 1000)
.inputs(ore('dustSaltpeter') * 5)
.fluidOutputs(fluid('nitric_acid') * 1000)
.outputs(metaitem('dustPotassiumBisulfate') * 7)
.duration(60)
.EUt(30)
.buildAndRegister()

// Sodium Sulfide

ROASTER.recipeBuilder()
.inputs(ore('dustSodiumSulfate') * 7)
.inputs(ore('dustAnyPurityCarbon') * 2)
.fluidOutputs(fluid('carbon_dioxide') * 2000)
.outputs(metaitem('dustSodiumSulfide') * 3)
.duration(60)
.EUt(30)
.buildAndRegister()

// Silicon Dioxide

CENTRIFUGE.recipeBuilder()
        .inputs(ore('dustQuartzite'))
        .outputs(metaitem('dustSiliconDioxide'))
        .duration(60)
        .EUt(7)
        .buildAndRegister()

CENTRIFUGE.recipeBuilder()
        .inputs(ore('dustNetherQuartz'))
        .outputs(metaitem('dustSiliconDioxide'))
        .duration(60)
        .EUt(7)
        .buildAndRegister()

// Antimony trifluoride

BR.recipeBuilder()
.fluidInputs(fluid('hydrofluoric_acid') * 6000)
.inputs(ore('dustAntimonyTrioxide') * 5)
.outputs(metaitem('dustWetAntimonyTrifluoride') * 8)
.duration(60)
.EUt(30)
.buildAndRegister()

DRYER.recipeBuilder()
.inputs(ore('dustWetAntimonyTrifluoride') * 4)
.fluidOutputs(fluid('water') * 4500)
.outputs(metaitem('dustAntimonyTrifluoride') * 4)
.duration(200)
.EUt(30)
.buildAndRegister()

// Chlorofluoromethanes

ROASTER.recipeBuilder()
        .fluidInputs(fluid('chlorine') * 3000)
        .inputs(ore('dustAnyPurityAntimony'))
        .outputs(metaitem('dustAntimonyTrichloride') * 4)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('antimony_trichloride') * 72)
        .fluidInputs(fluid('chlorine') * 250)
        .fluidOutputs(fluid('antimony_pentachloride') * 125)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('carbon_tetrachloride') * 150)
        .fluidInputs(fluid('hydrogen_fluoride') * 300)
        .fluidInputs(fluid('antimony_pentachloride') * 50)
        .fluidOutputs(fluid('chlorofluoromethane_mix') * 500)
        .duration(5)
        .EUt(30)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('chlorofluoromethane_mix') * 5000)
        .fluidOutputs(fluid('antimony_pentachloride') * 500)
        .fluidOutputs(fluid('trichlorofluoromethane') * 500)
        .fluidOutputs(fluid('dichlorodifluoromethane') * 500)
        .fluidOutputs(fluid('chlorotrifluoromethane') * 500)
        .fluidOutputs(fluid('hydrogen_chloride') * 3000)
        .duration(160)
        .EUt(30)
        .buildAndRegister()

// Synthetic methane

REACTION_FURNACE.recipeBuilder()
        .notConsumable(ore('catalystBedNickel'))
        .fluidInputs(fluid('carbon_dioxide') * 1000)
        .fluidInputs(fluid('hydrogen') * 8000)
        .fluidOutputs(fluid('methane') * 1000)
        .fluidOutputs(fluid('dense_steam') * 2000)
        .duration(200)
        .EUt(120)
        .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
        .notConsumable(ore('catalystBedNickel'))
        .fluidInputs(fluid('carbon_monoxide') * 1000)
        .fluidInputs(fluid('hydrogen') * 6000)
        .fluidOutputs(fluid('methane') * 1000)
        .fluidOutputs(fluid('dense_steam') * 1000)
        .duration(150)
        .EUt(120)
        .buildAndRegister()


// Chloroform

CSTR.recipeBuilder()
.fluidInputs(fluid('methane') * 50)
.fluidInputs(fluid('chlorine') * 250)
.fluidOutputs(fluid('chlorinated_methane_mixture') * 200)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('chlorinated_methane_mixture') * 4000)
.fluidOutputs(fluid('carbon_tetrachloride') * 250)
.fluidOutputs(fluid('chloroform') * 250)
.fluidOutputs(fluid('dichloromethane') * 250)
.fluidOutputs(fluid('chloromethane') * 250)
.fluidOutputs(fluid('hydrogen_chloride') * 2500)
.duration(160)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('chloromethane') * 45)
.fluidInputs(fluid('chlorine') * 180)
.fluidOutputs(fluid('chlorinated_chloromethane_mixture') * 150)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('chlorinated_chloromethane_mixture') * 5000)
.fluidOutputs(fluid('carbon_tetrachloride') * 500)
.fluidOutputs(fluid('chloroform') * 500)
.fluidOutputs(fluid('dichloromethane') * 500)
.fluidOutputs(fluid('hydrogen_chloride') * 3000)
.duration(160)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('dichloromethane') * 50)
.fluidInputs(fluid('chlorine') * 150)
.fluidOutputs(fluid('chlorinated_dichloromethane_mixture') * 150)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('chlorinated_dichloromethane_mixture') * 3000)
.fluidOutputs(fluid('carbon_tetrachloride') * 500)
.fluidOutputs(fluid('chloroform') * 500)
.fluidOutputs(fluid('hydrogen_chloride') * 1500)
.duration(160)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('chloroform') * 50)
.fluidInputs(fluid('chlorine') * 50)
.fluidOutputs(fluid('carbon_tetrachloride') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.duration(5)
.EUt(30)
.buildAndRegister()

// Chloromethane alternative production

CSTR.recipeBuilder()
.fluidInputs(fluid('methanol') * 50)
.fluidInputs(fluid('hydrochloric_acid') * 50)
.fluidOutputs(fluid('chloromethane_solution') * 150)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('chloromethane_solution') * 3000)
.fluidOutputs(fluid('water') * 2000)
.fluidOutputs(fluid('chloromethane') * 1000)
.duration(160)
.EUt(30)
.buildAndRegister()

// Calcium Chloride
mods.gregtech.electric_blast_furnace.removeByInput(120, [metaitem('dustCalcite') * 5, metaitem('dustSalt') * 4], null)

MIXER.recipeBuilder()
    .fluidInputs(fluid('water') * 1000)
    .inputs(ore('dustCalciumChloride') * 3)
    .fluidOutputs(fluid('calcium_chloride_solution') * 1000)
    .duration(80)
    .EUt(16)
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('hydrochloric_acid') * 2000)
    .inputs(ore('dustCalciumSulfide') * 2)
    .fluidOutputs(fluid('calcium_chloride_solution') * 1000)
    .fluidOutputs(fluid('hydrogen_sulfide') * 1000)
    .duration(80)
    .EUt(30)
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('calcium_chloride_solution') * 1000)
    .fluidInputs(fluid('diluted_sulfuric_acid') * 2000)
    .fluidOutputs(fluid('hydrochloric_acid') * 2000)
    .outputs(metaitem('dustCalciumSulfate') * 6)
    .duration(60)
    .EUt(30)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('calcium_chloride_solution') * 1000)
    .fluidOutputs(fluid('water') * 1000)
    .outputs(metaitem('dustCalciumChloride') * 3)
    .duration(160)
    .EUt(30)
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('diluted_calcium_chloride_solution') * 2000)
    .fluidOutputs(fluid('water') * 2000)
    .outputs(metaitem('dustCalciumChloride') * 3)
    .EUt(30)
    .duration(100)
    .buildAndRegister()

// Soda Ash

// Soda Ash (Sodium Carbonate) Dust * 1
mods.gregtech.centrifuge.removeByInput(30, null, [fluid('gtfo_sodium_carbonate_solution') * 1000])
// Sodium Carbonate Solution * 1000
mods.gregtech.mixer.removeByInput(8, [metaitem('dustSodaAsh')], [fluid('water') * 1000])
mods.gregtech.blender.removeByInput(8, [metaitem('dustSodaAsh')], [fluid('water') * 1000])
// Dutched Chocolate Liquor * 1
mods.gregtech.chemical_bath.removeByInput(540, [metaitem('gregtechfoodoption:chocolate_liquor_refined_crushed')], [fluid('gtfo_sodium_carbonate_solution') * 1000])

CHEMICAL_BATH.recipeBuilder()
.inputs(metaitem('gregtechfoodoption:chocolate_liquor_refined_crushed'))
.notConsumable(fluid('soda_ash_solution') * 1000)
.outputs(metaitem('gregtechfoodoption:chocolate_liquor_dutched_crushed'))
.duration(160)
.EUt(540)
.buildAndRegister()

// Leblanc process

ROASTER.recipeBuilder()
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .inputs(ore('dustSalt') * 4)
        .fluidOutputs(fluid('hydrochloric_acid') * 1000)
        .outputs(metaitem('dustSodiumSulfate') * 7)
        .duration(60)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustSodiumSulfide') * 3)
        .inputs(ore('dustCalcite') * 5)
        .outputs(metaitem('dustBlackAsh') * 8)
        .duration(160)
        .EUt(30)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('water') * 1000)
        .inputs(ore('dustSodaAsh') * 6)
        .fluidOutputs(fluid('soda_ash_solution') * 1000)
        .duration(80)
        .EUt(30)
        .buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('water') * 1000)
.inputs(ore('dustBlackAsh') * 8)
.fluidOutputs(fluid('soda_ash_solution') * 1000)
.outputs(metaitem('dustCalciumSulfide') * 2)
.duration(80)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('soda_ash_solution') * 1000)
.fluidOutputs(fluid('water') * 1000)
.outputs(metaitem('dustSodaAsh') * 6)
.duration(160)
.EUt(30)
.buildAndRegister()

    // Solvay Process

MIXER.recipeBuilder()
.fluidInputs(fluid('salt_water') * 1000)
.fluidInputs(fluid('water') * 1000)
.fluidOutputs(fluid('diluted_saltwater') * 2000)
.duration(80)
.EUt(30)
.buildAndRegister()

BCR.recipeBuilder()
.fluidInputs(fluid('diluted_saltwater') * 100)
.fluidInputs(fluid('carbon_dioxide') * 50)
.fluidInputs(fluid('ammonia') * 50)
.fluidOutputs(fluid('ammoniacal_sodium_bicarbonate_solution') * 50)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('ammoniacal_sodium_bicarbonate_solution') * 1000)
.fluidOutputs(fluid('ammonium_chloride_solution') * 1000)
.outputs(metaitem('dustSodiumBicarbonate') * 6)
.duration(80)
.EUt(30)
.buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustAmmoniumChloride') * 12)
        .inputs(ore('dustQuicklime') * 2)
        .fluidOutputs(fluid('ammonia') * 2000)
        .fluidOutputs(fluid('dense_steam') * 1000)
        .outputs(metaitem('dustCalciumChloride') * 3)
        .duration(120)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
.inputs(ore('dustCalcite') * 5)
.circuitMeta(1)
.fluidOutputs(fluid('carbon_dioxide') * 1000)
.outputs(metaitem('dustQuicklime') * 2)
.duration(80)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustQuicklime') * 2)
        .circuitMeta(1)
        .fluidInputs(fluid('carbon_dioxide') * 1000)
        .outputs(metaitem('dustCalcite') * 5)
        .duration(120)
        .EUt(7)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustLimestone') * 5)
        .circuitMeta(2)
        .fluidOutputs(fluid('carbon_dioxide') * 1000)
        .outputs(metaitem('dustQuicklime') * 2)
        .duration(80)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('ammonium_chloride_solution') * 2000)
.inputs(ore('dustQuicklime') * 2)
.fluidOutputs(fluid('ammonia') * 2000)
.fluidOutputs(fluid('calcium_chloride_solution') * 2000)
.duration(80)
.EUt(30)
.buildAndRegister()

ROASTER.recipeBuilder()
.inputs(ore('dustSodiumBicarbonate') * 12)
.fluidOutputs(fluid('carbon_dioxide') * 1000)
.fluidOutputs(fluid('dense_steam') * 1000)
.outputs(metaitem('dustSodaAsh') * 6)
.duration(80)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustSodiumBicarbonate') * 6)
        .fluidInputs(fluid('hydrochloric_acid') * 1000)
        .fluidOutputs(fluid('carbon_dioxide') * 1000)
        .fluidOutputs(fluid('diluted_saltwater') * 2000)
        .duration(80)
        .EUt(30)
        .buildAndRegister()

// Ethanol

FBR.recipeBuilder()
.fluidInputs(fluid('gtfo_acetaldehyde') * 100)
.fluidInputs(fluid('hydrogen') * 100)
.notConsumable(ore('catalystBedPlatinum'))
.fluidOutputs(fluid('ethanol') * 100)
.duration(5)
.EUt(30)
.buildAndRegister()

// Nitrous Oxide

ROASTER.recipeBuilder()
.inputs(ore('dustAmmoniumNitrate') * 9)
.fluidOutputs(fluid('dense_steam') * 2000)
.fluidOutputs(fluid('nitrous_oxide') * 1000)
.duration(120)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('ammonia') * 100)
.fluidInputs(fluid('oxygen') * 250)
.fluidOutputs(fluid('dense_steam') * 150)
.fluidOutputs(fluid('nitrous_oxide') * 100)
.duration(5)
.EUt(30)
.buildAndRegister()

// Ethylene

CSTR.recipeBuilder()
        .fluidInputs(fluid('hot_sulfuric_acid') * 90)
        .fluidInputs(fluid('ethanol_water_azeotrope') * 100)
        .fluidOutputs(fluid('ethylene') * 90)
        .fluidOutputs(fluid('diluted_sulfuric_acid') * 180)
        .duration(5)
        .EUt(30)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('hot_sulfuric_acid') * 100)
        .fluidInputs(fluid('ethanol') * 100)
        .fluidOutputs(fluid('ethylene') * 100)
        .fluidOutputs(fluid('diluted_sulfuric_acid') * 200)
        .duration(5)
        .EUt(30)
        .buildAndRegister()

dyesLowercase = ["black", "red", "green", "brown", "blue", "purple", "cyan", "light_gray", "gray", "pink", "lime", "yellow", "light_blue", "magenta", "orange", "white"]
dyesUppercase = ["Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"]

for (int i = 0; i < 16; i++) {
    MIXER.recipeBuilder()
    .inputs(ore('dye' + dyesUppercase[i]) * 1)
    .inputs(ore('dustSalt') * 2)
    .fluidInputs(fluid('sulfuric_acid') * 250)
    .fluidOutputs(fluid('dye_' + dyesLowercase[i]) * 288)
    .duration(160)
    .EUt(24)
    .buildAndRegister()
}

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('hydrochloric_acid') * 500)
        .fluidOutputs(fluid('water') * 500)
        .fluidOutputs(fluid('hydrogen_chloride') * 500)
        .duration(50)
        .EUt(30)
        .buildAndRegister()

// Tetrafluoroethylene

BCR.recipeBuilder()
.fluidInputs(fluid('chloroform') * 50)
.fluidInputs(fluid('hydrogen_fluoride') * 100)
.fluidOutputs(fluid('acidic_chlorodifluoromethane') * 150)
.duration(5)
.EUt(30)
.buildAndRegister()

CENTRIFUGE.recipeBuilder()
        .fluidInputs(fluid('acidic_chlorodifluoromethane') * 3000)
        .fluidInputs(fluid('water') * 2000)
        .fluidOutputs(fluid('chlorodifluoromethane') * 1000)
        .fluidOutputs(fluid('hydrochloric_acid') * 2000)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

PYROLYSE.recipeBuilder()
.fluidInputs(fluid('acidic_chlorodifluoromethane') * 6000)
.fluidOutputs(fluid('acidic_tetrafluoroethylene') * 5000)
.duration(200)
.EUt(120)
.buildAndRegister()

CENTRIFUGE.recipeBuilder()
.fluidInputs(fluid('acidic_tetrafluoroethylene') * 5000)
.fluidInputs(fluid('water') * 4000)
.fluidOutputs(fluid('tetrafluoroethylene') * 1000)
.fluidOutputs(fluid('hydrochloric_acid') * 4000)
.duration(200)
.EUt(30)
.buildAndRegister()

// Tetranitromethane

CSTR.recipeBuilder()
.fluidInputs(fluid('nitric_acid') * 150)
.fluidInputs(fluid('acetylene') * 50)
.fluidOutputs(fluid('trinitromethane_solution') * 150)
.fluidOutputs(fluid('carbon_monoxide') * 50)
.duration(5)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('trinitromethane_solution') * 150)
.fluidInputs(fluid('nitration_mixture') * 100)
.fluidOutputs(fluid('tetranitromethane_solution') * 250)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('tetranitromethane_solution') * 5000)
.fluidOutputs(fluid('sulfuric_acid') * 1000)
.fluidOutputs(fluid('tetranitromethane') * 1000)
.fluidOutputs(fluid('water') * 3000)
.duration(160)
.EUt(30)
.buildAndRegister()

// Ammonia

MIXER.recipeBuilder()
.fluidInputs(fluid('water') * 1000)
.inputs(ore('dustAmmoniumChloride') * 6)
.fluidOutputs(fluid('ammonium_chloride_solution') * 1000)
.EUt(30)
.duration(160)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('ammonium_chloride_solution') * 50)
.fluidInputs(fluid('sodium_hydroxide_solution') * 50)
.fluidOutputs(fluid('ammonia') * 50)
.fluidOutputs(fluid('salt_water') * 50)
.duration(1)
.EUt(7)
.buildAndRegister()

// Dinitrogen Tetroxide

VACUUM_FREEZER.recipeBuilder()
.fluidInputs(fluid('nitrogen_dioxide') * 2000)
.fluidOutputs(fluid('dinitrogen_tetroxide') * 1000)
.duration(200)
.EUt(120)
.buildAndRegister()

// 1,1-dimethylhydrazine

CSTR.recipeBuilder()
.fluidInputs(fluid('monochloramine') * 50)
.fluidInputs(fluid('dimethylamine') * 50)
.fluidOutputs(fluid('dimethylhydrazine') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.duration(10)
.EUt(30)
.buildAndRegister()

// Monomethylhydrazine

CSTR.recipeBuilder()
.fluidInputs(fluid('monochloramine') * 50)
.fluidInputs(fluid('methylamine') * 50)
.fluidOutputs(fluid('monomethylhydrazine') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.duration(10)
.EUt(30)
.buildAndRegister()

// Vinyl acetate

FBR.recipeBuilder()
.fluidInputs(fluid('acetic_acid') * 50)
.fluidInputs(fluid('ethylene') * 50)
.notConsumable(ore('catalystBedPalladium'))
.fluidOutputs(fluid('vinyl_acetate') * 50)
.duration(10)
.EUt(30)
.buildAndRegister()

// Hypochlorous Acid

BCR.recipeBuilder()
.fluidInputs(fluid('water') * 50)
.fluidInputs(fluid('chlorine') * 100)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.fluidOutputs(fluid('hypochlorous_acid') * 50)
.duration(6)
.EUt(30)
.buildAndRegister()

// PVB

BR.recipeBuilder()
.fluidInputs(fluid('polyvinyl_acetate') * 144)
.fluidInputs(fluid('ethanol') * 1000)
.outputs(metaitem('dustPolyvinylAlcohol'))
.fluidOutputs(fluid('ethyl_acetate') * 1000)
.duration(400)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('ethyl_acetate') * 50)
.notConsumable(fluid('sulfuric_acid') * 50)
.fluidOutputs(fluid('ethanol') * 50)
.fluidOutputs(fluid('acetic_acid') * 50)
.duration(20)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.inputs(ore('dustPolyvinylAlcohol'))
.fluidInputs(fluid('butyraldehyde') * 1000)
.outputs(metaitem('dustPolyvinylButyral'))
.duration(400)
.EUt(480)
.buildAndRegister()

// Cyclohexane

TBR.recipeBuilder()
    .fluidInputs(fluid('hydrogen') * 300)
    .fluidInputs(fluid('benzene') * 50)
    .notConsumable(ore('dustActivatedRaneyNickel') * 1)
    .fluidOutputs(fluid('cyclohexane') * 50)
    .duration(20)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// Iron(III)-chloride

ROASTER.recipeBuilder()
        .fluidInputs(fluid('chlorine') * 1000)
        .inputs(ore('dustIronIiChloride') * 3)
        .outputs(metaitem('dustIronIiiChloride') * 4)
        .duration(160)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
.fluidInputs(fluid('chlorine') * 6000)
.inputs(ore('dustAnyPurityIron') * 2)
.outputs(metaitem('dustIronIiiChloride') * 8)
.duration(160)
.EUt(30)
.buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('water') * 1000)
.inputs(ore('dustIronIiiChloride') * 4)
.fluidOutputs(fluid('iron_iii_chloride_solution') * 1000)
.duration(160)
.EUt(30)
.buildAndRegister()

// Fluoroantimonic Acid

LCR.recipeBuilder()
.circuitMeta(1)
.fluidInputs(fluid('hydrofluoric_acid') * 4000)
.inputs(ore('dustAntimonyTrifluoride') * 4)
.fluidOutputs(fluid('fluoroantimonic_acid') * 1000)
.fluidOutputs(fluid('hydrogen') * 2000)
.duration(3000)
.EUt(480)
.buildAndRegister()

// Sodium Potassium

MIXER.recipeBuilder()
.inputs(ore('dustAnyPuritySodium'))
.inputs(ore('dustAnyPurityPotassium'))
.fluidOutputs(fluid('sodium_potassium') * 1000)
.duration(300)
.EUt(30)
.buildAndRegister()

// Polyphenylene Sulfide

POLYMERIZATION.recipeBuilder()
.fluidInputs(fluid('n_methyl_two_pyrrolidone') * 1000)
.inputs(ore('dustDichlorobenzene') * 12)
.inputs(ore('dustSodiumSulfide') * 3)
.fluidOutputs(fluid('salty_n_methyl_two_pyrrolidone') * 1000)
.outputs(metaitem('dustPolyphenyleneSulfide') * 11)
.duration(600)
.EUt(240)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('salty_n_methyl_two_pyrrolidone') * 1000)
.fluidOutputs(fluid('n_methyl_two_pyrrolidone') * 1000)
.outputs(metaitem('dustSalt') * 4)
.duration(400)
.EUt(120)
.buildAndRegister()

// Nitric Acid, Nitrogen Dioxide

CSTR.recipeBuilder()
.fluidInputs(fluid('oxygen') * 50)
.fluidInputs(fluid('nitric_oxide') * 50)
.fluidOutputs(fluid('nitrogen_dioxide') * 50)
.duration(8)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('water') * 50)
.fluidInputs(fluid('nitrogen_dioxide') * 150)
.fluidOutputs(fluid('nitric_acid') * 100)
.fluidOutputs(fluid('nitric_oxide') * 50)
.duration(12)
.EUt(30)
.buildAndRegister()

// Methyl Acetate

CSTR.recipeBuilder()
.fluidInputs(fluid('acetic_acid') * 50)
.fluidInputs(fluid('methanol') * 50)
.fluidInputs(fluid('sulfuric_acid') * 50)
.fluidOutputs(fluid('methyl_acetate_solution') * 150)
.duration(12)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('methyl_acetate_solution') * 3000)
.fluidOutputs(fluid('sulfuric_acid') * 1000)
.fluidOutputs(fluid('water') * 1000)
.fluidOutputs(fluid('methyl_acetate') * 1000)
.duration(120)
.EUt(30)
.buildAndRegister()

// Chlorobenzene

BCR.recipeBuilder()
.fluidInputs(fluid('benzene') * 50)
.fluidInputs(fluid('chlorine') * 100)
.notConsumable(ore('dustIronIiiChloride'))
.fluidOutputs(fluid('chlorobenzene') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.duration(12)
.EUt(30)
.buildAndRegister()

// Chloronitrobenzenes

CSTR.recipeBuilder()
.notConsumable(ore('springNichrome'))
.fluidInputs(fluid('chlorobenzene') * 50)
.fluidInputs(fluid('nitration_mixture') * 100)
.fluidOutputs(fluid('acidic_chloronitrobenzene_mixture') * 100)
.duration(10)
.EUt(480)
.buildAndRegister()

PHASE_SEPARATOR.recipeBuilder()
.fluidInputs(fluid('acidic_chloronitrobenzene_mixture') * 2000)
.outputs(metaitem('dustMixedChloronitrobenzene'))
.fluidOutputs(fluid('diluted_sulfuric_acid') * 2000)
.duration(50)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('mixed_chloronitrobenzene') * 144)
.chancedOutput(metaitem('dustFourChloronitrobenzene'), 6500, 0)
.fluidOutputs(fluid('two_chloronitrobenzene') * 48)
.duration(200)
.EUt(30)
.buildAndRegister()

//Phosgene

TBR.recipeBuilder()
.fluidInputs(fluid('carbon_monoxide') * 50)
.fluidInputs(fluid('chlorine') * 100)
.notConsumable(ore('dustAnyPurityCarbon'))
.fluidOutputs(fluid('phosgene') * 50)
.duration(10)
.EUt(30)
.buildAndRegister()

REACTION_FURNACE.recipeBuilder()
.fluidInputs(fluid('carbon_tetrachloride') * 1000)
.fluidInputs(fluid('oxygen') * 1000)
.fluidOutputs(fluid('phosgene') * 1000)
.fluidOutputs(fluid('chlorine') * 2000)
.duration(30)
.EUt(120)
.buildAndRegister()

// Rutile

REACTION_FURNACE.recipeBuilder()
        .fluidInputs(fluid('titanium_tetrachloride') * 1000)
        .fluidInputs(fluid('oxygen') * 2000)
        .fluidOutputs(fluid('chlorine') * 4000)
        .outputs(metaitem('dustTitaniumDioxide') * 3)
        .duration(200)
        .EUt(480)
        .buildAndRegister()

oreDict.add('dyeWhite', metaitem('dustTitaniumDioxide'))

// Butyraldehyde

REACTION_FURNACE.recipeBuilder()
.inputs(ore('dustDicobaltOctacarbonyl') * 18)
.fluidInputs(fluid('propene') * 1000)
.fluidInputs(fluid('carbon_monoxide') * 1000)
.fluidInputs(fluid('hot_hp_hydrogen') * 2000)
.fluidOutputs(fluid('butyraldehyde_mixture') * 1000)
.duration(100)
.EUt(240)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('butyraldehyde_mixture') * 1000)
.outputs(metaitem('dustDicobaltOctacarbonyl') * 18)
.fluidOutputs(fluid('butyraldehyde') * 800)
.fluidOutputs(fluid('isobutyraldehyde') * 200)
.duration(100)
.EUt(30)
.buildAndRegister()

// Isobutyl alcohol

BR.recipeBuilder()
.fluidInputs(fluid('isobutyraldehyde') * 1000)
.fluidInputs(fluid('hydrogen') * 2000)
.notConsumable(metaitem('susy:hv_catalyst_bed_reduction'))
.fluidOutputs(fluid('isobutyl_alcohol') * 1000)
.EUt(Globals.voltAmps[3])
.duration(80)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('isobutyraldehyde') * 1000)
.fluidInputs(fluid('hydrogen') * 2000)
.notConsumable(ore('catalystBedPlatinum'))
.fluidOutputs(fluid('isobutyl_alcohol') * 1000)
.EUt(Globals.voltAmps[3])
.duration(80)
.buildAndRegister()

// Salt from Sodium and Chlorine

ROASTER.recipeBuilder()
.fluidInputs(fluid('chlorine') * 1000)
.inputs(ore('dustAnyPuritySodium'))
.outputs(metaitem('dustSalt') * 2)
.duration(200)
.EUt(7)
.buildAndRegister()

// Rock Salt from Sodium and Chlorine

ROASTER.recipeBuilder()
.fluidInputs(fluid('chlorine') * 1000)
.inputs(ore('dustAnyPurityPotassium'))
.outputs(metaitem('dustRockSalt') * 2)
.duration(200)
.EUt(7)
.buildAndRegister()

// TNT

BR.recipeBuilder()
.fluidInputs(fluid('toluene') * 1000)
.fluidInputs(fluid('nitration_mixture') * 6000)
.fluidOutputs(fluid('tnt_slurry') * 3000)
.duration(200)
.EUt(24)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('tnt_slurry') * 1000)
.fluidOutputs(fluid('diluted_sulfuric_acid') * 1000)
.outputs(metaitem('dustTnt') * 7)
.duration(300)
.EUt(30)
.buildAndRegister()

// Sulfur Trioxide

ROASTER.recipeBuilder()
.fluidInputs(fluid('oxygen') * 1000)
.fluidInputs(fluid('sulfur_dioxide') * 1000)
.notConsumable(ore('dustVanadiumPentoxide'))
.fluidOutputs(fluid('sulfur_trioxide') * 1000)

.duration(200)
.EUt(7)
.buildAndRegister()

// Saltpeter and Sodium Hydroxide Solution

MIXER.recipeBuilder()
        .circuitMeta(1)
        .fluidInputs(fluid('water') * 1000)
        .inputs(ore('dustSodiumHydroxide') * 3)
        .fluidOutputs(fluid('sodium_hydroxide_solution') * 1000)
        .duration(80)
        .EUt(7)
        .buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('water') * 1000)
.inputs(ore('dustAmmoniumNitrate') * 9)
.fluidOutputs(fluid('ammonium_nitrate_solution') * 1000)
.duration(80)
.EUt(7)
.buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('water') * 1000)
.inputs(ore('dustPotassiumHydroxide') * 3)
.fluidOutputs(fluid('potassium_hydroxide_solution') * 1000)
.duration(80)
.EUt(7)
.buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('water') * 1000)
.inputs(ore('dustRockSalt') * 2)
.fluidOutputs(fluid('potassium_chloride_solution') * 1000)
.duration(80)
.EUt(7)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('ammonium_nitrate_solution') * 50)
.fluidInputs(fluid('potassium_hydroxide_solution') * 50)
.fluidOutputs(fluid('ammonia') * 50)
.fluidOutputs(fluid('diluted_saltpeter_solution') * 150)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('diluted_saltpeter_solution') * 3000)
.fluidOutputs(fluid('water') * 3000)
.outputs(metaitem('dustSaltpeter') * 5)
.duration(300)
.EUt(24)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('ammonium_nitrate_solution') * 50)
.fluidInputs(fluid('potassium_chloride_solution') * 50)
.fluidOutputs(fluid('nitrate_solution') * 100)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('nitrate_solution') * 2000)
.fluidOutputs(fluid('water') * 1000)
.outputs(metaitem('dustNitrateSaltMix') * 11)
.duration(300)
.EUt(30)
.buildAndRegister()

CENTRIFUGE.recipeBuilder()
.inputs(ore('dustNitrateSaltMix') * 11)
.outputs(metaitem('dustAmmoniumChloride') * 6)
.outputs(metaitem('dustSaltpeter') * 5)
.duration(200)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('nitric_acid') * 50)
.fluidInputs(fluid('potassium_hydroxide_solution') * 50)
.fluidOutputs(fluid('saltpeter_solution') * 100)
.duration(200)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('saltpeter_solution') * 2000)
.fluidOutputs(fluid('water') * 1000)
.outputs(metaitem('dustSaltpeter') * 5)
.duration(300)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('nitric_acid') *  1000)
.inputs(ore('dustSodiumHydroxide') * 3)
.fluidOutputs(fluid('sodium_nitrate_solution') * 1000)
.duration(160)
.EUt(30)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('sodium_nitrate_solution') * 50)
.fluidInputs(fluid('potassium_chloride_solution') * 50)
.fluidOutputs(fluid('salty_saltpeter_solution') * 100)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('salty_saltpeter_solution') * 2000)
.fluidOutputs(fluid('salt_water') * 1000)
.outputs(metaitem('dustSaltpeter') * 5)
.duration(300)
.EUt(30)
.buildAndRegister()

//Glyceryl Trinitrate

BR.recipeBuilder()
        .fluidInputs(fluid('glycerol') * 1000)
        .fluidInputs(fluid('nitration_mixture') * 6000)
        .fluidOutputs(fluid('glyceryl_trinitrate') * 1000)
        .fluidOutputs(fluid('diluted_sulfuric_acid') * 6000)
        .duration(100)
        .EUt(30)
        .buildAndRegister()

// Allyl Chloride

CSTR.recipeBuilder()
        .fluidInputs(fluid('chlorine') * 100)
        .fluidInputs(fluid('hot_hp_propene') * 50)
        .fluidOutputs(fluid('hydrogen_chloride') * 50)
        .fluidOutputs(fluid('allyl_chloride') * 50)
        .duration(8)
        .EUt(30)
        .buildAndRegister()

// Monochloramine

CSTR.recipeBuilder()
.fluidInputs(fluid('sodium_hydroxide_solution') * 100)
.fluidInputs(fluid('chlorine') * 100)
.fluidOutputs(fluid('impure_bleach') * 200)
.duration(10)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('impure_bleach') * 4000)
.fluidOutputs(fluid('water') * 2000)
.fluidOutputs(fluid('bleach') * 1000)
.outputs(metaitem('dustSalt') * 2)
.duration(300)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('bleach') * 1000)
.fluidInputs(fluid('ammonia') * 1000)
.fluidOutputs(fluid('monochloramine') * 1000)
.fluidOutputs(fluid('sodium_hydroxide_solution') * 1000)
.duration(200)
.EUt(30)
.buildAndRegister()

// Dichlorobenzene

FBR.recipeBuilder()
.fluidInputs(fluid('toluene') * 50)
.fluidInputs(fluid('chlorobenzene') * 50)
.fluidInputs(fluid('chlorine') * 100)
.notConsumable(ore('catalystBedIronIiiChloride') * 1)
.fluidOutputs(fluid('mixed_dichlorobenzene_solution') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('mixed_dichlorobenzene_solution') * 1000)
.fluidOutputs(fluid('one_two_dichlorobenzene_solution') * 400)
.fluidOutputs(fluid('one_four_dichlorobenzene_solution') * 600)
.duration(300)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('one_four_dichlorobenzene_solution') * 1000)
.fluidOutputs(fluid('toluene') * 1000)
.outputs(metaitem('dustDichlorobenzene') * 12)
.duration(300)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('one_two_dichlorobenzene_solution') * 1000)
.fluidOutputs(fluid('toluene') * 1000)
.outputs(metaitem('dustOneTwoDichlorobenzene') * 12)
.duration(300)
.EUt(30)
.buildAndRegister()

//acetylene

for (carbon in sources) {
    ADVANCED_ARC_FURNACE.recipeBuilder()
            .inputs(ore('dustQuicklime') * 2)
            .inputs(ore(carbon.name) * carbon.equivalent(3))
            .outputs(metaitem('dustCalciumCarbide') * 3)
            .fluidOutputs(fluid('carbon_monoxide') * 1000)
            .EUt(120)
            .duration(400)
            .buildAndRegister()
}


BR.recipeBuilder()
.inputs(ore('dustCalciumCarbide') * 3)
.fluidInputs(fluid('water') * 2000)
.outputs(metaitem('dustCalciumHydroxide') * 5)
.fluidOutputs(fluid('acetylene') * 1000)
.EUt(30)
.duration(120)
.buildAndRegister()

//dealing with calcium hydroxide

ROASTER.recipeBuilder()
        .circuitMeta(1)
        .inputs(ore('dustCalciumHydroxide') * 5)
        .fluidInputs(fluid('carbon_dioxide') * 1000)
        .outputs(metaitem('dustCalcite') * 5)
        .fluidOutputs(fluid('dense_steam') * 1000)
        .EUt(30)
        .duration(120)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .circuitMeta(2)
        .inputs(ore('dustCalciumHydroxide') * 5)
        .outputs(metaitem('dustQuicklime') * 2)
        .fluidOutputs(fluid('dense_steam') * 1000)
        .EUt(30)
        .duration(120)
        .buildAndRegister()

//ammonium nitrate

BCR.recipeBuilder()
.fluidInputs(fluid('nitric_acid') * 50)
.fluidInputs(fluid('ammonia') * 50)
.fluidOutputs(fluid('ammonium_nitrate_solution') * 50)
.EUt(30)
.duration(10)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('ammonium_nitrate_solution') * 1000)
.outputs(metaitem('dustAmmoniumNitrate') * 2)
.fluidOutputs(fluid('water') * 1000)
.EUt(90)
.duration(300)
.buildAndRegister()

//tri/methyl/dimethylamine

FLUIDIZEDBR.recipeBuilder()
.fluidInputs(fluid('methanol') * 300)
.fluidInputs(fluid('ammonia') * 150)
.notConsumable(ore('dustImpregnatedAluminaCatalyst') * 1)
.fluidOutputs(fluid('methylamine_mix') * 450)
.duration(8)
.EUt(Globals.voltAmps[2])
.buildAndRegister()


DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('methylamine_mix') * 9000)
.fluidOutputs(fluid('water') * 6000)
.fluidOutputs(fluid('methylamine') * 1000)
.fluidOutputs(fluid('dimethylamine') * 1000)
.fluidOutputs(fluid('trimethylamine') * 1000)
.EUt(90)
.duration(1200)
.buildAndRegister()

//1,4-butanediol

FBR.recipeBuilder()
.fluidInputs(fluid('formaldehyde') * 100)
.fluidInputs(fluid('acetylene') * 50)
.notConsumable(ore('catalystBedBismuthCopper') * 1)
.fluidOutputs(fluid('butynediol') * 50)
.EUt(30)
.duration(10)
.buildAndRegister()

TBR.recipeBuilder()
.fluidInputs(fluid('butynediol') * 50)
.fluidInputs(fluid('hydrogen') * 200)
.notConsumable(ore('dustActivatedRaneyNickel') * 1)
.fluidOutputs(fluid('butanediol') * 50)
.EUt(30)
.duration(10)
.buildAndRegister()

// Formaldehyde

FBR.recipeBuilder()
.fluidInputs(fluid('methanol') * 100)
.fluidInputs(fluid('oxygen') * 100)
.notConsumable(ore('catalystBedSilver') * 1)
.fluidOutputs(fluid('formaldehyde') * 100)
.fluidOutputs(fluid('water') * 100)
.duration(10)
.EUt(Globals.voltAmps[1])
.buildAndRegister()

//gamma-Butyrolactone


FBR.recipeBuilder()
.fluidInputs(fluid('butanediol') * 50)
.notConsumable(ore('catalystBedChromiumTrioxide') * 1)
.fluidOutputs(fluid('gamma_butyrolactone') * 50)
.fluidOutputs(fluid('hydrogen') * 200)
.duration(20)
.EUt(Globals.voltAmps[1])
.buildAndRegister()

//N-methyl-2-pyrrolidone

CSTR.recipeBuilder()
.fluidInputs(fluid('gamma_butyrolactone') * 50)
.fluidInputs(fluid('methylamine') * 50)
.fluidOutputs(fluid('diluted_n_methyl_two_pyrrolidone') * 100)
.EUt(30)
.duration(10)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('diluted_n_methyl_two_pyrrolidone') * 2000)
.fluidOutputs(fluid('n_methyl_two_pyrrolidone') * 1000)
.fluidOutputs(fluid('water') * 1000)
.EUt(90)
.duration(450)
.buildAndRegister()

//1-bromobutane

CSTR.recipeBuilder()
.fluidInputs(fluid('hydrobromic_acid') * 50)
.fluidInputs(fluid('n_butanol') * 50)
.fluidOutputs(fluid('one_bromobutane') * 50)
.fluidOutputs(fluid('water') * 50)
.EUt(30)
.duration(10)
.buildAndRegister()

//n-butyllithium

MIXER.recipeBuilder()
.inputs(ore('dustAnyPurityLithium') * 2)
.fluidInputs(fluid('diethyl_ether') * 1000)
.fluidOutputs(fluid('lithium_solution') * 1000)
.EUt(30)
.duration(320)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('lithium_solution') * 1000)
.fluidInputs(fluid('one_bromobutane') * 1000)
.fluidOutputs(fluid('diluted_butyllithium') * 2000)
.outputs(metaitem('dustLithiumBromide') * 2)
.EUt(30)
.duration(300)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('diluted_butyllithium') * 2000)
.fluidOutputs(fluid('butyllithium') * 1000)
.fluidOutputs(fluid('diethyl_ether') * 1000)
.EUt(90)
.duration(360)
.buildAndRegister()

//Diethyl Ether

CSTR.recipeBuilder()
.fluidInputs(fluid('ethanol') * 100)
.fluidInputs(fluid('sulfuric_acid') * 50)
.fluidOutputs(fluid('diethyl_ether_solution') * 150)
.EUt(30)
.duration(5)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('diethyl_ether_solution') * 3000)
.fluidOutputs(fluid('sulfuric_acid') * 1000)
.fluidOutputs(fluid('water') * 1000)
.fluidOutputs(fluid('diethyl_ether') * 1000)
.EUt(90)
.duration(600)
.buildAndRegister()

// Useful reactions

BR.recipeBuilder()
.inputs(ore('dustPotassiumHydroxide') * 3)
.fluidInputs(fluid('hydrochloric_acid')* 1000)
.fluidOutputs(fluid('diluted_rock_salt_solution') * 2000)
.EUt(30)
.duration(160)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('diluted_rock_salt_solution') * 2000)
.fluidOutputs(fluid('potassium_chloride_solution') * 1000)
.fluidOutputs(fluid('water') * 1000)
.EUt(16)
.duration(60)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('potassium_chloride_solution') * 1000)
.fluidOutputs(fluid('water') * 1000)
.outputs(metaitem('dustRockSalt') * 2)
.EUt(16)
.duration(60)
.buildAndRegister()

CSTR.recipeBuilder()
.fluidInputs(fluid('potassium_hydroxide_solution') * 100)
.fluidInputs(fluid('carbon_dioxide') * 50)
.fluidOutputs(fluid('diluted_potassium_carbonate_solution') * 150)
.EUt(30)
.duration(15)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('diluted_potassium_carbonate_solution') * 3000)
.outputs(metaitem('dustPotassiumCarbonate') * 6)
.fluidOutputs(fluid('water') * 3000)
.EUt(30)
.duration(400)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('ammonium_chloride_solution') * 2000)
.inputs(ore('dustCalciumHydroxide') * 5)
.fluidOutputs(fluid('ammonia') * 2000)
.fluidOutputs(fluid('diluted_calcium_chloride_solution') * 2000)
.EUt(30)
.duration(360)
.buildAndRegister()

MIXER.recipeBuilder()
.inputs(ore('dustPotassiumCarbonate') * 6)
.fluidInputs(fluid('water') * 1000)
.fluidOutputs(fluid('potassium_carbonate_solution') * 1000)
.EUt(30)
.duration(80)
.buildAndRegister()

BR.recipeBuilder()
.inputs(ore('dustCalciumHydroxide') * 5)
.fluidInputs(fluid('potassium_carbonate_solution') * 1000)
.fluidInputs(fluid('water') * 1000)
.outputs(metaitem('dustCalcite') *  5)
.fluidOutputs(fluid('potassium_hydroxide_solution') * 2000)
.EUt(30)
.duration(200)
.buildAndRegister()

BCR.recipeBuilder()
    .fluidInputs(fluid('sodium_hydroxide_solution') * 50)
    .fluidInputs(fluid('hydrogen_chloride') * 50)
    .fluidOutputs(fluid('salt_water') * 100)
    .duration(10)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustQuicklime') * 2)
    .fluidInputs(fluid('hydrogen_chloride') * 2000)
    .fluidOutputs(fluid('calcium_chloride_solution') * 1000)
    .duration(100)
    .EUt(16)
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustCalciumHydroxide') * 5)
    .fluidInputs(fluid('hydrogen_chloride') * 2000)
    .fluidOutputs(fluid('diluted_calcium_chloride_solution') * 2000)
    .duration(100)
    .EUt(16)
    .buildAndRegister()

ROASTER.recipeBuilder()
    .inputs(ore('dustCalcium'))
    .fluidInputs(fluid('oxygen') * 1000)
    .outputs(metaitem('dustQuicklime') * 2)
    .duration(60)
    .EUt(30)
    .buildAndRegister()

//CELLULOSE ACETATE

CSTR.recipeBuilder()
        .fluidInputs(fluid('methyl_acetate') * 50)
        .fluidInputs(fluid('carbon_monoxide') * 50)
        .fluidOutputs(fluid('gtfo_acetic_anhydride') * 50)
        .EUt(480)
        .duration(1)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustCellulose'))
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .fluidInputs(fluid('gtfo_acetic_anhydride') * 1000)
        .fluidOutputs(fluid('acidic_cellulose_solution') * 1000)
        .EUt(480)
        .duration(160)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('acidic_cellulose_solution') * 50)
        .fluidInputs(fluid('acetic_acid') * 50)
        .fluidInputs(fluid('water') * 50)
        .fluidOutputs(fluid('cellulose_acetate_solution') * 100)
        .EUt(480)
        .duration(1)
        .buildAndRegister()

FLUID_HEATER.recipeBuilder()
        .fluidInputs(fluid('air') * 1000)
        .fluidOutputs(fluid('hot_air') * 1000)
        .duration(20)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

DRYER.recipeBuilder()
        .fluidInputs(fluid('cellulose_acetate_solution') * 2000)
        .fluidInputs(fluid('hot_air') * 1000)
        .notConsumable(metaitem('spinneret'))
        .outputs(metaitem('fiberCelluloseAcetate') * 8)
        .fluidOutputs(fluid('air') * 1000)
        .fluidOutputs(fluid('diluted_acetic_acid') * 2000)
        .EUt(480)
        .duration(100)
        .buildAndRegister()

ASSEMBLER.recipeBuilder()
        .inputs(ore('threadCelluloseAcetate') * 16)
        .outputs(metaitem('cellulose_acetate_mesh'))
        .EUt(120)
        .duration(160)
        .buildAndRegister()

// Distilled Water

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('water') * 288)
.circuitMeta(1)
.fluidOutputs(fluid('distilled_water') * 260)
.duration(160)
.EUt(Globals.voltAmps[1])
.buildAndRegister()

// Furfural

BR.recipeBuilder()
.fluidInputs(fluid('sulfuric_acid') * 1000)
.inputs(ore('dustWood') * 4)
.fluidOutputs(fluid('acidic_furfural_solution') * 5000)
.duration(180)
.EUt(Globals.voltAmps[1])
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('acidic_furfural_solution') * 5000)
.fluidOutputs(fluid('sulfuric_acid') * 1000)
.fluidOutputs(fluid('furfural') * 1000)
.fluidOutputs(fluid('water') * 3000)
.duration(240)
.EUt(Globals.voltAmps[1])
.buildAndRegister()

// Graphene

// Ammonia (Haber Process)

REACTION_FURNACE.recipeBuilder()
        .fluidInputs(fluid('hot_hp_air') * 1500)
        .fluidInputs(fluid('hydrogen') * 3000)
        .notConsumable(ore('dustWustiteCatalyst'))
        .fluidOutputs(fluid('ammonia_rich_gas') * 4000)
        .duration(160)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
        .fluidInputs(fluid('hot_hp_nitrogen') * 1000)
        .fluidInputs(fluid('hydrogen') * 3000)
        .notConsumable(ore('dustWustiteCatalyst'))
        .fluidOutputs(fluid('ammonia_rich_gas') * 4000)
        .duration(100)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
        .fluidInputs(fluid('ammonia_reaction_mix') * 4000)
        .notConsumable(ore('dustWustiteCatalyst'))
        .fluidOutputs(fluid('ammonia_rich_gas') * 4000)
        .duration(100)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('ammonia_rich_gas') * 4000)
.fluidInputs(fluid('water') * 500)
.fluidOutputs(fluid('ammonia_solution') * 500)
.fluidOutputs(fluid('ammonia_reaction_mix') * 2000)
.duration(100)
.EUt(Globals.voltAmps[1])
.buildAndRegister()

ROASTER.recipeBuilder()
.fluidInputs(fluid('monoxide_rich_syngas') * 1000)
.inputs(ore('dustIronIiiOxide') * 5)
.outputs(metaitem('dustWustiteCatalyst') * 5)
.duration(400)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

ROASTER.recipeBuilder()
.fluidInputs(fluid('hydrogen_rich_syngas') * 1000)
.inputs(ore('dustIronIiiOxide') * 5)
.outputs(metaitem('dustWustiteCatalyst') * 5)
.duration(400)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('ammonia_solution') * 1000)
.fluidOutputs(fluid('water') * 1000)
.fluidOutputs(fluid('ammonia') * 1000)
.duration(150)
.EUt(30)
.buildAndRegister()

// Butadiene without oil

FBR.recipeBuilder()
.fluidInputs(fluid('gtfo_acetaldehyde') * 50)
.fluidInputs(fluid('ethanol') * 50)
.notConsumable(ore('catalystBedTantalum'))
.fluidOutputs(fluid('butadiene') * 50)
.fluidOutputs(fluid('water') * 100)
.duration(5)
.EUt(Globals.voltAmps[1])
.buildAndRegister()

// Ethanol from ethylene

CHEMICAL_BATH.recipeBuilder()
        .fluidInputs(fluid('phosphoric_acid') * 500)
        .inputs(ore('dustSilicaGel'))
        .outputs(metaitem('dustPhosphoricAcidSilicaGel'))
        .duration(80)
        .EUt(30)
        .buildAndRegister()

FLUIDIZEDBR.recipeBuilder()
.fluidInputs(fluid('ethylene') * 50)
.fluidInputs(fluid('dense_steam') * 50)
.notConsumable(metaitem('dustPhosphoricAcidSilicaGel'))
.fluidOutputs(fluid('ethanol') * 50)
.duration(5)
.EUt(Globals.voltAmps[3])
.buildAndRegister()

// Wacker Process

ROASTER.recipeBuilder()
.fluidInputs(fluid('chlorine') * 2000)
.inputs(ore('dustAnyPurityPalladium'))
.outputs(metaitem('dustPalladiumChloride') * 3)
.duration(280)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

ROASTER.recipeBuilder()
.fluidInputs(fluid('chlorine') * 2000)
.inputs(ore('dustAnyPurityCopper'))
.outputs(metaitem('dustCopperIiChloride') * 3)
.duration(280)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

MIXER.recipeBuilder()
.inputs(ore('dustPalladiumChloride') * 3)
.inputs(ore('dustCopperIiChloride') * 3)
.outputs(metaitem('dustWackerCatalyst'))
.duration(160)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

MIXER.recipeBuilder()
.fluidInputs(fluid('water') * 1000)
.inputs(ore('dustWackerCatalyst') * 6)
.fluidOutputs(fluid('wacker_catalyst_solution') * 1000)
.duration(100)
.EUt(Globals.voltAmps[1])
.buildAndRegister()


CSTR.recipeBuilder()
.fluidInputs(fluid('wacker_catalyst_solution') * 50)
.fluidInputs(fluid('ethylene') * 50)
.fluidInputs(fluid('oxygen') * 50)
.fluidOutputs(fluid('impure_acetaldehyde') * 50)
.duration(5)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('impure_acetaldehyde') * 1000)
.fluidOutputs(fluid('gtfo_acetaldehyde') * 900)
.outputs(metaitem('dustWackerCatalyst') * 6)
.duration(400)
.EUt(Globals.voltAmps[1])
.buildAndRegister()

// Dimethylformamide

CSTR.recipeBuilder()
    .fluidInputs(fluid('carbon_monoxide') * 50)
    .fluidInputs(fluid('dimethylamine') * 50)
    .fluidOutputs(fluid('dimethylformamide') * 50)
    .duration(10)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// Cumene rearranging

CSTR.recipeBuilder()
    .fluidInputs(fluid('hot_hp_propene') * 50)
    .fluidInputs(fluid('hot_hp_benzene') * 50)
    .fluidInputs(fluid('phosphoric_acid') * 50)
    .fluidOutputs(fluid('acidic_cumene') * 100)
    .duration(10)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

CSTR.recipeBuilder()
    .fluidInputs(fluid('oxygen') * 50)
    .fluidInputs(fluid('acidic_cumene') * 100)
    .fluidOutputs(fluid('rearranged_cumene') * 150)
    .duration(10)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('rearranged_cumene') * 150)
    .fluidOutputs(fluid('phosphoric_acid') * 50)
    .fluidOutputs(fluid('phenol') * 50)
    .fluidOutputs(fluid('acetone') * 50)
    .disableDistilleryRecipes()
    .duration(10)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// Nitrogen Dioxide

REACTION_FURNACE.recipeBuilder()
    .fluidInputs(fluid('nitrogen') * 1000)
    .fluidInputs(fluid('oxygen') * 2000)
    .fluidOutputs(fluid('nitrogen_dioxide') * 1000)
    .duration(60)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

// Isobutylene

FBR.recipeBuilder()
    .fluidInputs(fluid('isobutane') * 50)
    .notConsumable(ore('catalystBedChromiumTrioxide') * 1)
    .fluidOutputs(fluid('isobutylene') * 50)
    .fluidOutputs(fluid('hydrogen') * 100)
    .duration(10)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// Raney Nickel and cyclohexane

MIXER.recipeBuilder()
    .fluidInputs(fluid('aluminium') * 144)
    .inputs(ore('dustAnyPurityNickel') * 1)
    .inputs(ore('dustTinyZinc') * 1)
    .outputs(metaitem('dustRaneyNickel') * 2)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

BR.recipeBuilder()
    .fluidInputs(fluid('sulfuric_acid') * 1000)
    .inputs(ore('dustSodiumDichromate') * 11)
    .outputs(metaitem('dustChromiumTrioxide') * 8)
    .fluidOutputs(fluid('sodium_sulfate_solution') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('sodium_sulfate_solution') * 1000)
    .fluidOutputs(fluid('water') * 1000)
    .outputs(metaitem('dustSodiumSulfate') * 7)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

BR.recipeBuilder()
    .inputs(ore('dustRaneyNickel') * 4)
    .inputs(ore('dustSodiumHydroxide') * 6)
    .fluidInputs(fluid('water') * 6000)
    .outputs(metaitem('dustActivatedRaneyNickel') * 2)
    .outputs(metaitem('dustSodiumAluminate') * 20)
    .fluidOutputs(fluid('hydrogen') * 6000)
    .duration(240)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

ROASTER.recipeBuilder()
        .circuitMeta(1)
        .inputs(ore('dustAnyPurityCopper') * 1)
        .fluidInputs(fluid('oxygen') * 1000)
        .outputs(metaitem('dustCupricOxide') * 2)
        .duration(100)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

ROASTER.recipeBuilder()
        .circuitMeta(2)
        .inputs(ore('dustAnyPurityCopper') * 2)
        .fluidInputs(fluid('oxygen') * 1000)
        .outputs(metaitem('dustCuprousOxide') * 3)
        .duration(100)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

// DicobaltOctacarbonyl

ROASTER.recipeBuilder()
    .inputs(ore('dustAnyPurityCobalt') * 2)
    .fluidInputs(fluid('carbon_monoxide') * 8000)
    .outputs(metaitem('dustDicobaltOctacarbonyl') * 18)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// Impregnated Alumina Catalyst

ALLOY_SMELTER.recipeBuilder()
    .inputs(ore('dustSilicaGel') * 3)
    .inputs(ore('dustAlumina') * 5)
    .outputs(metaitem('dustImpregnatedAluminaCatalyst') * 8)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// Copper Bismuth

MIXER.recipeBuilder()
    .inputs(ore('dustAnyPurityBismuth') * 1)
    .inputs(ore('dustAnyPurityCopper') * 1)
    .outputs(metaitem('dustBismuthCopper') * 2)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// 2-EAQ

BR.recipeBuilder()
    .inputs(ore("dustPhthalicAnhydride") * 13)
    .fluidInputs(fluid("ethylbenzene") * 1000)
    .fluidOutputs(fluid("two_ethylanthraquinone") * 1000)
    .fluidOutputs(fluid("water") * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

// 2-EAHQ

FBR.recipeBuilder()
    .fluidInputs(fluid('two_ethylanthraquinone') * 50)
    .fluidInputs(fluid('hydrogen') * 100)
    .notConsumable(ore('catalystBedPalladium') * 1)
    .fluidOutputs(fluid('two_ethylanthrahydroquinone') * 50)
    .duration(20)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// Hydrogen Peroxide

BCR.recipeBuilder()
    .fluidInputs(fluid("two_ethylanthrahydroquinone") * 50)
    .fluidInputs(fluid("hot_hp_oxygen") * 100)
    .fluidOutputs(fluid("two_ethylanthraquinone_solution") * 200)
    .duration(100) // Adjust the duration as needed
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

CSTR.recipeBuilder()
    .fluidInputs(fluid("two_ethylanthraquinone_solution") * 200)
    .fluidInputs(fluid("water") * 150)
    .fluidOutputs(fluid("two_ethylanthraquinone") * 50)
    .fluidOutputs(fluid("hydrogen_peroxide_solution") * 300)
    .duration(10)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

VACUUM_DT.recipeBuilder()
    .fluidInputs(fluid('hydrogen_peroxide_solution') * 1000)
    .fluidOutputs(fluid('water') * 1000)
    .fluidOutputs(fluid('hydrogen_peroxide') * 1000)
    .duration(40)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister()

// Butanone

FBR.recipeBuilder()
    .fluidInputs(fluid('two_butanol') * 50)
    .notConsumable(ore('catalystBedChromiumTrioxide') * 1)
    .fluidOutputs(fluid('butanone') * 50)
    .fluidOutputs(fluid('hydrogen') * 100)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

// Aluminium Chloride

TBR.recipeBuilder()
    .fluidInputs(fluid('benzene') * 50)
    .fluidInputs(fluid('bromine') * 50)
    .notConsumable(ore('dustAluminiumChloride'))
    .fluidOutputs(fluid('bromobenzene') * 50)
    .fluidOutputs(fluid('hydrogen') * 50)
    .duration(10)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

// Philips catalyst

ALLOY_SMELTER.recipeBuilder()
    .inputs(ore('dustSilicaGel') * 3)
    .inputs(ore('dustChromiumTrioxide') * 4)
    .outputs(metaitem('dustPhilipsCatalyst') * 7)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

// Ziegler-Natta

ROASTER.recipeBuilder()
    .inputs(ore('dustAnyPurityAluminium'))
    .fluidInputs(fluid('chlorine') * 3000)
    .outputs(metaitem('dustAluminiumChloride') * 4)
    .duration(100) // Adjust the duration as needed
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

BR.recipeBuilder()
    .inputs(ore('dustAnyPurityAluminium') * 2)
    .fluidInputs(fluid('hydrogen') * 6000)
    .fluidInputs(fluid('ethylene') * 6000)
    .fluidOutputs(fluid('triethylaluminium') * 1000)
    .duration(200)
    .EUt(120)
    .buildAndRegister();

MIXER.recipeBuilder()
    .fluidInputs(fluid('triethylaluminium') * 1000)
    .fluidInputs(fluid('titanium_tetrachloride') * 1000)
    .outputs(metaitem('dustZieglerNattaCatalyst') * 10)
    .duration(160)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

// Pyromellitic Dianhydride

ROASTER.recipeBuilder()
    .inputs(ore('dustDurene') * 4)
    .fluidInputs(fluid('oxygen') * 2000)
    .outputs(metaitem('dustPyromelliticDianhydride') * 3)
    .fluidOutputs(fluid('dense_steam') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

// Kapton K

POLYMERIZATION.recipeBuilder()
    .inputs(ore('dustPyromelliticDianhydride'))
    .inputs(ore('dustFourFourOxydianiline'))
    .fluidInputs(fluid('acetone') * 2000)
    .fluidOutputs(fluid('impure_kapton_k') * 2000)
    .duration(400) 
    .EUt(Globals.voltAmps[3] * 2)
    .buildAndRegister();

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('impure_kapton_k') * 1000)
    .fluidOutputs(fluid('acetone') * 1000)
    .outputs(metaitem('dustKaptonK'))
    .duration(200)
    .EUt(Globals.voltAmps[2])
    .buildAndRegister();

// Kapton E

MIXER.recipeBuilder()
     .inputs(ore('dustPyromelliticDianhydride'))
    .inputs(ore('dustFourFourOxydianiline'))
    .inputs(ore('dustBiphenylTetracarboxylicAcidDianhydride'))
    .inputs(ore('dustParaPhenylenediamine'))
    .fluidInputs(fluid('acetone') * 4000)
    .fluidOutputs(fluid('kapton_e_preparation') * 4000)
    .duration(800)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

POLYMERIZATION.recipeBuilder()
    .fluidInputs(fluid('kapton_e_preparation') * 1000)
    .fluidOutputs(fluid('impure_kapton_e') * 1000)
    .duration(200)
    .EUt(Globals.voltAmps[2] * 2)
    .buildAndRegister();

DRYER.recipeBuilder()
    .fluidInputs(fluid('impure_kapton_e') * 1000)
    .fluidOutputs(fluid('acetone') * 1000)
    .outputs(metaitem('dustKaptonE'))
    .duration(200)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

// Bromomethane

BR.recipeBuilder()
    .fluidInputs(fluid('methanol') * 6000)
    .fluidInputs(fluid('bromine') * 3000)
    .inputs(ore('dustAnyPuritySulfur'))
    .fluidOutputs(fluid('bromomethane') * 6000)
    .fluidOutputs(fluid('very_diluted_sulfuric_acid') * 3000)
    .duration(60) // Adjust the duration as needed
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

DISTILLATION_TOWER.recipeBuilder()
    .fluidInputs(fluid('very_diluted_sulfuric_acid') * 3000)
    .fluidOutputs(fluid('sulfuric_acid') * 1000)
    .fluidOutputs(fluid('water') * 2000)
    .duration(60)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister();

// Hydrazine

CSTR.recipeBuilder()
        .fluidInputs(fluid('sulfuric_acid') * 50)
        .fluidInputs(fluid('two_butene') * 50)
        .fluidInputs(fluid('water') * 50)
        .fluidOutputs(fluid('two_butanol_solution') * 100)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('two_butanol_solution') * 2000)
        .fluidOutputs(fluid('sulfuric_acid') * 1000)
        .fluidOutputs(fluid('two_butanol') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('ammonia_solution') * 50)
        .fluidInputs(fluid('acetic_acid') * 50)
        .fluidOutputs(fluid('ammonium_acetate_solution') * 50)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('ammonium_acetate_solution') * 1000)
        .outputs(metaitem('dustAcetamide') * 9)
        .fluidOutputs(fluid('water') * 2000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustAcetamide') * 18)
        .fluidInputs(fluid('butanone') * 1000)
        .fluidOutputs(fluid('acetamide_solution') * 1000)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('acetamide_solution') * 50)
        .fluidInputs(fluid('hydrogen_peroxide') * 50)
        .fluidInputs(fluid('ammonia') * 200)
        .fluidOutputs(fluid('hydrazine_solution') * 250)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('hydrazine_solution') * 5000)
        .fluidOutputs(fluid('hydrazine') * 1000)
        .fluidOutputs(fluid('water') * 4000)
        .fluidOutputs(fluid('ammonia') * 2000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Amine oligomerization

BR.recipeBuilder()
        .fluidInputs(fluid('one_two_dichloroethane') * 1525)
        .fluidInputs(fluid('ammonia') * 2425)
        .fluidOutputs(fluid('aminated_ethylene_mixture') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('aminated_ethylene_mixture') * 1000)
        .fluidInputs(fluid('sodium_hydroxide_solution') * 3050)
        .fluidOutputs(fluid('neutralized_aminated_ethylene_mixture') * 4050)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('neutralized_aminated_ethylene_mixture') * 4050)
        .outputs(metaitem('dustSalt') * 6)
        .fluidOutputs(fluid('piperazine') * 50)
        .fluidOutputs(fluid('triethylenetetramine') * 100)
        .fluidOutputs(fluid('aminoethylpiperazine') * 50)
        .fluidOutputs(fluid('diethylenetriamine') * 300)
        .fluidOutputs(fluid('ethylenediamine') * 500)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Nitrosyl Chloride
CSTR.recipeBuilder()
        .fluidInputs(fluid('chlorine') * 50)
        .fluidInputs(fluid('nitric_oxide') * 50)
        .fluidOutputs(fluid('nitrosyl_chloride') * 50)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustAnyPuritySulfur') * 1)
        .fluidInputs(fluid('chlorine') * 2000)
        .fluidOutputs(fluid('sulfur_dichloride') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Thionyl chloride
BCR.recipeBuilder()
        .fluidInputs(fluid('sulfur_trioxide') * 50)
        .fluidInputs(fluid('sulfur_dichloride') * 50)
        .fluidOutputs(fluid('thionyl_chloride') * 50)
        .fluidOutputs(fluid('sulfur_dioxide') * 50)
        .duration(20)
        .EUt(30)
        .buildAndRegister()

BCR.recipeBuilder()
        .fluidInputs(fluid('thionyl_chloride') * 50)
        .fluidInputs(fluid('water') * 150)
        .fluidOutputs(fluid('sulfur_dioxide') * 50)
        .fluidOutputs(fluid('hydrochloric_acid') * 100)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

// Diborane
BR.recipeBuilder()
        .inputs(ore('dustLithiumHydride') * 12)
        .fluidInputs(fluid('boron_trifluoride') * 8000)
        .outputs(metaitem('dustLithiumTetrafluoroborate') * 36)
        .fluidOutputs(fluid('diborane') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustLithiumTetrafluoroborate') * 6)
        .outputs(metaitem('dustLithiumFluoride') * 2)
        .fluidOutputs(fluid('boron_trifluoride') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Lithium Hydride
ROASTER.recipeBuilder()
        .inputs(ore('dustAnyPurityLithium') * 1)
        .fluidInputs(fluid('hydrogen') * 1000)
        .outputs(metaitem('dustLithiumHydride') * 2)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

// Tetramethylammonium hydroxide
BR.recipeBuilder()
        .inputs(ore('dustTetramethylammoniumChloride') * 6)
        .inputs(ore('dustSodiumHydroxide') * 3)
        .fluidInputs(fluid('methanol') * 1000)
        .fluidOutputs(fluid('tetramethylammonium_hydroxide_solution') * 1000)
        .outputs(metaitem('dustSalt') * 2)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Pyrocatechol
BR.recipeBuilder()
        .fluidInputs(fluid('phenol') * 1000)
        .fluidInputs(fluid('hydrogen_peroxide') * 1000)
        .outputs(metaitem('dustPyrocatechol') * 12)
        .fluidOutputs(fluid('water') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Tetramethylammonium chloride
LCR.recipeBuilder()
        .fluidInputs(fluid('trimethylamine') * 1000)
        .fluidInputs(fluid('chloromethane') * 1000)
        .fluidInputs(fluid('ethanol') * 4000)
        .outputs(metaitem('dustTetramethylammoniumChloride') * 6)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

// 1,4-Bis(trichloromethyl)benzene
CSTR.recipeBuilder()
        .fluidInputs(fluid('para_xylene') * 50)
        .fluidInputs(fluid('chlorine') * 300)
        .fluidOutputs(fluid('bistrichloromethylbenzene') * 50)
        .fluidOutputs(fluid('hydrogen') * 300)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

// Ammonium Bisulfate
ELECTROLYZER.recipeBuilder()
        .notConsumable(ore('stickPlatinum'))
        .notConsumable(metaitem('graphite_electrode'))
        .fluidInputs(fluid('ammonium_bisulfate') * 1584)
        .fluidOutputs(fluid('sulfuric_acid') * 1000)
        .fluidOutputs(fluid('ammonia') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Tosylic Acid, Hydrogen Silsesquioxane

CSTR.recipeBuilder()
        .fluidInputs(fluid('toluene') * 50)
        .fluidInputs(fluid('oleum') * 550)
        .fluidInputs(fluid('distilled_water') * 50)
        .fluidOutputs(fluid('tosylic_acid_solution') * 50)
        .fluidOutputs(fluid('sulfuric_acid') * 500)
        .duration(20)
        .EUt(30)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('trichlorosilane') * 50)
        .fluidInputs(fluid('toluene') * 300)
        .fluidOutputs(fluid('trichlorosilane_solution') * 350)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
        .notConsumable(fluid('tosylic_acid_solution') * 3500)
        .fluidInputs(fluid('trichlorosilane_solution') * 3500)
        .fluidOutputs(fluid('acidic_hydrogen_silsesquioxane_solution') * 3000)
        .duration(100)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('acidic_hydrogen_silsesquioxane_solution') * 3000)
        .fluidInputs(fluid('distilled_water') * 100)
        .fluidOutputs(fluid('hydrogen_silsesquioxane_solution') * 3050)
        .fluidOutputs(fluid('acidic_wastewater') * 50)
        .duration(100)
        .EUt(30)
        .buildAndRegister()

VACUUM_DT.recipeBuilder()
        .fluidInputs(fluid('hydrogen_silsesquioxane_solution') * 3050)
        .chancedOutput(metaitem('dustHydrogenSilsesquioxane'), 625, 0)
        .fluidOutputs(fluid('water') * 50)
        .fluidOutputs(fluid('toluene') * 3000)
        .duration(100)
        .EUt(30)
        .buildAndRegister()

/*
Let us produce a 5% wt solution of hydrogen silsesquioxane (H8Si8O12) in MIBK.

Assume 100g.
5g HSQ / (424.744 g/mol) = 0.0117718 mol HSQ
95g MIBK / (100.16 g/mol) = 0.94848 mol MIBK

Thus, HSQ should be 1.24% molar in MIBK
*/

MIXER.recipeBuilder()
        .inputs(ore('dustTinyHydrogenSilsesquioxane'))
        .fluidInputs(fluid('methyl_isobutyl_ketone') * 11000)
        .fluidOutputs(fluid('hydrogen_silsesquioxane_photoresist') * 11000)
        .duration(100)
        .EUt(30)
        .buildAndRegister()

// Phosphine

BR.recipeBuilder()
        .fluidInputs(fluid('potassium_hydroxide_solution') * 3000)
        .inputs(ore('dustAnyPurityPhosphorus') * 4)
        .fluidOutputs(fluid('phosphine') * 1000)
        .outputs(metaitem('dustPotassiumHypophosphite') * 18)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('sodium_hydroxide_solution') * 3000)
        .inputs(ore('dustAnyPurityPhosphorus') * 4)
        .fluidOutputs(fluid('phosphine') * 1000)
        .outputs(metaitem('dustSodiumHypophosphite') * 18)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustSodiumHypophosphite') * 12)
        .fluidOutputs(fluid('phosphine') * 1000)
        .outputs(metaitem('dustDisodiumPhosphate') * 8)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustPotassiumHypophosphite') * 12)
        .fluidOutputs(fluid('phosphine') * 1000)
        .outputs(metaitem('dustDipotassiumPhosphate') * 8)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

// Boron Trifluoride

BR.recipeBuilder()
        .inputs(ore('dustBoronTrioxide') * 5)
        .fluidInputs(fluid('hydrogen_fluoride') * 6000)
        .fluidOutputs(fluid('boron_trifluoride') * 2000)
        .fluidOutputs(fluid('water') * 3000)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustBoricAcid') * 7)
        .fluidInputs(fluid('hydrogen_fluoride') * 3000)
        .fluidOutputs(fluid('boron_trifluoride') * 1000)
        .fluidOutputs(fluid('water') * 3000)
        .duration(100)
        .EUt(30)
        .buildAndRegister()

// Tetrasodium EDTA
LCR.recipeBuilder()
        .inputs(ore('dustSodiumCyanide') * 12)
        .fluidInputs(fluid('ethylenediamine') * 1000)
        .fluidInputs(fluid('formaldehyde') * 4000)
        .fluidInputs(fluid('diluted_hydrochloric_acid') * 8000)
        .outputs(metaitem('dustEthylenediaminetetraaceticAcid') * 32)
        .fluidOutputs(fluid('ammonia') * 4000)
        .fluidOutputs(fluid('wastewater') * 4000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustEthylenediaminetetraaceticAcid') * 36)
        .fluidInputs(fluid('sodium_hydroxide_solution') * 4000)
        .fluidOutputs(fluid('tetrasodium_ethylenediaminetetraacetate_solution') * 4000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('tetrasodium_ethylenediaminetetraacetate_solution') * 4000)
        .fluidOutputs(fluid('diluted_saltwater') * 8000)
        .outputs(metaitem('dustTetrasodiumEthylenediaminetetraacetate') * 36)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Phosphoryl chloride
CSTR.recipeBuilder()
        .fluidInputs(fluid('phosphorus_trichloride') * 50)
        .fluidInputs(fluid('oxygen') * 50)
        .fluidOutputs(fluid('phosphoryl_chloride') * 50)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

// Phosphorus trichloride
ROASTER.recipeBuilder()
        .inputs(ore('dustAnyPurityPhosphorus') * 4)
        .fluidInputs(fluid('chlorine') * 12000)
        .fluidOutputs(fluid('phosphorus_trichloride') * 2000)
        .outputs(metaitem('dustPhosphorusPentachloride') * 12)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('phosphorus_trichloride') * 1000)
        .inputs(ore('dustAnyPurityPhosphorus') * 4)
        .fluidOutputs(fluid('phosphorus_solution') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

CSTR.recipeBuilder()
        .fluidInputs(fluid('phosphorus_solution') * 50)
        .fluidInputs(fluid('chlorine') * 600)
        .fluidOutputs(fluid('phosphorus_trichloride') * 250)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('phosphorus_trichloride') * 1000)
        .fluidInputs(fluid('chlorine') * 2000)
        .outputs(metaitem('dustPhosphorusPentachloride') * 6)
        .duration(100)
        .EUt(30)
        .buildAndRegister()

// Durene
BR.recipeBuilder()
        .fluidInputs(fluid('para_xylene') * 1000)
        .fluidInputs(fluid('chloromethane') * 2000)
        .outputs(metaitem('dustDurene') * 24)
        .fluidOutputs(fluid('hydrogen_chloride') * 2000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Creating diiodobenzene

// Step 1: Producing urea solution
CSTR.recipeBuilder()
        .fluidInputs(fluid('ammonia') * 100)
        .fluidInputs(fluid('carbon_dioxide') * 50)
        .fluidOutputs(fluid('urea_solution') * 50)
        .duration(10)
        .EUt(30)
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('urea_solution') * 1000)
        .outputs(metaitem('dustUrea') * 8)
        .fluidOutputs(fluid('water') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Step 2: Creating impure 1,4-diiodobenzene
LCR.recipeBuilder()
        .inputs(ore('dustSodiumNitrate') * 5)
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .fluidInputs(fluid('phosphoric_acid') * 1000)
        .fluidInputs(fluid('urea_solution') * 1000)
        .inputs(ore('dustParaPhenylenediamine') * 16)
        .inputs(ore('dustPotassiumIodide') * 4)
        .fluidOutputs(fluid('impure_diiodobenzene') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Step 3: Purifying 1,4-diiodobenzene
CENTRIFUGE.recipeBuilder()
        .fluidInputs(fluid('impure_diiodobenzene') * 1000)
        .fluidInputs(fluid('water') * 1000)
        .outputs(metaitem('dustDiiodobenzene') * 12)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Turning diiodobenzene into oxydianiline

MIXER.recipeBuilder()
        .inputs(ore('dustDiiodobenzene') * 12)
        .fluidInputs(fluid('ethanol') * 1000)
        .fluidOutputs(fluid('diiodobenzene_solution') * 1000)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

FBR.recipeBuilder()
        .fluidInputs(fluid('diiodobenzene_solution') * 50)
        .fluidInputs(fluid('ammonia_solution') * 150)
        .fluidOutputs(fluid('impure_four_four_oxydianiline') * 200)
        .notConsumable(ore('catalystBedCopper'))
        .duration(300)
        .EUt(30)
        .buildAndRegister()

BCR.recipeBuilder()
        .circuitMeta(1)
        .fluidInputs(fluid('water') * 50)
        .fluidInputs(fluid('ammonia') * 50)
        .fluidOutputs(fluid('ammonia_solution') * 50)
        .duration(5)
        .EUt(30)
        .buildAndRegister()

BCR.recipeBuilder()
        .circuitMeta(2)
        .fluidInputs(fluid('water') * 100)
        .fluidInputs(fluid('ammonia') * 50)
        .fluidOutputs(fluid('diluted_ammonia_solution') * 100)
        .duration(1)
        .EUt(30)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('ammonia_solution') * 1000)
        .fluidInputs(fluid('water') * 1000)
        .fluidOutputs(fluid('diluted_ammonia_solution') * 1000)
        .duration(20)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()


/*DISTILLATION_TOWER.recipeBuilder()
        .disableDistilleryRecipes()
        .circuitMeta(1)
        .fluidInputs(fluid('diluted_ammonia_solution') * 2000)
        .fluidOutputs(fluid('water') * 2000)
        .fluidOutputs(fluid('ammonia') * 1000)
        .duration(40)
        .EUt(30)
        .buildAndRegister() */

DISTILLATION_TOWER.recipeBuilder()
        //.circuitMeta(2)
        .fluidInputs(fluid('diluted_ammonia_solution') * 2000)
        .fluidOutputs(fluid('ammonia_solution') * 1000)
        .fluidOutputs(fluid('water') * 1000)
        .duration(20)
        .EUt(30)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('impure_four_four_oxydianiline') * 8000)
        .fluidOutputs(fluid('four_four_oxydianiline_slurry') * 5000)
        .fluidOutputs(fluid('ethanol') * 2000)
        .outputs(metaitem('dustAmmoniumIodide') * 24)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

CENTRIFUGE.recipeBuilder()
        .fluidInputs(fluid('four_four_oxydianiline_slurry') * 5000)
        .fluidOutputs(fluid('water') * 5000)
        .outputs(metaitem('dustFourFourOxydianiline') * 27)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

ELECTROLYTIC_CELL.recipeBuilder()
        .fluidInputs(fluid('ammonium_iodide') * 1728)
        .fluidOutputs(fluid('ammonia') * 2000)
        .fluidOutputs(fluid('hydrogen') * 2000)
        .outputs(metaitem('dustIodine') * 2)
        .duration(300)
        .EUt(30)
        .buildAndRegister()

// Ethylene glycol
CSTR.recipeBuilder()
        .fluidInputs(fluid('ethylene_oxide') * 85)
        .fluidInputs(fluid('water') * 100)
        .fluidOutputs(fluid('ethylene_glycol_mix') * 100)
        .duration(5)
        .EUt(30)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('ethylene_glycol_mix') * 1000)
        .fluidOutputs(fluid('triethylene_glycol') * 50)
        .fluidOutputs(fluid('diethylene_glycol') * 100)
        .fluidOutputs(fluid('ethylene_glycol') * 500)
        .fluidOutputs(fluid('water') * 150)
        .duration(200)
        .EUt(30)
        .buildAndRegister()

// Hydrobromic acid
CSTR.recipeBuilder()
        .fluidInputs(fluid('bromine') * 100)
        .fluidInputs(fluid('sulfur_dioxide') * 50)
        .fluidInputs(fluid('water') * 100)
        .fluidOutputs(fluid('brominated_sulfur_dioxide') * 150)
        .EUt(30)
        .duration(15)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('brominated_sulfur_dioxide') * 3000)
        .fluidOutputs(fluid('sulfuric_acid') * 1000)
        .fluidOutputs(fluid('hydrogen_bromide') * 2000)
        .EUt(30)
        .duration(300)
        .buildAndRegister()

BCR.recipeBuilder()
        .fluidInputs(fluid('hydrogen_bromide') * 50)
        .fluidInputs(fluid('water') * 50)
        .fluidOutputs(fluid('hydrobromic_acid') * 50)
        .EUt(7)
        .duration(1)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustSodiumHydroxide') * 3)
        .fluidInputs(fluid('hydrogen_bromide') * 1000)
        .fluidOutputs(fluid('sodium_bromide_solution') * 1000)
        .EUt(30)
        .duration(20)
        .buildAndRegister()

// Hydrogen cyanide
REACTION_FURNACE.recipeBuilder()
        .fluidInputs(fluid('methane') * 50)
        .fluidInputs(fluid('ammonia') * 50)
        .fluidInputs(fluid('oxygen') * 150)
        .notConsumable(ore('catalystBedPlatinum'))
        .fluidOutputs(fluid('gtfo_hydrogen_cyanide') * 50)
        .fluidOutputs(fluid('water') * 150)
        .EUt(120)
        .duration(10)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('ammonia') * 1000)
        .inputs(ore('dustAnyPuritySodium'))
        .fluidOutputs(fluid('hydrogen') * 1000)
        .outputs(metaitem('dustSodiumAmide') * 4)
        .EUt(120)
        .duration(200)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustAnyPurityCarbon'))
        .inputs(ore('dustSodiumAmide') * 4)
        .fluidOutputs(fluid('hydrogen') * 2000)
        .outputs(metaitem('dustSodiumCyanide') * 3)
        .EUt(120)
        .duration(200)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('hydrochloric_acid') * 1000)
        .inputs(ore('dustSodiumCyanide') * 3)
        .fluidOutputs(fluid('gtfo_hydrogen_cyanide') * 1000)
        .fluidOutputs(fluid('salt_water') * 1000)
        .EUt(120)
        .duration(200)
        .buildAndRegister()

// Ethylene oxide
FBR.recipeBuilder()
        .fluidInputs(fluid('ethylene') * 50)
        .fluidInputs(fluid('oxygen') * 50)
        .notConsumable(ore('catalystBedSilver'))
        .fluidOutputs(fluid('carbon_dioxide') * 5)
        .fluidOutputs(fluid('impure_ethylene_oxide') * 45)
        .EUt(30)
        .duration(10)
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('impure_ethylene_oxide') * 900)
        .fluidOutputs(fluid('water') * 100)
        .fluidOutputs(fluid('ethylene_oxide') * 800)
        .EUt(30)
        .duration(200)
        .buildAndRegister()

//ALON

TUBE_FURNACE.recipeBuilder()
        .inputs(ore('dustAnyPurityAluminium'))
        .fluidInputs(fluid('nitrogen') * 1000)
        .notConsumable(metaitem('dustAmmoniumChloride') * 6)
        .outputs(metaitem('dustAluminiumNitride') * 2)
        .EUt(1920)
        .duration(20)
        .buildAndRegister()

SINTERING_OVEN.recipeBuilder()
        .inputs(ore('dustAluminiumNitride') * 10)
        .inputs(ore('dustAlumina') * 45)
        .notConsumable(fluid('argon') * 1000)
        .outputs(metaitem('dustAluminiumOxynitride'))
        .EUt(1920)
        .duration(20)
        .buildAndRegister()

//TETRAHYDROFURAN

CSTR.recipeBuilder()
.fluidInputs(fluid('butanediol') * 50)
.fluidInputs(fluid('sulfuric_acid') * 50)
.fluidOutputs(fluid('tetrahydrofuran_solution') * 150)
.EUt(30)
.duration(5)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('tetrahydrofuran_solution') * 3000)
.fluidOutputs(fluid('sulfuric_acid') * 1000)
.fluidOutputs(fluid('water') * 1000)
.fluidOutputs(fluid('tetrahydrofuran') * 1000)
.EUt(90)
.duration(600)
.buildAndRegister()

//KAMINSKY CATALYST

BR.recipeBuilder()
        .fluidInputs(fluid('sodium') * 144)
        .fluidInputs(fluid('cyclopentadiene') * 1000)
        .fluidInputs(fluid('tetrahydrofuran') * 1000)
        .fluidOutputs(fluid('sodium_cyclopentadienide_solution') * 1000)
        .fluidOutputs(fluid('hydrogen') * 1000)
        .EUt(1920)
        .duration(60)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustZirconiumTetrachloride') * 5)
        .fluidInputs(fluid('tetrahydrofuran') * 2000)
        .outputs(metaitem('dustZirconiumTetrachlorideTetrahydrofuranComplex') * 7)
        .EUt(1920)
        .duration(60)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustZirconiumTetrachlorideTetrahydrofuranComplex') * 7)
        .fluidInputs(fluid('sodium_cyclopentadienide_solution') * 2000)
        .outputs(metaitem('dustZirconoceneDichloride'))
        .outputs(metaitem('dustSalt') * 4)
        .fluidOutputs(fluid('tetrahydrofuran') * 4000)
        .EUt(1920)
        .duration(60)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustAnyPurityAluminium'))
        .inputs(ore('dustAnyPuritySodium') * 3)
        .fluidInputs(fluid('chloromethane') * 3000)
        .outputs(metaitem('dustSalt') * 6)
        .fluidOutputs(fluid('trimethylaluminium') * 1000)
        .EUt(1920)
        .duration(60)
        .buildAndRegister()

BR.recipeBuilder()
        .fluidInputs(fluid('trimethylaluminium') * 1000)
        .fluidInputs(fluid('water') * 1000)
        .outputs(metaitem('dustMethylaluminoxane'))
        .fluidOutputs(fluid('methane') * 2000)
        .EUt(1920)
        .duration(60)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustZirconiumDioxide') * 6)
        .inputs(ore('dustMethylaluminoxane'))
        .inputs(ore('dustZirconoceneDichloride'))
        .notConsumable(fluid('toluene') * 1000)
        .outputs(metaitem('dustKaminskyCatalyst'))
        .EUt(1920)
        .duration(60)
        .buildAndRegister()

//DISTILLATION REORDERING

DISTILLATION_TOWER.recipeBuilder()
        .fluidInputs(fluid('diluted_sulfuric_acid') * 500)
        .fluidOutputs(fluid('sulfuric_acid') * 250)
        .fluidOutputs(fluid('water') * 250)
        .EUt(30)
        .duration(50)
        .buildAndRegister()

MIXER.recipeBuilder()
        .fluidInputs(fluid('water') * 1000)
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .fluidOutputs(fluid('diluted_sulfuric_acid') * 2000)
        .EUt(30)
        .duration(120)
        .buildAndRegister()

//PATCH PHOSPHORUS DUPE
mods.gregtech.batch_reactor.removeByInput(30, [metaitem('dustPhosphorusPentoxide')], [fluid('water') * 6000])

BR.recipeBuilder()
        .inputs(ore('dustPhosphorusPentoxide') * 14)
        .fluidInputs(fluid('water') * 4000)
        .fluidOutputs(fluid('phosphoric_acid') * 4000)
        .EUt(30)
        .duration(40)
        .buildAndRegister()

//PICRIC ACID

BR.recipeBuilder()

BR.recipeBuilder()
.fluidInputs(fluid('phenol') * 1000)
.fluidInputs(fluid('nitration_mixture') * 6000)
.fluidOutputs(fluid('tnp_slurry') * 3000)
.duration(200)
.EUt(24)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('tnp_slurry') * 1000)
.fluidOutputs(fluid('diluted_sulfuric_acid') * 1000)
.outputs(metaitem('dustPicricAcid') * 7)
.duration(300)
.EUt(30)
.buildAndRegister()

//AMMONIUM THIOCYANATE

CSTR.recipeBuilder()
.fluidInputs(fluid('carbon_disulfide') * 50)
.fluidInputs(fluid('ammonia_solution') * 50)
.fluidOutputs(fluid('ammonium_thiocyanate_solution') * 50)
.fluidOutputs(fluid('hydrogen_sulfide') * 50)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
.fluidInputs(fluid('ammonium_thiocyanate_solution') * 1000)
.outputs(metaitem('dustAmmoniumThiocyanate') * 8)
.fluidOutputs(fluid('water') * 1000)
.duration(60)
.EUt(30)
.buildAndRegister()

//TOLUENE FROM BENZENE
TBR.recipeBuilder()
.notConsumable(ore('dustAluminiumChloride'))
.circuitMeta(1)
.fluidInputs(fluid('benzene') * 50)
.fluidInputs(fluid('chloromethane') * 50)
.fluidOutputs(fluid('toluene') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.duration(10)
.EUt(30)
.buildAndRegister()

//XYLENE FROM BENZENE
TBR.recipeBuilder()
.notConsumable(ore('dustAluminiumChloride'))
.circuitMeta(2)
.fluidInputs(fluid('benzene') * 50)
.fluidInputs(fluid('chloromethane') * 100)
.fluidOutputs(fluid('ortho_para_xylene_mixture') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 100)
.duration(10)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('ortho_para_xylene_mixture') * 1000)
.fluidOutputs(fluid('para_xylene') * 575)
.fluidOutputs(fluid('ortho_xylene') * 375)
.fluidOutputs(fluid('meta_xylene') * 50)
.duration(100)
.EUt(Globals.voltAmps[1] * 2)
.buildAndRegister()

//XYLENE FROM TOLUENE
TBR.recipeBuilder()
.notConsumable(ore('dustAluminiumChloride'))
.fluidInputs(fluid('toluene') * 50)
.fluidInputs(fluid('chloromethane') * 50)
.fluidOutputs(fluid('ortho_para_xylene_mixture') * 50)
.fluidOutputs(fluid('hydrogen_chloride') * 50)
.duration(10)
.EUt(30)
.buildAndRegister()

//POLYCHLORINATED BIPHENYL, BENZENE FROM TOLUENE

CRACKER.recipeBuilder()
.fluidInputs(fluid('toluene') * 1000)
.fluidInputs(fluid('hydrogen') * 4000)
.fluidOutputs(fluid('hydrodealkylated_toluene_mixture') * 1000)
.duration(100)
.EUt(Globals.voltAmps[2])
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('hydrodealkylated_toluene_mixture') * 1000)
.chancedOutput(metaitem('dustBiphenyl'), 250, 0)
.fluidOutputs(fluid('toluene') * 200)
.fluidOutputs(fluid('benzene') * 750)
.fluidOutputs(fluid('methane') * 750)
.fluidOutputs(fluid('hydrogen') * 2400)
.duration(100)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.notConsumable(ore('dustIronIiiChloride'))
.inputs(ore('dustBiphenyl'))
.fluidInputs(fluid('chlorine') * 5000)
.fluidOutputs(fluid('polychlorinated_biphenyl') * 1000)
.fluidOutputs(fluid('hydrogen_chloride') * 5000)
.duration(15)
.EUt(30)
.buildAndRegister()

FLUIDIZEDBR.recipeBuilder()
.notConsumable(ore('springNichrome'))
.fluidInputs(fluid('benzene') * 1000)
.fluidInputs(fluid('oxygen') * 50)
.chancedOutput(metaitem('dustBiphenyl'), 500, 0)
.fluidOutputs(fluid('benzene') * 900)
.fluidOutputs(fluid('water') * 50)
.duration(100)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('sodium_hydroxide') * 432)
.fluidInputs(fluid('chlorobenzene') * 1000)
.outputs(metaitem('dustSalt') * 2)
.fluidOutputs(fluid('phenol') * 1000)
.duration(100)
.EUt(30)
.buildAndRegister()

BR.recipeBuilder()
.fluidInputs(fluid('sodium_phenoxide_solution') * 1000)
.fluidInputs(fluid('hydrogen_chloride') * 1000)
.fluidOutputs(fluid('phenol') * 1000)
.fluidOutputs(fluid('salt_water') * 1000)
.duration(100)
.EUt(30)
.buildAndRegister()

//BENZENE FROM PHENOL
ROASTER.recipeBuilder()
.fluidInputs(fluid('phenol') * 1000)
.inputs(ore('dustAnyPurityZinc'))
.fluidOutputs(fluid('benzene') * 1000)
.outputs(metaitem('dustZincOxide') * 2)
.duration(120)
.EUt(30)
.buildAndRegister()

//ZnO -> ZnCl2
BR.recipeBuilder()
.fluidInputs(fluid('hydrochloric_acid') * 2000)
.inputs(ore('dustZincOxide') * 2)
.fluidOutputs(fluid('diluted_zinc_chloride_solution') * 3000)
.duration(120)
.EUt(30)
.buildAndRegister()

DISTILLERY.recipeBuilder()
    .fluidInputs(fluid('diluted_zinc_chloride_solution') * 3000)
    .outputs(metaitem('dustZincChloride') * 3)
    .fluidOutputs(fluid('water') * 3000)
    .duration(100)
    .EUt(Globals.voltAmps[1])
    .buildAndRegister()

//ZIEGLER-ALFOL PROCESS
CSTR.recipeBuilder()
        .fluidInputs(fluid('triethylaluminium') * 50)
        .fluidInputs(fluid('ethylene') * 300)
        .fluidInputs(fluid('diethyl_ether') * 50)
        .fluidOutputs(fluid('alfol_trialkylaluminium_mixture') * 50)
        .duration(10)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

ROASTER.recipeBuilder()
        .fluidInputs(fluid('alfol_trialkylaluminium_mixture') * 1000)
        .fluidInputs(fluid('oxygen') * 3000)
        .fluidOutputs(fluid('aluminium_alkoxide_solution') * 1000)
        .duration(500)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('aluminium_alkoxide_solution') * 1000)
        .outputs(metaitem('dustAluminiumAlkoxideMixture'))
        .fluidOutputs(fluid('diethyl_ether') * 1000)
        .duration(500)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustAluminiumAlkoxideMixture'))
        .fluidInputs(fluid('water') * 3000)
        .outputs(metaitem('dustAluminiumHydroxide') * 7)
        .fluidOutputs(fluid('ziegler_alfol_mixture') * 3000)
        .duration(500)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder() //SCHULZ FLORY DISTRIBUTION, p = 0.73, ROUNDED TO NEAREST 5s, TRUNCATED
        .fluidInputs(fluid('ziegler_alfol_mixture') * 1000)
        .fluidOutputs(fluid('n_hexadecanol') * 30)
        .fluidOutputs(fluid('n_tetradecanol') * 45)
        .fluidOutputs(fluid('n_dodecanol') * 60)
        .fluidOutputs(fluid('n_decanol') * 90)
        .fluidOutputs(fluid('n_octanol') * 115)
        .fluidOutputs(fluid('n_hexanol') * 150)
        .fluidOutputs(fluid('n_butanol') * 215)
        .fluidOutputs(fluid('ethanol') * 295)
        .duration(166)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()


//CYCLOOCTADIENE

BR.recipeBuilder()
        .inputs(ore('dustNickelChloride') * 3)
        .inputs(ore('dustTriphenylphosphine') * 2)
        .notConsumable(fluid('acetic_acid') * 1000)
        .outputs(metaitem('dustDichlorobistriphenylphosphinenickelIi'))
        .duration(200)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustAnyPurityZinc'))
        .inputs(ore('dustDichlorobistriphenylphosphinenickelIi'))
        .fluidInputs(fluid('carbon_monoxide') * 2000)
        .notConsumable(fluid('tetrahydrofuran') * 1000)
        .outputs(metaitem('dustDicarbonylbistriphenylphosphinenickelZero'))
        .outputs(metaitem('dustZincChloride') * 3)
        .duration(200)
        .EUt(Globals.voltAmps[3])
        .buildAndRegister()

TBR.recipeBuilder()
        .notConsumable(ore('dustDicarbonylbistriphenylphosphinenickelZero'))
        .fluidInputs(fluid('butadiene') * 100)
        .fluidOutputs(fluid('cyclooctadiene') * 50)
        .duration(10)
        .EUt(Globals.voltAmps[3])
        .buildAndRegister()

//ETHENONE

CSTR.recipeBuilder()
        .fluidInputs(fluid('ethanol') * 150)
        .fluidInputs(fluid('phosphoryl_chloride') * 50)
        .fluidOutputs(fluid('acidic_triethyl_phosphate') * 200)
        .duration(3)
        .EUt(120)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustSodiumHydroxide') * 9)
        .fluidInputs(fluid('acidic_triethyl_phosphate') * 4000)
        .fluidOutputs(fluid('triethyl_phosphate') * 1000)
        .fluidOutputs(fluid('salt_water') * 3000)
        .duration(100)
        .EUt(120)
        .buildAndRegister()

REACTION_FURNACE.recipeBuilder()
        .notConsumable(fluid('ammonia') * 1000)
        .notConsumable(fluid('triethyl_phosphate') * 1000)
        .fluidInputs(fluid('acetic_acid') * 1000)
        .fluidOutputs(fluid('ethenone') * 1000)
        .fluidOutputs(fluid('water') * 1000)
        .duration(40)
        .EUt(480)
        .buildAndRegister()

//ACETYLACETONE

CSTR.recipeBuilder()
        .fluidInputs(fluid('ethenone') * 50)
        .fluidInputs(fluid('acetone') * 50)
        .fluidOutputs(fluid('isopropenyl_acetate') * 50)
        .duration(20)
        .EUt(120)
        .buildAndRegister()

PYROLYSE.recipeBuilder()
        .fluidInputs(fluid('isopropenyl_acetate') * 1000)
        .fluidOutputs(fluid('acetylacetone') * 1000)
        .duration(400)
        .EUt(120)
        .buildAndRegister()

//SHELL HIGHER OLEFIN PROCESS

BR.recipeBuilder()
        .fluidInputs(fluid('ethylene') * 4000)
        .notConsumable(fluid('shell_higher_olefin_catalyst_solution') * 1000)
        .fluidOutputs(fluid('alpha_olefin_mixture') * 1000)
        .duration(125)
        .EUt(Globals.voltAmps[3])
        .buildAndRegister()

DISTILLATION_TOWER.recipeBuilder() // SCHULZ-FLORY, p = 0.82, ROUNDED TO NEAREST 5
        .fluidInputs(fluid('alpha_olefin_mixture') * 1000)
        .fluidOutputs(fluid('one_tetracosene') * 20)
        .fluidOutputs(fluid('one_docosene') * 30)
        .fluidOutputs(fluid('one_icosene') * 35)
        .fluidOutputs(fluid('one_octadecene') * 40)
        .fluidOutputs(fluid('one_hexadecene') * 50)
        .fluidOutputs(fluid('one_tetradecene') * 60)
        .fluidOutputs(fluid('one_dodecene') * 75)
        .fluidOutputs(fluid('one_decene') * 90)
        .fluidOutputs(fluid('one_octene') * 130)
        .fluidOutputs(fluid('one_hexene') * 110)
        .fluidOutputs(fluid('one_butene') * 160)
        .fluidOutputs(fluid('ethylene') * 200)
        .duration(125)
        .EUt(Globals.voltAmps[3])
        .buildAndRegister()

//OXALIC ACID
LCR.recipeBuilder()
        .fluidInputs(fluid('ethylene_glycol') * 1000)
        .fluidInputs(fluid('oxygen') * 4000)
        .notConsumable(fluid('nitric_acid') * 800)
        .notConsumable(ore('dustVanadiumPentoxide') * 7)
        .notConsumable(ore('dustIronIiiChloride') * 4)
        .outputs(metaitem('dustOxalicAcid'))
        .fluidOutputs(fluid('water') * 2000)
        .duration(120)
        .EUt(Globals.voltAmps[3])
        .buildAndRegister()

//ANILINE
CSTR.recipeBuilder()
        .fluidInputs(fluid('benzene') * 50)
        .fluidInputs(fluid('nitration_mixture') * 100)
        .fluidOutputs(fluid('acidic_nitrobenzene_mixture') * 150)
        .duration(5)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

PHASE_SEPARATOR.recipeBuilder()
        .fluidInputs(fluid('acidic_nitrobenzene_mixture') * 3000)
        .fluidOutputs(fluid('nitrobenzene') * 1000)
        .fluidOutputs(fluid('diluted_sulfuric_acid') * 2000)
        .duration(50)
        .buildAndRegister()

FBR.recipeBuilder()
        .notConsumable(ore('catalystBedPalladium'))
        .fluidInputs(fluid('nitrobenzene') * 50)
        .fluidInputs(fluid('hot_hp_hydrogen') * 150)
        .fluidOutputs(fluid('gtfo_aniline') * 50)
        .fluidOutputs(fluid('water') * 100)
        .duration(100)
        .EUt(Globals.voltAmps[2])
        .buildAndRegister()

// Heated water
FLUID_HEATER.recipeBuilder()
        .circuitMeta(2)
        .fluidInputs(fluid('distilled_water') * 1000)
        .fluidOutputs(fluid('gtfo_heated_water') * 1000)
        .duration(20)
        .EUt(Globals.voltAmps[1])
        .buildAndRegister()

// Soda Ash Solution
BCR.recipeBuilder()
        .fluidInputs(fluid('sodium_hydroxide_solution') * 100)
        .fluidInputs(fluid('carbon_dioxide') * 50)
        .fluidOutputs(fluid('diluted_sodium_carbonate_solution') * 150)
        .duration(4)
        .EUt(30)
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('diluted_sodium_carbonate_solution') * 3000)
        .outputs(metaitem('dustSodaAsh') * 6)
        .fluidOutputs(fluid('water') * 3000)
        .duration(120)
        .EUt(30)
        .buildAndRegister()

// Pd/C

BR.recipeBuilder()
        .inputs(ore('dustPalladiumChloride'))
        .inputs(ore('dustActivatedCarbon') * 4)
        .fluidInputs(fluid('demineralized_water') * 250)
        .fluidInputs(fluid('formaldehyde') * 50)
        .outputs(metaitem('dustPalladiumOnCarbon') * 5)
        .duration(120)
        .EUt(30)
        .buildAndRegister()

//Acetone from dry distillation

BR.recipeBuilder()
        .inputs(ore('dustCalcite') * 5) // CaCO3 + 2 CH3COOH --> Ca(CH3COO)2 + H2O + CO2
        .fluidInputs(fluid('acetic_acid') * 2000)
        .fluidOutputs(fluid('dissolved_calcium_acetate') * 1000)
        .fluidOutputs(fluid('carbon_dioxide') * 1000)
        .duration(1800)
        .EUt(16)
        .buildAndRegister()

BR.recipeBuilder()
        .inputs(ore('dustQuicklime') * 2) // CaO + 2 CH3COOH --> Ca(CH3COO)2 + H2O
        .fluidInputs(fluid('acetic_acid') * 2000)
        .fluidOutputs(fluid('dissolved_calcium_acetate') * 1000)
        .duration(1800)
        .EUt(16)
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('dissolved_calcium_acetate') * 1000)
        .outputs(metaitem('dustCalciumAcetate') * 15)
        .fluidOutputs(fluid('water') * 1000)
        .duration(20)
        .EUt(16)
        .buildAndRegister()

ROASTER.recipeBuilder()
        .inputs(ore('dustCalciumAcetate') * 15)
        .outputs(metaitem('dustQuicklime') * 2)
        .fluidOutputs(fluid('carbon_dioxide') * 1000)
        .fluidOutputs(fluid('acetone') * 1000)
        .duration(600)
        .EUt(30)
        .buildAndRegister()

// Ethylbenzene

CSTR.recipeBuilder()
        .fluidInputs(fluid('benzene') * 50)
        .fluidInputs(fluid('ethylene') * 50)
        .notConsumable(fluid('sulfuric_acid') * 50)
        .fluidOutputs(fluid('ethylbenzene') * 50)
        .duration(5)
        .EUt(120)
        .buildAndRegister()

// Nitromethane

CSTR.recipeBuilder()
.fluidInputs(fluid('propane') * 50)
.fluidInputs(fluid('nitric_acid') * 150)
.fluidOutputs(fluid('diluted_nitromethane') * 200)
.fluidOutputs(fluid('nitric_oxide') * 100)
.duration(5)
.EUt(120)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('diluted_nitromethane') * 4000)
.fluidOutputs(fluid('water') * 3000)
.fluidOutputs(fluid('nitromethane') * 1000)
.duration(200)
.EUt(120)
.buildAndRegister()

// Di-tert-butyl peroxide

CSTR.recipeBuilder()
.fluidInputs(fluid('isobutane') * 50)
.fluidInputs(fluid('oxygen') * 100)
.fluidOutputs(fluid('tert_butyl_hydroperoxide') * 50)
.duration(5)
.EUt(120)
.buildAndRegister()

TBR.recipeBuilder()
.fluidInputs(fluid('tert_butyl_hydroperoxide') * 50)
.fluidInputs(fluid('tert_butyl_alcohol') * 50)
.notConsumable(metaitem('dustMolecularSieve'))
.fluidOutputs(fluid('diluted_di_tert_butyl_peroxide') * 100)
.duration(5)
.EUt(120)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('diluted_di_tert_butyl_peroxide') * 2000)
.fluidOutputs(fluid('water') * 1000)
.fluidOutputs(fluid('di_tert_butyl_peroxide') * 1000)
.duration(200)
.EUt(120)
.buildAndRegister()

// Dimethylacetamide

CSTR.recipeBuilder()
.fluidInputs(fluid('dimethylamine') * 50)
.fluidInputs(fluid('acetic_acid') * 50)
.fluidOutputs(fluid('dimethylacetamide_solution') * 100)
.duration(5)
.EUt(30)
.buildAndRegister()

DISTILLATION_TOWER.recipeBuilder()
.fluidInputs(fluid('dimethylacetamide_solution') * 2000)
.fluidOutputs(fluid('dimethylacetamide') * 1000)
.fluidOutputs(fluid('water') * 1000)
.duration(200)
.EUt(240)
.buildAndRegister()

// gamma-Butyrolactone

CSTR.recipeBuilder()
    .fluidInputs(fluid('acetylene') * 50)
    .fluidInputs(fluid('formaldehyde') * 100)
    .fluidOutputs(fluid('butanediol') * 50)
    .EUt(120)
    .duration(4)
    .buildAndRegister()

FBR.recipeBuilder()
    .fluidInputs(fluid('butanediol') * 50)
    .notConsumable(ore('catalystBedCopper'))
    .fluidOutputs(fluid('gamma_butyrolactone') * 50)
    .fluidOutputs(fluid('hydrogen') * 200)
    .EUt(120)
    .duration(4)
    .buildAndRegister()

// Hydrogen Iodide

BR.recipeBuilder()
.fluidInputs(fluid('iodine') * 576)
.fluidInputs(fluid('hydrazine') * 1000)
.fluidOutputs(fluid('hydrogen_iodide') * 4000)
.fluidOutputs(fluid('nitrogen') * 2000)
.duration(80)
.EUt(30)
.buildAndRegister()

// Early butyraldehyde

BR.recipeBuilder()
        .notConsumable(ore('springCupronickel'))
        .fluidInputs(fluid('gtfo_acetaldehyde') * 2000)
        .fluidInputs(fluid('sodium_hydroxide_solution') * 1000)
        .fluidOutputs(fluid('crotonaldehyde_mixture') * 1000)
        .fluidOutputs(fluid('dense_steam') * 2000)
        .duration(400)
        .EUt(120)
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('crotonaldehyde_mixture') * 1000)
        .outputs(metaitem('dustSodiumHydroxide') * 3)
        .fluidOutputs(fluid('crotonaldehyde') * 1000)
        .duration(20)
        .EUt(30)
        .buildAndRegister()

FBR.recipeBuilder()
        .notConsumable(ore('catalystBedCopper'))
        .fluidInputs(fluid('crotonaldehyde') * 50)
        .fluidInputs(fluid('hydrogen') * 100)
        .fluidOutputs(fluid('butyraldehyde') * 50)
        .duration(20)
        .EUt(120)
        .buildAndRegister()

//1-butene from n-butanol

CSTR.recipeBuilder()
        .fluidInputs(fluid('hot_sulfuric_acid') * 50)
        .fluidInputs(fluid('n_butanol') * 50)
        .fluidOutputs(fluid('one_butene') * 50)
        .fluidOutputs(fluid('diluted_sulfuric_acid') * 100)
        .duration(5)
        .EUt(30)
        .buildAndRegister()

// NaHCO3 solutions

MIXER.recipeBuilder()
        .circuitMeta(1)
        .fluidInputs(fluid('water') * 1000)
        .inputs(ore('dustSodiumBicarbonate') * 6)
        .fluidOutputs(fluid('sodium_bicarbonate_solution') * 1000)
        .EUt(30)
        .duration(80)
        .buildAndRegister()

MIXER.recipeBuilder()
        .circuitMeta(2)
        .fluidInputs(fluid('water') * 1000)
        .inputs(ore('dustSodiumBicarbonate'))
        .fluidOutputs(fluid('gtfo_baking_soda_solution') * 1000)
        .EUt(30)
        .duration(80)
        .buildAndRegister()

// NaF Chemistry

MIXER.recipeBuilder()
        .inputs(ore('dustSodiumFluoride') * 2)
        .fluidInputs(fluid('water') * 1000)
        .fluidOutputs(fluid('sodium_fluoride_solution') * 1000)
        .duration(20)
        .EUt(30)
        .buildAndRegister()

BCR.recipeBuilder()
        .fluidInputs(fluid('sodium_fluoride_solution') * 50)
        .fluidInputs(fluid('hydrogen_chloride') * 50)
        .fluidOutputs(fluid('salty_hydrofluoric_acid') * 50)
        .duration(2)
        .EUt(30)
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('salty_hydrofluoric_acid') * 1000)
        .outputs(metaitem('dustSalt') * 2)
        .fluidOutputs(fluid('hydrofluoric_acid') * 1000)
        .duration(20)
        .EUt(30)
        .buildAndRegister()

// Calcium hydroxide slurry

MIXER.recipeBuilder()
        .inputs(ore('dustCalciumHydroxide') * 5)
        .fluidInputs(fluid('water') * 1000)
        .fluidOutputs(fluid('calcium_hydroxide_slurry') * 1000)
        .EUt(30)
        .duration(100)
        .buildAndRegister()

MIXER.recipeBuilder()
        .inputs(ore('dustQuicklime') * 2)
        .circuitMeta(2)
        .fluidInputs(fluid('water') * 2000)
        .fluidOutputs(fluid('calcium_hydroxide_slurry') * 1000)
        .EUt(30)
        .duration(120)
        .buildAndRegister()

// Zinc chloride soln.

MIXER.recipeBuilder()
        .fluidInputs(fluid('water') * 1000)
        .inputs(ore('dustZincChloride') * 3)
        .fluidOutputs(fluid('zinc_chloride_solution') * 1000)
        .EUt(16)
        .duration(80)
        .buildAndRegister()

DISTILLERY.recipeBuilder()
        .fluidInputs(fluid('diluted_sodium_sulfate_solution') * 2000)
        .fluidOutputs(fluid('water') * 2000)
        .outputs(metaitem('dustSodiumSulfate') * 7)
        .duration(30)
        .EUt(200)
        .buildAndRegister()

// Dense steam processing

FLUID_HEATER.recipeBuilder()
        .circuitMeta(3)
        .fluidInputs(fluid('water') * 1000)
        .fluidOutputs(fluid('dense_steam') * 1000)
        .duration(80)
        .EUt(30)
        .buildAndRegister()

CONDENSER.recipeBuilder()
        .fluidInputs(fluid('dense_steam') * 1000)
        .fluidOutputs(fluid('water') * 1000)
        .duration(5)
        .buildAndRegister()

// Nitration Mixture * 2000
mods.gregtech.mixer.removeByInput(2, null, [fluid('nitric_acid') * 1000, fluid('sulfuric_acid') * 1000])
mods.gregtech.blender.removeByInput(2, null, [fluid('nitric_acid') * 1000, fluid('sulfuric_acid') * 1000])

MIXER.recipeBuilder()
        .fluidInputs(fluid('nitric_acid') * 1000)
        .fluidInputs(fluid('sulfuric_acid') * 1000)
        .fluidOutputs(fluid('nitration_mixture') * 2000)
        .EUt(30)
        .duration(160)
        .buildAndRegister()
