/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.clientinfo;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mcjty.lib.network.NetworkTools;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelType;
import net.minecraft.util.math.BlockPos;

public class ControllerChannelClientInfo {
    @Nonnull
    private final String channelName;
    @Nonnull
    private final String publishedName;
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final IChannelType channelType;
    private final boolean remote;
    private final int index;

    public ControllerChannelClientInfo(@Nonnull String channelName, @Nonnull String publishedName, @Nonnull BlockPos pos, @Nonnull IChannelType channelType, boolean remote, int index) {
        this.channelName = channelName;
        this.publishedName = publishedName;
        this.pos = pos;
        this.channelType = channelType;
        this.remote = remote;
        this.index = index;
    }

    public ControllerChannelClientInfo(@Nonnull ByteBuf buf) {
        this.channelName = NetworkTools.readStringUTF8((ByteBuf)buf);
        this.publishedName = NetworkTools.readStringUTF8((ByteBuf)buf);
        String id = NetworkTools.readString((ByteBuf)buf);
        IChannelType t = XNet.xNetApi.findType(id);
        if (t == null) {
            throw new RuntimeException("Bad type: " + id);
        }
        this.channelType = t;
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.remote = buf.readBoolean();
        this.index = buf.readInt();
    }

    public void writeToNBT(@Nonnull ByteBuf buf) {
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.channelName);
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.publishedName);
        NetworkTools.writeString((ByteBuf)buf, (String)this.channelType.getID());
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeBoolean(this.remote);
        buf.writeInt(this.index);
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public String getPublishedName() {
        return this.publishedName;
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nonnull
    public IChannelType getChannelType() {
        return this.channelType;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isRemote() {
        return this.remote;
    }
}

