/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.router;

import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.blocks.router.TileEntityRouter;
import mcjty.xnet.clientinfo.ControllerChannelClientInfo;
import mcjty.xnet.network.PacketGetLocalChannelsRouter;
import mcjty.xnet.network.PacketGetRemoteChannelsRouter;
import mcjty.xnet.network.XNetMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiRouter
extends GenericGuiContainer<TileEntityRouter> {
    private WidgetList localChannelList;
    private WidgetList remoteChannelList;
    public static List<ControllerChannelClientInfo> fromServer_localChannels = null;
    public static List<ControllerChannelClientInfo> fromServer_remoteChannels = null;
    private boolean needsRefresh = true;
    private int listDirty;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");

    public GuiRouter(TileEntityRouter router, GenericContainer container) {
        super((ModBase)XNet.instance, XNetMessages.INSTANCE, (GenericTileEntity)router, (Container)container, 0, "router");
    }

    public void func_73866_w_() {
        this.window = new Window((GuiScreen)this, this.tileEntity, XNetMessages.INSTANCE, new ResourceLocation("xnet", "gui/router.gui"));
        super.func_73866_w_();
        this.localChannelList = (WidgetList)this.window.findChild("localchannels");
        this.remoteChannelList = (WidgetList)this.window.findChild("remotechannels");
        this.refresh();
        this.listDirty = 0;
    }

    private void updatePublish(BlockPos pos, int index, String name) {
        this.sendServerCommand(XNetMessages.INSTANCE, "router.updateName", TypedMap.builder().put(TileEntityRouter.PARAM_POS, (Object)pos).put(TileEntityRouter.PARAM_CHANNEL, (Object)index).put(TileEntityRouter.PARAM_NAME, (Object)name).build());
    }

    private void refresh() {
        fromServer_localChannels = null;
        fromServer_remoteChannels = null;
        this.needsRefresh = true;
        this.listDirty = 3;
        this.requestListsIfNeeded();
    }

    private boolean listsReady() {
        return fromServer_localChannels != null && fromServer_remoteChannels != null;
    }

    private void populateList() {
        if (!this.listsReady()) {
            return;
        }
        if (!this.needsRefresh) {
            return;
        }
        this.needsRefresh = false;
        this.localChannelList.removeChildren();
        this.localChannelList.setRowheight(40);
        int sel = this.localChannelList.getSelected();
        for (ControllerChannelClientInfo channel : fromServer_localChannels) {
            this.localChannelList.addChild((Widget)this.makeChannelLine(channel, true));
        }
        this.localChannelList.setSelected(sel);
        this.remoteChannelList.removeChildren();
        this.remoteChannelList.setRowheight(40);
        sel = this.remoteChannelList.getSelected();
        for (ControllerChannelClientInfo channel : fromServer_remoteChannels) {
            this.remoteChannelList.addChild((Widget)this.makeChannelLine(channel, false));
        }
        this.remoteChannelList.setSelected(sel);
    }

    private Panel makeChannelLine(ControllerChannelClientInfo channel, boolean local) {
        String name = channel.getChannelName();
        String publishedName = channel.getPublishedName();
        BlockPos controllerPos = channel.getPos();
        IChannelType type = channel.getChannelType();
        int index = channel.getIndex();
        Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setDesiredHeight(30);
        Panel panel1 = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 160, 13));
        int labelColor = -14531414;
        if (channel.isRemote()) {
            labelColor = -5631693;
        }
        panel1.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("Ch")).setColor(labelColor));
        panel1.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(name));
        panel1.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText(">")).setColor(labelColor));
        if (channel.isRemote()) {
            panel1.addChild((Widget)((ImageLabel)new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 48, 80)).setDesiredWidth(16));
        }
        if (local) {
            TextField pubName = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setText(publishedName).setDesiredWidth(50)).setDesiredHeight(13)).addTextEvent((parent, newText) -> this.updatePublish(controllerPos, index, newText));
            panel1.addChild((Widget)pubName);
        } else {
            panel1.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText(publishedName)).setColor(-13369600));
        }
        Panel panel2 = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 13, 160, 13));
        panel2.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("Pos")).setColor(labelColor));
        panel2.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(BlockPosTools.toString((BlockPos)controllerPos)));
        Panel panel3 = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 26, 160, 13));
        panel3.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("Index")).setColor(labelColor));
        panel3.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(index + " (" + type.getName() + ")"));
        ((Panel)((Panel)panel.addChild((Widget)panel1)).addChild((Widget)panel2)).addChild((Widget)panel3);
        return panel;
    }

    private void requestListsIfNeeded() {
        if (fromServer_localChannels != null && fromServer_remoteChannels != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            XNetMessages.INSTANCE.sendToServer((IMessage)new PacketGetLocalChannelsRouter(((TileEntityRouter)this.tileEntity).func_174877_v()));
            XNetMessages.INSTANCE.sendToServer((IMessage)new PacketGetRemoteChannelsRouter(((TileEntityRouter)this.tileEntity).func_174877_v()));
            this.listDirty = 10;
        }
    }

    protected void func_146976_a(float v, int x1, int x2) {
        this.requestListsIfNeeded();
        this.populateList();
        this.drawWindow();
    }
}

