/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.fluids;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.FluidTools;
import mcjty.lib.varia.ItemStackTools;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.config.ConfigSetup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    public static final String TAG_RATE = "rate";
    public static final String TAG_MINMAX = "minmax";
    public static final String TAG_PRIORITY = "priority";
    public static final String TAG_FILTER = "flt";
    public static final String TAG_SPEED = "speed";
    private FluidMode fluidMode = FluidMode.INS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer rate = null;
    @Nullable
    private Integer minmax = null;
    private int speed = 2;
    private ItemStack filter = ItemStack.field_190927_a;
    private static Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "flt"});
    private static Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "flt", "speed"});

    public FluidConnectorSettings(@Nonnull EnumFacing side) {
        super(side);
    }

    public FluidMode getFluidMode() {
        return this.fluidMode;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nonnull
    public Integer getRate() {
        return this.rate == null ? ConfigSetup.maxFluidRateNormal.get() : this.rate.intValue();
    }

    @Nullable
    public Integer getMinmax() {
        return this.minmax;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.fluidMode) {
            case INS: {
                return new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            }
            case EXT: {
                return new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
        int maxrate;
        String[] speeds;
        this.advanced = gui.isAdvanced();
        if (this.advanced) {
            speeds = new String[]{"10", "20", "60", "100", "200"};
            maxrate = ConfigSetup.maxFluidRateAdvanced.get();
        } else {
            speeds = new String[]{"20", "60", "100", "200"};
            maxrate = ConfigSetup.maxFluidRateNormal.get();
        }
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_MODE, "Insert or extract mode", this.fluidMode, FluidMode.values()).choices(TAG_SPEED, "Number of ticks for each operation", Integer.toString(this.speed * 10), speeds).nl().label("Pri").integer(TAG_PRIORITY, "Insertion priority", this.priority, 36).nl().label("Rate").integer(TAG_RATE, this.fluidMode == FluidMode.EXT ? "Fluid extraction rate|(max " + maxrate + "mb)" : "Fluid insertion rate|(max " + maxrate + "mb)", this.rate, 36, maxrate).shift(10).label(this.fluidMode == FluidMode.EXT ? "Min" : "Max").integer(TAG_MINMAX, this.fluidMode == FluidMode.EXT ? "Keep this amount of|fluid in tank" : "Disable insertion if|fluid level is too high", this.minmax, 36).nl().label("Filter").ghostSlot(TAG_FILTER, this.filter);
    }

    @Override
    public boolean isEnabled(String tag) {
        if (this.fluidMode == FluidMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return false;
        }
        return EXTRACT_TAGS.contains(tag);
    }

    @Nullable
    public FluidStack getMatcher() {
        if (!this.filter.func_190926_b()) {
            return FluidTools.convertBucketToFluid((ItemStack)this.filter);
        }
        return null;
    }

    @Override
    public void update(Map<String, Object> data) {
        super.update(data);
        this.fluidMode = FluidMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.rate = (Integer)data.get(TAG_RATE);
        this.minmax = (Integer)data.get(TAG_MINMAX);
        this.priority = (Integer)data.get(TAG_PRIORITY);
        this.speed = Integer.parseInt((String)data.get(TAG_SPEED)) / 10;
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.filter = (ItemStack)data.get(TAG_FILTER);
        if (this.filter == null) {
            this.filter = ItemStack.field_190927_a;
        }
    }

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        FluidConnectorSettings.setEnumSafe(object, "fluidmode", this.fluidMode);
        FluidConnectorSettings.setIntegerSafe(object, TAG_PRIORITY, this.priority);
        FluidConnectorSettings.setIntegerSafe(object, TAG_RATE, this.rate);
        FluidConnectorSettings.setIntegerSafe(object, TAG_MINMAX, this.minmax);
        FluidConnectorSettings.setIntegerSafe(object, TAG_SPEED, this.speed);
        if (!this.filter.func_190926_b()) {
            object.add("filter", (JsonElement)ItemStackTools.itemStackToJson((ItemStack)this.filter));
        }
        if (this.rate != null && this.rate > ConfigSetup.maxFluidRateNormal.get()) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    @Override
    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.fluidMode = FluidConnectorSettings.getEnumSafe(object, "fluidmode", EnumStringTranslators::getFluidMode);
        this.priority = FluidConnectorSettings.getIntegerSafe(object, TAG_PRIORITY);
        this.rate = FluidConnectorSettings.getIntegerSafe(object, TAG_RATE);
        this.minmax = FluidConnectorSettings.getIntegerSafe(object, TAG_MINMAX);
        this.speed = FluidConnectorSettings.getIntegerNotNull(object, TAG_SPEED);
        this.filter = object.has("filter") ? ItemStackTools.jsonToItemStack((JsonObject)object.get("filter").getAsJsonObject()) : ItemStack.field_190927_a;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.fluidMode = FluidMode.values()[tag.func_74771_c("fluidMode")];
        this.priority = tag.func_74764_b(TAG_PRIORITY) ? Integer.valueOf(tag.func_74762_e(TAG_PRIORITY)) : null;
        this.rate = tag.func_74764_b(TAG_RATE) ? Integer.valueOf(tag.func_74762_e(TAG_RATE)) : null;
        this.minmax = tag.func_74764_b(TAG_MINMAX) ? Integer.valueOf(tag.func_74762_e(TAG_MINMAX)) : null;
        this.speed = tag.func_74762_e(TAG_SPEED);
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (tag.func_74764_b("filter")) {
            NBTTagCompound itemTag = tag.func_74775_l("filter");
            this.filter = new ItemStack(itemTag);
        } else {
            this.filter = ItemStack.field_190927_a;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("fluidMode", (byte)this.fluidMode.ordinal());
        if (this.priority != null) {
            tag.func_74768_a(TAG_PRIORITY, this.priority.intValue());
        }
        if (this.rate != null) {
            tag.func_74768_a(TAG_RATE, this.rate.intValue());
        }
        if (this.minmax != null) {
            tag.func_74768_a(TAG_MINMAX, this.minmax.intValue());
        }
        tag.func_74768_a(TAG_SPEED, this.speed);
        if (!this.filter.func_190926_b()) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.filter.func_77955_b(itemTag);
            tag.func_74782_a("filter", (NBTBase)itemTag);
        }
    }

    public static enum FluidMode {
        INS,
        EXT;

    }
}

