/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.message;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateContainer;
import git.jbredwards.fluidlogged_api.api.network.IClientMessageHandler;
import git.jbredwards.fluidlogged_api.api.network.message.AbstractMessage;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.capability.FluidStateCapabilityVanilla;
import git.jbredwards.fluidlogged_api.mod.common.capability.util.FluidStateLayer;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public final class MessageSyncFluidStates
extends AbstractMessage {
    @Nonnull
    public List<Pair<Character, Integer>> data = new LinkedList<Pair<Character, Integer>>();
    public int x;
    public int y;
    public int z;

    public MessageSyncFluidStates() {
    }

    public MessageSyncFluidStates(@Nonnull Chunk chunk, @Nonnull IFluidStateCapability cap) {
        this(chunk.field_76635_g, 0, chunk.field_76647_h, cap);
    }

    public MessageSyncFluidStates(int chunkXIn, int chunkYIn, int chunkZIn, @Nonnull IFluidStateCapability cap) {
        cap.getContainer(chunkXIn, chunkYIn, chunkZIn).forEach((pos, fluidState) -> this.data.add((Pair<Character, Integer>)Pair.of((Object)pos, (Object)fluidState.serialize())));
        this.x = chunkXIn;
        this.y = chunkYIn;
        this.z = chunkZIn;
        this.isValid = true;
    }

    @Override
    public void read(@Nonnull PacketBuffer buf) {
        this.x = buf.func_150792_a();
        this.y = buf.func_150792_a();
        this.z = buf.func_150792_a();
        int size = buf.func_150792_a();
        for (int i = 0; i < size; ++i) {
            this.data.add((Pair<Character, Integer>)Pair.of((Object)Character.valueOf(buf.readChar()), (Object)buf.func_150792_a()));
        }
    }

    @Override
    public void write(@Nonnull PacketBuffer buf) {
        buf.func_150787_b(this.x);
        buf.func_150787_b(this.y);
        buf.func_150787_b(this.z);
        buf.func_150787_b(this.data.size());
        this.data.forEach(entry -> {
            buf.writeChar((int)((Character)entry.getKey()).charValue());
            buf.func_150787_b(((Integer)entry.getValue()).intValue());
        });
    }

    public static enum Handler implements IClientMessageHandler<MessageSyncFluidStates>
    {
        INSTANCE;


        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleMessage(@Nonnull MessageSyncFluidStates message) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)world.func_72964_e(message.x, message.z));
            if (cap != null) {
                IFluidStateContainer container = cap.getContainer(message.x, message.y, message.z);
                LinkedList removed = new LinkedList();
                container.forEach((pos, fluidState) -> removed.add(pos));
                container.clearFluidStates();
                if (container instanceof FluidStateCapabilityVanilla) {
                    int[] size = new int[]{0};
                    message.data.forEach(entry -> {
                        int y = ((Character)entry.getLeft()).charValue() >> 8;
                        if (y > size[0]) {
                            size[0] = y;
                        }
                    });
                    ((FluidStateCapabilityVanilla)container).layers = new FluidStateLayer[size[0] + 1];
                }
                message.data.forEach(arg_0 -> Handler.lambda$handleMessage$2(container, (World)world, arg_0));
                removed.forEach(arg_0 -> Handler.lambda$handleMessage$3(container, (World)world, arg_0));
            }
        }

        private static /* synthetic */ void lambda$handleMessage$3(IFluidStateContainer container, World world, Character serializedPos) {
            if (!container.hasFluidState(serializedPos.charValue())) {
                BlockPos pos = container.deserializePos(serializedPos.charValue());
                world.func_175704_b(pos, pos);
                FluidloggedUtils.relightFluidBlock(world, pos, FluidState.EMPTY);
            }
        }

        private static /* synthetic */ void lambda$handleMessage$2(IFluidStateContainer container, World world, Pair entry) {
            BlockPos pos = container.deserializePos(((Character)entry.getKey()).charValue());
            FluidState fluidState = FluidState.deserialize((Integer)entry.getValue());
            container.setFluidState(((Character)entry.getKey()).charValue(), fluidState);
            world.func_175704_b(pos, pos);
            FluidloggedUtils.relightFluidBlock(world, pos, fluidState);
        }
    }
}

