/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.capability;

import git.jbredwards.fluidlogged_api.api.capability.CapabilityProvider;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateContainer;
import git.jbredwards.fluidlogged_api.api.network.FluidloggedAPINetworkHandler;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.mod.common.capability.util.FluidStateLayer;
import git.jbredwards.fluidlogged_api.mod.common.message.MessageSyncFluidStates;
import it.unimi.dsi.fastutil.chars.CharLinkedOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FluidStateCapabilityVanilla
implements IFluidStateCapability,
IFluidStateContainer {
    protected final CharLinkedOpenHashSet indexedPositions = new CharLinkedOpenHashSet();
    protected final int chunkX;
    protected final int chunkZ;
    @Nonnull
    public FluidStateLayer[] layers = new FluidStateLayer[0];

    public FluidStateCapabilityVanilla(int chunkXIn, int chunkZIn) {
        this.chunkX = chunkXIn;
        this.chunkZ = chunkZIn;
    }

    @SubscribeEvent
    static void attach(@Nonnull AttachCapabilitiesEvent<Chunk> event) {
        Chunk chunk = (Chunk)event.getObject();
        event.addCapability(CAPABILITY_ID, new CapabilityProvider<FluidStateCapabilityVanilla>(CAPABILITY, new FluidStateCapabilityVanilla(chunk.field_76635_g, chunk.field_76647_h)));
    }

    @SubscribeEvent
    static void sync(@Nonnull ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getChunkInstance();
        IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)chunk);
        if (cap != null) {
            FluidloggedAPINetworkHandler.INSTANCE.sendTo((IMessage)new MessageSyncFluidStates(chunk, cap), event.getPlayer());
        }
    }

    @Override
    public void forEach(@Nonnull BiConsumer<Character, FluidState> action) {
        CharListIterator charListIterator = this.indexedPositions.iterator();
        while (charListIterator.hasNext()) {
            char indexedPosition = ((Character)charListIterator.next()).charValue();
            action.accept(Character.valueOf(indexedPosition), this.layers[indexedPosition >> 8].data[indexedPosition & 0xFF]);
        }
    }

    @Override
    public boolean hasFluidState(char serializedPos) {
        int y = serializedPos >> 8;
        if (this.layers.length <= y) {
            return false;
        }
        FluidStateLayer layer = this.layers[y];
        if (layer == null) {
            return false;
        }
        int xz = serializedPos & 0xFF;
        return layer.data.length > xz && layer.data[xz] != null;
    }

    @Override
    public char serializePos(@Nonnull BlockPos pos) {
        return (char)(pos.func_177956_o() << 8 | (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF);
    }

    @Override
    @Nonnull
    public BlockPos deserializePos(char serializedPos) {
        int x = this.chunkX << 4 | serializedPos & 0xF;
        int y = serializedPos >> 8;
        int z = this.chunkZ << 4 | serializedPos >> 4 & 0xF;
        return new BlockPos(x, y, z);
    }

    @Override
    public void clearFluidStates() {
        this.layers = new FluidStateLayer[0];
        this.indexedPositions.trim();
    }

    @Override
    public void setFluidState(@Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        this.setFluidState(this.serializePos(pos), fluidState);
    }

    @Override
    public void setFluidState(char serializedPos, @Nonnull FluidState fluidState) {
        FluidStateLayer layer;
        boolean isEmpty = fluidState.isEmpty();
        int y = serializedPos >> 8;
        if (this.layers.length <= y) {
            if (isEmpty) {
                return;
            }
            FluidStateLayer[] newLayers = new FluidStateLayer[y + 1];
            System.arraycopy(this.layers, 0, newLayers, 0, this.layers.length);
            this.layers = newLayers;
        }
        if ((layer = this.layers[y]) == null) {
            if (isEmpty) {
                return;
            }
            this.layers[y] = layer = new FluidStateLayer();
            layer.data = new FluidState[256];
        }
        if (isEmpty) {
            if (this.indexedPositions.rem(serializedPos)) {
                layer.tracker = (byte)(layer.tracker - 1);
                if (layer.tracker != -128) {
                    layer.data[serializedPos & 0xFF] = null;
                } else if (this.indexedPositions.isEmpty()) {
                    this.layers = new FluidStateLayer[0];
                } else if (this.layers.length - 1 == y) {
                    int newMaxY;
                    for (newMaxY = y; newMaxY > 0 && this.layers[newMaxY] == null; --newMaxY) {
                    }
                    FluidStateLayer[] newLayers = new FluidStateLayer[newMaxY];
                    System.arraycopy(this.layers, 0, newLayers, 0, newMaxY);
                    this.layers = newLayers;
                } else {
                    this.layers[y] = null;
                }
            }
        } else {
            if (this.indexedPositions.add(serializedPos)) {
                layer.tracker = (byte)(layer.tracker + 1);
            }
            layer.data[serializedPos & 0xFF] = fluidState;
        }
    }

    @Override
    @Nonnull
    public FluidState getFluidState(@Nonnull BlockPos pos, @Nonnull FluidState fallback) {
        return this.getFluidState(this.serializePos(pos), fallback);
    }

    @Override
    @Nonnull
    public FluidState getFluidState(char serializedPos, @Nonnull FluidState fallback) {
        return this.hasFluidState(serializedPos) ? this.layers[serializedPos >> 8].data[serializedPos & 0xFF] : fallback;
    }

    @Override
    @Nonnull
    public IFluidStateContainer getContainer(@Nonnull BlockPos pos) {
        return this;
    }

    @Override
    @Nonnull
    public IFluidStateContainer getContainer(int x, int y, int z) {
        return this;
    }

    @Nonnull
    public NBTTagList serializeNBT() {
        NBTTagList data = new NBTTagList();
        this.forEach((pos, fluidState) -> {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("pos", (int)pos.charValue());
            nbt.func_74778_a("id", String.valueOf(fluidState.getBlock().getRegistryName()));
            data.func_74742_a((NBTBase)nbt);
        });
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deserializeNBT(@Nonnull NBTBase nbtIn) {
        if (nbtIn instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbtIn;
            int version = nbt.func_74762_e("version");
            if (version != 1) throw new IllegalStateException("Could not read chunk data, please update Fluidlogged API to the latest version!");
            nbt.func_150295_c("data", 10).forEach(tagIn -> {
                FluidState state;
                NBTTagCompound tag;
                if (tagIn instanceof NBTTagCompound && (tag = (NBTTagCompound)tagIn).func_150297_b("id", 8) && tag.func_150297_b("pos", 3) && !(state = FluidState.of(Block.func_149684_b((String)tag.func_74779_i("id")))).isEmpty()) {
                    this.setFluidState((char)tag.func_74762_e("pos"), state);
                }
            });
            return;
        } else {
            if (!(nbtIn instanceof NBTTagList)) return;
            for (NBTBase tag : (NBTTagList)nbtIn) {
                FluidState state;
                NBTTagCompound nbt;
                if (!(tag instanceof NBTTagCompound) || !(nbt = (NBTTagCompound)tag).func_150297_b("id", 8) || !nbt.func_150297_b("pos", 4) || (state = FluidState.of(Block.func_149684_b((String)nbt.func_74779_i("id")))).isEmpty()) continue;
                this.setFluidState(BlockPos.func_177969_a((long)nbt.func_74763_f("pos")), state);
            }
        }
    }
}

