/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.asm.impl.IChunkProvider;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public final class PluginChunkCache
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals(obfuscated ? "func_175629_a" : "getLightForExt");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_185916_f" : "useNeighborBrightness")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("useNeighborBrightness", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z"));
            this.removeFrom(instructions, insn, -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/asm/impl/IChunkProvider");
        this.addMethod(classNode, "getChunkFromBlockCoords", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/world/chunk/Chunk;", "getChunkFromChunkCache", "(Lnet/minecraft/util/math/BlockPos;[[Lnet/minecraft/world/chunk/Chunk;II)Lnet/minecraft/world/chunk/Chunk;", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/world/ChunkCache", obfuscated ? "field_72817_c" : "chunkArray", "[[Lnet/minecraft/world/chunk/Chunk;");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/world/ChunkCache", obfuscated ? "field_72818_a" : "chunkX", "I");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/world/ChunkCache", obfuscated ? "field_72816_b" : "chunkZ", "I");
        });
        return true;
    }

    public static final class Hooks {
        @Nullable
        public static Chunk getChunkFromChunkCache(@Nonnull BlockPos pos, @Nonnull Chunk[][] chunkArray, int chunkX, int chunkZ) {
            int x = (pos.func_177958_n() >> 4) - chunkX;
            int z = (pos.func_177952_p() >> 4) - chunkZ;
            return x >= 0 && x < chunkArray.length && z >= 0 && z < chunkArray[x].length ? chunkArray[x][z] : null;
        }

        public static boolean useNeighborBrightness(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            Chunk chunk = IChunkProvider.getChunk(world, pos);
            return chunk != null && Hooks.useNeighborBrightness(chunk.func_177435_g(pos), world, pos, chunk);
        }

        public static boolean useNeighborBrightness(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            if (state.func_185916_f()) {
                FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
                if (fluidState.isEmpty() || fluidState.getState().func_185916_f()) {
                    return true;
                }
                return state.getLightOpacity(world, pos) > fluidState.getState().getLightOpacity(world, pos);
            }
            return false;
        }
    }
}

