/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.ClassNode;

public final class PluginBlockSponge
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_176312_d" : "absorb"), "absorb", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        return false;
    }

    public static final class Hooks {
        public static boolean absorb(@Nonnull World world, @Nonnull BlockPos origin) {
            LinkedList<Pair> queue = new LinkedList<Pair>();
            queue.add(Pair.of((Object)origin, (Object)0));
            int absorbed = 0;
            while (!queue.isEmpty()) {
                Pair entry = (Pair)queue.poll();
                BlockPos pos = (BlockPos)entry.getKey();
                int distance = (Integer)entry.getValue();
                for (EnumFacing facing : EnumFacing.values()) {
                    BlockPos offset = pos.func_177972_a(facing);
                    FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, offset);
                    if (fluidState.isEmpty() || fluidState.getMaterial() != Material.field_151586_h) continue;
                    if (fluidState.isValid()) {
                        fluidState.getFluidBlock().drain(world, offset, true);
                        if (distance < 6) {
                            queue.add(Pair.of((Object)offset, (Object)(distance + 1)));
                        }
                        ++absorbed;
                        continue;
                    }
                    if (!world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2)) continue;
                    world.func_175718_b(2001, offset, Block.func_176210_f((IBlockState)fluidState.getState()));
                    fluidState.getBlock().func_176226_b(world, offset, fluidState.getState(), 0);
                    if (distance < 6) {
                        queue.add(Pair.of((Object)offset, (Object)(distance + 1)));
                    }
                    ++absorbed;
                }
            }
            return absorbed > 0;
        }
    }
}

