/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.network.message;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.network.IClientMessageHandler;
import git.jbredwards.fluidlogged_api.api.network.message.AbstractMessage;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class MessageFluidState
extends AbstractMessage {
    public BlockPos pos;
    public int state;
    public boolean doRenderUpdate;

    public MessageFluidState() {
    }

    public MessageFluidState(@Nonnull BlockPos pos, @Nonnull FluidState state, boolean doRenderUpdate) {
        this.isValid = true;
        this.pos = pos;
        this.state = state.serialize();
        this.doRenderUpdate = doRenderUpdate;
    }

    @Override
    public void read(@Nonnull PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.state = buf.func_150792_a();
        this.doRenderUpdate = buf.readBoolean();
    }

    @Override
    public void write(@Nonnull PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_150787_b(this.state);
        buf.writeBoolean(this.doRenderUpdate);
    }

    public static enum Handler implements IClientMessageHandler<MessageFluidState>
    {
        INSTANCE;


        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleMessage(@Nonnull MessageFluidState message) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)world.func_175726_f(message.pos));
            if (cap != null) {
                FluidState fluidState = FluidState.deserialize(message.state);
                cap.getContainer(message.pos).setFluidState(message.pos, fluidState);
                if (message.doRenderUpdate) {
                    world.func_175704_b(message.pos, message.pos);
                }
                FluidloggedUtils.relightFluidBlock((World)world, message.pos, fluidState);
            }
        }
    }
}

