/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.asm.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

@FunctionalInterface
public interface ICanFluidFlowHandler {
    @Nonnull
    public static final ICanFluidFlowHandler ALWAYS_FLOW = (world, pos, state, side) -> true;
    @Nonnull
    public static final ICanFluidFlowHandler NEVER_FLOW = (world, pos, state, side) -> false;
    @Nonnull
    public static final ICanFluidFlowHandler DEPRECATED_CHECK = (world, pos, state, side) -> !state.isSideSolid(world, pos, side);

    public boolean canFluidFlow(@Nonnull IBlockAccess var1, @Nonnull BlockPos var2, @Nonnull IBlockState var3, @Nonnull EnumFacing var4);

    public static interface Accessor {
        @Nullable
        public ICanFluidFlowHandler getCanFluidFlowOverride();

        @Nullable
        public static ICanFluidFlowHandler getOverride(@Nonnull Block block) {
            return ((Accessor)block).getCanFluidFlowOverride();
        }

        public void setCanFluidFlowOverride(@Nullable ICanFluidFlowHandler var1);

        public static void setOverride(@Nonnull Block block, @Nullable ICanFluidFlowHandler override) {
            ((Accessor)block).setCanFluidFlowOverride(override);
        }
    }
}

