/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.gui.inventory;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.gui.inventory.IInventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.gui.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.network.client.SyncBackpackCapabilityMP;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InventoryTravelersBackpack
implements IInventoryTravelersBackpack {
    private final FluidTank leftTank = new FluidTank(Reference.BASIC_TANK_CAPACITY);
    private final FluidTank rightTank = new FluidTank(Reference.BASIC_TANK_CAPACITY);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> craftingGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final EntityPlayer player;
    private final ItemStack stack;
    private int lastTime;

    public InventoryTravelersBackpack(ItemStack stack, EntityPlayer player) {
        this.player = player;
        this.stack = stack;
        this.loadAllData(this.getTagCompound(stack));
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public NonNullList<ItemStack> getCraftingGridInventory() {
        return this.craftingGrid;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public void saveAllData(NBTTagCompound compound) {
        this.markTankDirty();
        this.saveItems(compound);
        this.saveTime(compound);
    }

    @Override
    public void loadAllData(NBTTagCompound compound) {
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadTime(compound);
    }

    public void func_70296_d() {
        this.saveAllData(this.getTagCompound(this.stack));
    }

    @Override
    public void markTankDirty() {
        this.saveTanks(this.getTagCompound(this.stack));
        this.sendPacket();
    }

    @Override
    public void markTimeDirty() {
        this.saveTime(this.getTagCompound(this.stack));
    }

    @Override
    public void saveTanks(NBTTagCompound compound) {
        compound.func_74782_a("LeftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("RightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void loadTanks(NBTTagCompound compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("LeftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("RightTank"));
    }

    @Override
    public void saveItems(NBTTagCompound compound) {
        ItemStackUtils.saveAllItemsBlackList(compound, this.inventory, this.craftingGrid);
    }

    @Override
    public void loadItems(NBTTagCompound compound) {
        ItemStackUtils.loadAllItems(compound, this.inventory, this.craftingGrid);
    }

    @Override
    public void saveTime(NBTTagCompound compound) {
        compound.func_74768_a("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(NBTTagCompound compound) {
        this.lastTime = compound.func_74762_e("LastTime");
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public boolean hasTileEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public String getColor() {
        return Reference.BACKPACK_NAMES[this.stack.func_77960_j()];
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventory.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return id == 0 ? this.leftTank.getFluidAmount() : (id == 1 ? this.rightTank.getFluidAmount() : 0);
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            if (this.leftTank.getFluid() == null) {
                return;
            }
            this.leftTank.getFluid().amount = value;
        }
        if (id == 1) {
            if (this.rightTank.getFluid() == null) {
                return;
            }
            this.rightTank.getFluid().amount = value;
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public String func_70005_c_() {
        return "InventoryTravelersBackpack";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public BlockPos getPosition() {
        return this.player.func_180425_c();
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 50, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 52, this.player);
    }

    public void sendPacket() {
        if (!this.player.field_70170_p.field_72995_K) {
            TravelersBackpack.NETWORK.sendToAllTracking((IMessage)new SyncBackpackCapabilityMP(this.stack.func_77955_b(new NBTTagCompound()), this.player.func_145782_y()), (Entity)this.player);
        }
    }

    @Override
    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return stack.func_77978_p();
    }
}

