/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tiviacz.travelersbackpack.items.ItemTravelersBackpack;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessBackpackRecipe
extends ShapelessOreRecipe {
    public ShapelessBackpackRecipe(@Nullable ResourceLocation group, NonNullList<Ingredient> input, ItemStack result) {
        super(group, input, result);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack output = super.func_77572_b(inv);
        if (!output.func_190926_b()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack ingredient = inv.func_70301_a(i);
                if (ingredient.func_190926_b() || !(ingredient.func_77973_b() instanceof ItemTravelersBackpack)) continue;
                NBTTagCompound tag = ingredient.func_77978_p();
                output.func_77982_d(tag);
                break;
            }
        }
        return output;
    }

    private ItemStack damageShears(ItemStack stack) {
        EntityPlayer craftingPlayer = ForgeHooks.getCraftingPlayer();
        if (stack.func_96631_a(1, craftingPlayer == null ? new Random() : craftingPlayer.field_70170_p.field_73012_v, craftingPlayer instanceof EntityPlayerMP ? (EntityPlayerMP)craftingPlayer : null)) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)craftingPlayer, (ItemStack)stack, null);
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventoryCrafting) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemShears) {
                remainingItems.set(i, (Object)this.damageShears(itemstack.func_77946_l()));
                continue;
            }
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return remainingItems;
    }

    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Factory.parseShapeless(context, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new ShapelessBackpackRecipe(group.isEmpty() ? null : new ResourceLocation(group), ingredients, result);
        }

        public static NonNullList<Ingredient> parseShapeless(JsonContext context, JsonObject json) {
            NonNullList ingredients = NonNullList.func_191196_a();
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            return ingredients;
        }
    }
}

